# **********************************************************************
#
# Copyright (c) 2003-2005 ZeroC, Inc. All rights reserved.
#
# This copy of Ice is licensed to you under the terms described in the
# ICE_LICENSE file included in this distribution.
#
# **********************************************************************

# Ice version 3.1.0
# Generated from file `Admin.ice'

import Ice, IcePy, __builtin__
import Ice_Identity_ice
import Ice_BuiltinSequences_ice
import Ice_SliceChecksumDict_ice
import Glacier2_Session_ice
import IceGrid_Exception_ice
import IceGrid_Descriptor_ice

# Included module Ice
_M_Ice = Ice.openModule('Ice')

# Included module Glacier2
_M_Glacier2 = Ice.openModule('Glacier2')

# Included module IceGrid
_M_IceGrid = Ice.openModule('IceGrid')

# Start of module IceGrid
__name__ = 'IceGrid'

if not _M_IceGrid.__dict__.has_key('ServerState'):
    _M_IceGrid.ServerState = Ice.createTempClass()
    class ServerState(object):

        def __init__(self, val):
            assert(val >= 0 and val < 6)
            self.value = val

        def __str__(self):
            if self.value == 0:
                return 'Inactive'
            elif self.value == 1:
                return 'Activating'
            elif self.value == 2:
                return 'Active'
            elif self.value == 3:
                return 'Deactivating'
            elif self.value == 4:
                return 'Destroying'
            elif self.value == 5:
                return 'Destroyed'
            return None

        __repr__ = __str__

        def __hash__(self):
            return self.value

        def __cmp__(self, other):
            return cmp(self.value, other.value)

    ServerState.Inactive = ServerState(0)
    ServerState.Activating = ServerState(1)
    ServerState.Active = ServerState(2)
    ServerState.Deactivating = ServerState(3)
    ServerState.Destroying = ServerState(4)
    ServerState.Destroyed = ServerState(5)

    _M_IceGrid._t_ServerState = IcePy.defineEnum('::IceGrid::ServerState', ServerState, (ServerState.Inactive, ServerState.Activating, ServerState.Active, ServerState.Deactivating, ServerState.Destroying, ServerState.Destroyed))

    _M_IceGrid.ServerState = ServerState
    del ServerState

if not _M_IceGrid.__dict__.has_key('_t_StringObjectProxyDict'):
    _M_IceGrid._t_StringObjectProxyDict = IcePy.defineDictionary('::IceGrid::StringObjectProxyDict', IcePy._t_string, IcePy._t_ObjectPrx)

if not _M_IceGrid.__dict__.has_key('ObjectInfo'):
    _M_IceGrid.ObjectInfo = Ice.createTempClass()
    class ObjectInfo(object):
        def __init__(self, proxy=None, type=''):
            self.proxy = proxy
            self.type = type

        def __hash__(self):
            _h = 0
            _h = 5 * _h + __builtin__.hash(self.proxy)
            _h = 5 * _h + __builtin__.hash(self.type)
            return _h % 0x7fffffff

        def __eq__(self, other):
            if not self.proxy == other.proxy:
                return False
            if not self.type == other.type:
                return False
            return True

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_ObjectInfo)

        __repr__ = __str__

    _M_IceGrid._t_ObjectInfo = IcePy.defineStruct('::IceGrid::ObjectInfo', ObjectInfo, (
        ("proxy", IcePy._t_ObjectPrx),
        ("type", IcePy._t_string)
    ))

    _M_IceGrid.ObjectInfo = ObjectInfo
    del ObjectInfo

if not _M_IceGrid.__dict__.has_key('_t_ObjectInfoSeq'):
    _M_IceGrid._t_ObjectInfoSeq = IcePy.defineSequence('::IceGrid::ObjectInfoSeq', _M_IceGrid._t_ObjectInfo)

if not _M_IceGrid.__dict__.has_key('AdapterInfo'):
    _M_IceGrid.AdapterInfo = Ice.createTempClass()
    class AdapterInfo(object):
        def __init__(self, id='', proxy=None, replicaGroupId=''):
            self.id = id
            self.proxy = proxy
            self.replicaGroupId = replicaGroupId

        def __hash__(self):
            _h = 0
            _h = 5 * _h + __builtin__.hash(self.id)
            _h = 5 * _h + __builtin__.hash(self.proxy)
            _h = 5 * _h + __builtin__.hash(self.replicaGroupId)
            return _h % 0x7fffffff

        def __eq__(self, other):
            if not self.id == other.id:
                return False
            if not self.proxy == other.proxy:
                return False
            if not self.replicaGroupId == other.replicaGroupId:
                return False
            return True

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_AdapterInfo)

        __repr__ = __str__

    _M_IceGrid._t_AdapterInfo = IcePy.defineStruct('::IceGrid::AdapterInfo', AdapterInfo, (
        ("id", IcePy._t_string),
        ("proxy", IcePy._t_ObjectPrx),
        ("replicaGroupId", IcePy._t_string)
    ))

    _M_IceGrid.AdapterInfo = AdapterInfo
    del AdapterInfo

if not _M_IceGrid.__dict__.has_key('_t_AdapterInfoSeq'):
    _M_IceGrid._t_AdapterInfoSeq = IcePy.defineSequence('::IceGrid::AdapterInfoSeq', _M_IceGrid._t_AdapterInfo)

if not _M_IceGrid.__dict__.has_key('ServerInfo'):
    _M_IceGrid.ServerInfo = Ice.createTempClass()
    class ServerInfo(object):
        def __init__(self, application='', node='', descriptor=None):
            self.application = application
            self.node = node
            self.descriptor = descriptor

        def __hash__(self):
            _h = 0
            _h = 5 * _h + __builtin__.hash(self.application)
            _h = 5 * _h + __builtin__.hash(self.node)
            _h = 5 * _h + __builtin__.hash(self.descriptor)
            return _h % 0x7fffffff

        def __eq__(self, other):
            if not self.application == other.application:
                return False
            if not self.node == other.node:
                return False
            if not self.descriptor == other.descriptor:
                return False
            return True

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_ServerInfo)

        __repr__ = __str__

    _M_IceGrid._t_ServerInfo = IcePy.defineStruct('::IceGrid::ServerInfo', ServerInfo, (
        ("application", IcePy._t_string),
        ("node", IcePy._t_string),
        ("descriptor", _M_IceGrid._t_ServerDescriptor)
    ))

    _M_IceGrid.ServerInfo = ServerInfo
    del ServerInfo

if not _M_IceGrid.__dict__.has_key('NodeInfo'):
    _M_IceGrid.NodeInfo = Ice.createTempClass()
    class NodeInfo(object):
        def __init__(self, os='', hostname='', release='', version='', machine='', nProcessors=0, dataDir=''):
            self.os = os
            self.hostname = hostname
            self.release = release
            self.version = version
            self.machine = machine
            self.nProcessors = nProcessors
            self.dataDir = dataDir

        def __hash__(self):
            _h = 0
            _h = 5 * _h + __builtin__.hash(self.os)
            _h = 5 * _h + __builtin__.hash(self.hostname)
            _h = 5 * _h + __builtin__.hash(self.release)
            _h = 5 * _h + __builtin__.hash(self.version)
            _h = 5 * _h + __builtin__.hash(self.machine)
            _h = 5 * _h + __builtin__.hash(self.nProcessors)
            _h = 5 * _h + __builtin__.hash(self.dataDir)
            return _h % 0x7fffffff

        def __eq__(self, other):
            if not self.os == other.os:
                return False
            if not self.hostname == other.hostname:
                return False
            if not self.release == other.release:
                return False
            if not self.version == other.version:
                return False
            if not self.machine == other.machine:
                return False
            if not self.nProcessors == other.nProcessors:
                return False
            if not self.dataDir == other.dataDir:
                return False
            return True

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_NodeInfo)

        __repr__ = __str__

    _M_IceGrid._t_NodeInfo = IcePy.defineStruct('::IceGrid::NodeInfo', NodeInfo, (
        ("os", IcePy._t_string),
        ("hostname", IcePy._t_string),
        ("release", IcePy._t_string),
        ("version", IcePy._t_string),
        ("machine", IcePy._t_string),
        ("nProcessors", IcePy._t_int),
        ("dataDir", IcePy._t_string)
    ))

    _M_IceGrid.NodeInfo = NodeInfo
    del NodeInfo

if not _M_IceGrid.__dict__.has_key('LoadInfo'):
    _M_IceGrid.LoadInfo = Ice.createTempClass()
    class LoadInfo(object):
        def __init__(self, avg1=0.0, avg5=0.0, avg15=0.0):
            self.avg1 = avg1
            self.avg5 = avg5
            self.avg15 = avg15

        def __hash__(self):
            _h = 0
            _h = 5 * _h + __builtin__.hash(self.avg1)
            _h = 5 * _h + __builtin__.hash(self.avg5)
            _h = 5 * _h + __builtin__.hash(self.avg15)
            return _h % 0x7fffffff

        def __eq__(self, other):
            if not self.avg1 == other.avg1:
                return False
            if not self.avg5 == other.avg5:
                return False
            if not self.avg15 == other.avg15:
                return False
            return True

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_LoadInfo)

        __repr__ = __str__

    _M_IceGrid._t_LoadInfo = IcePy.defineStruct('::IceGrid::LoadInfo', LoadInfo, (
        ("avg1", IcePy._t_float),
        ("avg5", IcePy._t_float),
        ("avg15", IcePy._t_float)
    ))

    _M_IceGrid.LoadInfo = LoadInfo
    del LoadInfo

if not _M_IceGrid.__dict__.has_key('Admin'):
    _M_IceGrid.Admin = Ice.createTempClass()
    class Admin(Ice.Object):
        def __init__(self):
            if __builtin__.type(self) == _M_IceGrid.Admin:
                raise RuntimeError('IceGrid.Admin is an abstract class')

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::IceGrid::Admin')

        def ice_id(self, current=None):
            return '::IceGrid::Admin'

        #
        # Operation signatures.
        #
        # def addApplication(self, descriptor, current=None):
        # def syncApplication(self, descriptor, current=None):
        # def updateApplication(self, descriptor, current=None):
        # def removeApplication(self, name, current=None):
        # def instantiateServer(self, application, node, desc, current=None):
        # def patchApplication_async(self, _cb, name, shutdown, current=None):
        # def getApplicationDescriptor(self, name, current=None):
        # def getDefaultApplicationDescriptor(self, current=None):
        # def getAllApplicationNames(self, current=None):
        # def getServerInfo(self, id, current=None):
        # def getServerState(self, id, current=None):
        # def getServerPid(self, id, current=None):
        # def enableServer(self, id, enabled, current=None):
        # def isServerEnabled(self, id, current=None):
        # def startServer(self, id, current=None):
        # def stopServer(self, id, current=None):
        # def patchServer_async(self, _cb, id, shutdown, current=None):
        # def sendSignal(self, id, signal, current=None):
        # def writeMessage(self, id, message, fd, current=None):
        # def getAllServerIds(self, current=None):
        # def getAdapterInfo(self, id, current=None):
        # def removeAdapter(self, adapterId, current=None):
        # def getAllAdapterIds(self, current=None):
        # def addObject(self, obj, current=None):
        # def updateObject(self, obj, current=None):
        # def addObjectWithType(self, obj, type, current=None):
        # def removeObject(self, id, current=None):
        # def getObjectInfo(self, id, current=None):
        # def getObjectInfosByType(self, type, current=None):
        # def getAllObjectInfos(self, expr, current=None):
        # def pingNode(self, name, current=None):
        # def getNodeLoad(self, name, current=None):
        # def getNodeInfo(self, name, current=None):
        # def shutdownNode(self, name, current=None):
        # def getNodeHostname(self, name, current=None):
        # def getAllNodeNames(self, current=None):
        # def shutdown(self, current=None):
        # def getSliceChecksums(self, current=None):

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_Admin)

        __repr__ = __str__

    _M_IceGrid.AdminPrx = Ice.createTempClass()
    class AdminPrx(Ice.ObjectPrx):

        def addApplication(self, descriptor, _ctx=None):
            return _M_IceGrid.Admin._op_addApplication.invoke(self, (descriptor, ), _ctx)

        def syncApplication(self, descriptor, _ctx=None):
            return _M_IceGrid.Admin._op_syncApplication.invoke(self, (descriptor, ), _ctx)

        def updateApplication(self, descriptor, _ctx=None):
            return _M_IceGrid.Admin._op_updateApplication.invoke(self, (descriptor, ), _ctx)

        def removeApplication(self, name, _ctx=None):
            return _M_IceGrid.Admin._op_removeApplication.invoke(self, (name, ), _ctx)

        def instantiateServer(self, application, node, desc, _ctx=None):
            return _M_IceGrid.Admin._op_instantiateServer.invoke(self, (application, node, desc), _ctx)

        def patchApplication(self, name, shutdown, _ctx=None):
            return _M_IceGrid.Admin._op_patchApplication.invoke(self, (name, shutdown), _ctx)

        def patchApplication_async(self, _cb, name, shutdown, _ctx=None):
            return _M_IceGrid.Admin._op_patchApplication.invokeAsync(self, _cb, (name, shutdown), _ctx)

        def getApplicationDescriptor(self, name, _ctx=None):
            return _M_IceGrid.Admin._op_getApplicationDescriptor.invoke(self, (name, ), _ctx)

        def getDefaultApplicationDescriptor(self, _ctx=None):
            return _M_IceGrid.Admin._op_getDefaultApplicationDescriptor.invoke(self, (), _ctx)

        def getAllApplicationNames(self, _ctx=None):
            return _M_IceGrid.Admin._op_getAllApplicationNames.invoke(self, (), _ctx)

        def getServerInfo(self, id, _ctx=None):
            return _M_IceGrid.Admin._op_getServerInfo.invoke(self, (id, ), _ctx)

        def getServerState(self, id, _ctx=None):
            return _M_IceGrid.Admin._op_getServerState.invoke(self, (id, ), _ctx)

        def getServerPid(self, id, _ctx=None):
            return _M_IceGrid.Admin._op_getServerPid.invoke(self, (id, ), _ctx)

        def enableServer(self, id, enabled, _ctx=None):
            return _M_IceGrid.Admin._op_enableServer.invoke(self, (id, enabled), _ctx)

        def enableServer_async(self, _cb, id, enabled, _ctx=None):
            return _M_IceGrid.Admin._op_enableServer.invokeAsync(self, _cb, (id, enabled), _ctx)

        def isServerEnabled(self, id, _ctx=None):
            return _M_IceGrid.Admin._op_isServerEnabled.invoke(self, (id, ), _ctx)

        def startServer(self, id, _ctx=None):
            return _M_IceGrid.Admin._op_startServer.invoke(self, (id, ), _ctx)

        def startServer_async(self, _cb, id, _ctx=None):
            return _M_IceGrid.Admin._op_startServer.invokeAsync(self, _cb, (id, ), _ctx)

        def stopServer(self, id, _ctx=None):
            return _M_IceGrid.Admin._op_stopServer.invoke(self, (id, ), _ctx)

        def stopServer_async(self, _cb, id, _ctx=None):
            return _M_IceGrid.Admin._op_stopServer.invokeAsync(self, _cb, (id, ), _ctx)

        def patchServer(self, id, shutdown, _ctx=None):
            return _M_IceGrid.Admin._op_patchServer.invoke(self, (id, shutdown), _ctx)

        def patchServer_async(self, _cb, id, shutdown, _ctx=None):
            return _M_IceGrid.Admin._op_patchServer.invokeAsync(self, _cb, (id, shutdown), _ctx)

        def sendSignal(self, id, signal, _ctx=None):
            return _M_IceGrid.Admin._op_sendSignal.invoke(self, (id, signal), _ctx)

        def writeMessage(self, id, message, fd, _ctx=None):
            return _M_IceGrid.Admin._op_writeMessage.invoke(self, (id, message, fd), _ctx)

        def getAllServerIds(self, _ctx=None):
            return _M_IceGrid.Admin._op_getAllServerIds.invoke(self, (), _ctx)

        def getAdapterInfo(self, id, _ctx=None):
            return _M_IceGrid.Admin._op_getAdapterInfo.invoke(self, (id, ), _ctx)

        def removeAdapter(self, adapterId, _ctx=None):
            return _M_IceGrid.Admin._op_removeAdapter.invoke(self, (adapterId, ), _ctx)

        def removeAdapter_async(self, _cb, adapterId, _ctx=None):
            return _M_IceGrid.Admin._op_removeAdapter.invokeAsync(self, _cb, (adapterId, ), _ctx)

        def getAllAdapterIds(self, _ctx=None):
            return _M_IceGrid.Admin._op_getAllAdapterIds.invoke(self, (), _ctx)

        def addObject(self, obj, _ctx=None):
            return _M_IceGrid.Admin._op_addObject.invoke(self, (obj, ), _ctx)

        def updateObject(self, obj, _ctx=None):
            return _M_IceGrid.Admin._op_updateObject.invoke(self, (obj, ), _ctx)

        def addObjectWithType(self, obj, type, _ctx=None):
            return _M_IceGrid.Admin._op_addObjectWithType.invoke(self, (obj, type), _ctx)

        def removeObject(self, id, _ctx=None):
            return _M_IceGrid.Admin._op_removeObject.invoke(self, (id, ), _ctx)

        def removeObject_async(self, _cb, id, _ctx=None):
            return _M_IceGrid.Admin._op_removeObject.invokeAsync(self, _cb, (id, ), _ctx)

        def getObjectInfo(self, id, _ctx=None):
            return _M_IceGrid.Admin._op_getObjectInfo.invoke(self, (id, ), _ctx)

        def getObjectInfosByType(self, type, _ctx=None):
            return _M_IceGrid.Admin._op_getObjectInfosByType.invoke(self, (type, ), _ctx)

        def getAllObjectInfos(self, expr, _ctx=None):
            return _M_IceGrid.Admin._op_getAllObjectInfos.invoke(self, (expr, ), _ctx)

        def pingNode(self, name, _ctx=None):
            return _M_IceGrid.Admin._op_pingNode.invoke(self, (name, ), _ctx)

        def getNodeLoad(self, name, _ctx=None):
            return _M_IceGrid.Admin._op_getNodeLoad.invoke(self, (name, ), _ctx)

        def getNodeLoad_async(self, _cb, name, _ctx=None):
            return _M_IceGrid.Admin._op_getNodeLoad.invokeAsync(self, _cb, (name, ), _ctx)

        def getNodeInfo(self, name, _ctx=None):
            return _M_IceGrid.Admin._op_getNodeInfo.invoke(self, (name, ), _ctx)

        def shutdownNode(self, name, _ctx=None):
            return _M_IceGrid.Admin._op_shutdownNode.invoke(self, (name, ), _ctx)

        def shutdownNode_async(self, _cb, name, _ctx=None):
            return _M_IceGrid.Admin._op_shutdownNode.invokeAsync(self, _cb, (name, ), _ctx)

        def getNodeHostname(self, name, _ctx=None):
            return _M_IceGrid.Admin._op_getNodeHostname.invoke(self, (name, ), _ctx)

        def getAllNodeNames(self, _ctx=None):
            return _M_IceGrid.Admin._op_getAllNodeNames.invoke(self, (), _ctx)

        def shutdown(self, _ctx=None):
            return _M_IceGrid.Admin._op_shutdown.invoke(self, (), _ctx)

        def getSliceChecksums(self, _ctx=None):
            return _M_IceGrid.Admin._op_getSliceChecksums.invoke(self, (), _ctx)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_IceGrid.AdminPrx.ice_checkedCast(proxy, '::IceGrid::Admin', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=''):
            return _M_IceGrid.AdminPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

    _M_IceGrid._t_AdminPrx = IcePy.defineProxy('::IceGrid::Admin', AdminPrx)

    _M_IceGrid._t_Admin = IcePy.defineClass('::IceGrid::Admin', Admin, True, None, (), ())
    Admin.ice_type = _M_IceGrid._t_Admin

    Admin._op_addApplication = IcePy.Operation('addApplication', Ice.OperationMode.Normal, False, (_M_IceGrid._t_ApplicationDescriptor,), (), None, (_M_IceGrid._t_AccessDeniedException, _M_IceGrid._t_DeploymentException))
    Admin._op_syncApplication = IcePy.Operation('syncApplication', Ice.OperationMode.Normal, False, (_M_IceGrid._t_ApplicationDescriptor,), (), None, (_M_IceGrid._t_AccessDeniedException, _M_IceGrid._t_DeploymentException, _M_IceGrid._t_ApplicationNotExistException))
    Admin._op_updateApplication = IcePy.Operation('updateApplication', Ice.OperationMode.Normal, False, (_M_IceGrid._t_ApplicationUpdateDescriptor,), (), None, (_M_IceGrid._t_AccessDeniedException, _M_IceGrid._t_DeploymentException, _M_IceGrid._t_ApplicationNotExistException))
    Admin._op_removeApplication = IcePy.Operation('removeApplication', Ice.OperationMode.Normal, False, (IcePy._t_string,), (), None, (_M_IceGrid._t_AccessDeniedException, _M_IceGrid._t_ApplicationNotExistException))
    Admin._op_instantiateServer = IcePy.Operation('instantiateServer', Ice.OperationMode.Normal, False, (IcePy._t_string, IcePy._t_string, _M_IceGrid._t_ServerInstanceDescriptor), (), None, (_M_IceGrid._t_AccessDeniedException, _M_IceGrid._t_ApplicationNotExistException, _M_IceGrid._t_DeploymentException))
    Admin._op_patchApplication = IcePy.Operation('patchApplication', Ice.OperationMode.Normal, True, (IcePy._t_string, IcePy._t_bool), (), None, (_M_IceGrid._t_ApplicationNotExistException, _M_IceGrid._t_PatchException))
    Admin._op_getApplicationDescriptor = IcePy.Operation('getApplicationDescriptor', Ice.OperationMode.Nonmutating, False, (IcePy._t_string,), (), _M_IceGrid._t_ApplicationDescriptor, (_M_IceGrid._t_ApplicationNotExistException,))
    Admin._op_getDefaultApplicationDescriptor = IcePy.Operation('getDefaultApplicationDescriptor', Ice.OperationMode.Nonmutating, False, (), (), _M_IceGrid._t_ApplicationDescriptor, (_M_IceGrid._t_DeploymentException,))
    Admin._op_getAllApplicationNames = IcePy.Operation('getAllApplicationNames', Ice.OperationMode.Nonmutating, False, (), (), _M_Ice._t_StringSeq, ())
    Admin._op_getServerInfo = IcePy.Operation('getServerInfo', Ice.OperationMode.Nonmutating, False, (IcePy._t_string,), (), _M_IceGrid._t_ServerInfo, (_M_IceGrid._t_ServerNotExistException,))
    Admin._op_getServerState = IcePy.Operation('getServerState', Ice.OperationMode.Nonmutating, False, (IcePy._t_string,), (), _M_IceGrid._t_ServerState, (_M_IceGrid._t_ServerNotExistException, _M_IceGrid._t_NodeUnreachableException, _M_IceGrid._t_DeploymentException))
    Admin._op_getServerPid = IcePy.Operation('getServerPid', Ice.OperationMode.Nonmutating, False, (IcePy._t_string,), (), IcePy._t_int, (_M_IceGrid._t_ServerNotExistException, _M_IceGrid._t_NodeUnreachableException, _M_IceGrid._t_DeploymentException))
    Admin._op_enableServer = IcePy.Operation('enableServer', Ice.OperationMode.Idempotent, False, (IcePy._t_string, IcePy._t_bool), (), None, (_M_IceGrid._t_ServerNotExistException, _M_IceGrid._t_NodeUnreachableException, _M_IceGrid._t_DeploymentException))
    Admin._op_isServerEnabled = IcePy.Operation('isServerEnabled', Ice.OperationMode.Nonmutating, False, (IcePy._t_string,), (), IcePy._t_bool, (_M_IceGrid._t_ServerNotExistException, _M_IceGrid._t_NodeUnreachableException, _M_IceGrid._t_DeploymentException))
    Admin._op_startServer = IcePy.Operation('startServer', Ice.OperationMode.Normal, False, (IcePy._t_string,), (), None, (_M_IceGrid._t_ServerNotExistException, _M_IceGrid._t_ServerStartException, _M_IceGrid._t_NodeUnreachableException, _M_IceGrid._t_DeploymentException))
    Admin._op_stopServer = IcePy.Operation('stopServer', Ice.OperationMode.Normal, False, (IcePy._t_string,), (), None, (_M_IceGrid._t_ServerNotExistException, _M_IceGrid._t_ServerStopException, _M_IceGrid._t_NodeUnreachableException, _M_IceGrid._t_DeploymentException))
    Admin._op_patchServer = IcePy.Operation('patchServer', Ice.OperationMode.Normal, True, (IcePy._t_string, IcePy._t_bool), (), None, (_M_IceGrid._t_ServerNotExistException, _M_IceGrid._t_NodeUnreachableException, _M_IceGrid._t_DeploymentException, _M_IceGrid._t_PatchException))
    Admin._op_sendSignal = IcePy.Operation('sendSignal', Ice.OperationMode.Normal, False, (IcePy._t_string, IcePy._t_string), (), None, (_M_IceGrid._t_ServerNotExistException, _M_IceGrid._t_NodeUnreachableException, _M_IceGrid._t_DeploymentException, _M_IceGrid._t_BadSignalException))
    Admin._op_writeMessage = IcePy.Operation('writeMessage', Ice.OperationMode.Normal, False, (IcePy._t_string, IcePy._t_string, IcePy._t_int), (), None, (_M_IceGrid._t_ServerNotExistException, _M_IceGrid._t_NodeUnreachableException, _M_IceGrid._t_DeploymentException))
    Admin._op_getAllServerIds = IcePy.Operation('getAllServerIds', Ice.OperationMode.Nonmutating, False, (), (), _M_Ice._t_StringSeq, ())
    Admin._op_getAdapterInfo = IcePy.Operation('getAdapterInfo', Ice.OperationMode.Nonmutating, False, (IcePy._t_string,), (), _M_IceGrid._t_AdapterInfoSeq, (_M_IceGrid._t_AdapterNotExistException,))
    Admin._op_removeAdapter = IcePy.Operation('removeAdapter', Ice.OperationMode.Normal, False, (IcePy._t_string,), (), None, (_M_IceGrid._t_AdapterNotExistException, _M_IceGrid._t_DeploymentException))
    Admin._op_getAllAdapterIds = IcePy.Operation('getAllAdapterIds', Ice.OperationMode.Nonmutating, False, (), (), _M_Ice._t_StringSeq, ())
    Admin._op_addObject = IcePy.Operation('addObject', Ice.OperationMode.Normal, False, (IcePy._t_ObjectPrx,), (), None, (_M_IceGrid._t_ObjectExistsException, _M_IceGrid._t_DeploymentException))
    Admin._op_updateObject = IcePy.Operation('updateObject', Ice.OperationMode.Normal, False, (IcePy._t_ObjectPrx,), (), None, (_M_IceGrid._t_ObjectNotRegisteredException, _M_IceGrid._t_DeploymentException))
    Admin._op_addObjectWithType = IcePy.Operation('addObjectWithType', Ice.OperationMode.Normal, False, (IcePy._t_ObjectPrx, IcePy._t_string), (), None, (_M_IceGrid._t_ObjectExistsException,))
    Admin._op_removeObject = IcePy.Operation('removeObject', Ice.OperationMode.Normal, False, (_M_Ice._t_Identity,), (), None, (_M_IceGrid._t_ObjectNotRegisteredException, _M_IceGrid._t_DeploymentException))
    Admin._op_getObjectInfo = IcePy.Operation('getObjectInfo', Ice.OperationMode.Nonmutating, False, (_M_Ice._t_Identity,), (), _M_IceGrid._t_ObjectInfo, (_M_IceGrid._t_ObjectNotRegisteredException,))
    Admin._op_getObjectInfosByType = IcePy.Operation('getObjectInfosByType', Ice.OperationMode.Nonmutating, False, (IcePy._t_string,), (), _M_IceGrid._t_ObjectInfoSeq, ())
    Admin._op_getAllObjectInfos = IcePy.Operation('getAllObjectInfos', Ice.OperationMode.Nonmutating, False, (IcePy._t_string,), (), _M_IceGrid._t_ObjectInfoSeq, ())
    Admin._op_pingNode = IcePy.Operation('pingNode', Ice.OperationMode.Nonmutating, False, (IcePy._t_string,), (), IcePy._t_bool, (_M_IceGrid._t_NodeNotExistException,))
    Admin._op_getNodeLoad = IcePy.Operation('getNodeLoad', Ice.OperationMode.Nonmutating, False, (IcePy._t_string,), (), _M_IceGrid._t_LoadInfo, (_M_IceGrid._t_NodeNotExistException, _M_IceGrid._t_NodeUnreachableException))
    Admin._op_getNodeInfo = IcePy.Operation('getNodeInfo', Ice.OperationMode.Nonmutating, False, (IcePy._t_string,), (), _M_IceGrid._t_NodeInfo, (_M_IceGrid._t_NodeNotExistException, _M_IceGrid._t_NodeUnreachableException))
    Admin._op_shutdownNode = IcePy.Operation('shutdownNode', Ice.OperationMode.Idempotent, False, (IcePy._t_string,), (), None, (_M_IceGrid._t_NodeNotExistException, _M_IceGrid._t_NodeUnreachableException))
    Admin._op_getNodeHostname = IcePy.Operation('getNodeHostname', Ice.OperationMode.Nonmutating, False, (IcePy._t_string,), (), IcePy._t_string, (_M_IceGrid._t_NodeNotExistException, _M_IceGrid._t_NodeUnreachableException))
    Admin._op_getAllNodeNames = IcePy.Operation('getAllNodeNames', Ice.OperationMode.Nonmutating, False, (), (), _M_Ice._t_StringSeq, ())
    Admin._op_shutdown = IcePy.Operation('shutdown', Ice.OperationMode.Idempotent, False, (), (), None, ())
    Admin._op_getSliceChecksums = IcePy.Operation('getSliceChecksums', Ice.OperationMode.Nonmutating, False, (), (), _M_Ice._t_SliceChecksumDict, ())

    _M_IceGrid.Admin = Admin
    del Admin

    _M_IceGrid.AdminPrx = AdminPrx
    del AdminPrx

if not _M_IceGrid.__dict__.has_key('RegistryObserver'):
    _M_IceGrid._t_RegistryObserver = IcePy.declareClass('::IceGrid::RegistryObserver')
    _M_IceGrid._t_RegistryObserverPrx = IcePy.declareProxy('::IceGrid::RegistryObserver')

if not _M_IceGrid.__dict__.has_key('NodeObserver'):
    _M_IceGrid._t_NodeObserver = IcePy.declareClass('::IceGrid::NodeObserver')
    _M_IceGrid._t_NodeObserverPrx = IcePy.declareProxy('::IceGrid::NodeObserver')

if not _M_IceGrid.__dict__.has_key('AdminSession'):
    _M_IceGrid.AdminSession = Ice.createTempClass()
    class AdminSession(_M_Glacier2.Session):
        def __init__(self):
            if __builtin__.type(self) == _M_IceGrid.AdminSession:
                raise RuntimeError('IceGrid.AdminSession is an abstract class')

        def ice_ids(self, current=None):
            return ('::Glacier2::Session', '::Ice::Object', '::IceGrid::AdminSession')

        def ice_id(self, current=None):
            return '::IceGrid::AdminSession'

        #
        # Operation signatures.
        #
        # def keepAlive(self, current=None):
        # def getAdmin(self, current=None):
        # def setObservers(self, registryObs, nodeObs, current=None):
        # def setObserversByIdentity(self, registryObs, nodeObs, current=None):
        # def startUpdate(self, current=None):
        # def finishUpdate(self, current=None):

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_AdminSession)

        __repr__ = __str__

    _M_IceGrid.AdminSessionPrx = Ice.createTempClass()
    class AdminSessionPrx(_M_Glacier2.SessionPrx):

        def keepAlive(self, _ctx=None):
            return _M_IceGrid.AdminSession._op_keepAlive.invoke(self, (), _ctx)

        def getAdmin(self, _ctx=None):
            return _M_IceGrid.AdminSession._op_getAdmin.invoke(self, (), _ctx)

        def setObservers(self, registryObs, nodeObs, _ctx=None):
            return _M_IceGrid.AdminSession._op_setObservers.invoke(self, (registryObs, nodeObs), _ctx)

        def setObserversByIdentity(self, registryObs, nodeObs, _ctx=None):
            return _M_IceGrid.AdminSession._op_setObserversByIdentity.invoke(self, (registryObs, nodeObs), _ctx)

        def startUpdate(self, _ctx=None):
            return _M_IceGrid.AdminSession._op_startUpdate.invoke(self, (), _ctx)

        def finishUpdate(self, _ctx=None):
            return _M_IceGrid.AdminSession._op_finishUpdate.invoke(self, (), _ctx)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_IceGrid.AdminSessionPrx.ice_checkedCast(proxy, '::IceGrid::AdminSession', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=''):
            return _M_IceGrid.AdminSessionPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

    _M_IceGrid._t_AdminSessionPrx = IcePy.defineProxy('::IceGrid::AdminSession', AdminSessionPrx)

    _M_IceGrid._t_AdminSession = IcePy.defineClass('::IceGrid::AdminSession', AdminSession, True, None, (_M_Glacier2._t_Session,), ())
    AdminSession.ice_type = _M_IceGrid._t_AdminSession

    AdminSession._op_keepAlive = IcePy.Operation('keepAlive', Ice.OperationMode.Idempotent, False, (), (), None, ())
    AdminSession._op_getAdmin = IcePy.Operation('getAdmin', Ice.OperationMode.Nonmutating, False, (), (), _M_IceGrid._t_AdminPrx, ())
    AdminSession._op_setObservers = IcePy.Operation('setObservers', Ice.OperationMode.Idempotent, False, (_M_IceGrid._t_RegistryObserverPrx, _M_IceGrid._t_NodeObserverPrx), (), None, ())
    AdminSession._op_setObserversByIdentity = IcePy.Operation('setObserversByIdentity', Ice.OperationMode.Idempotent, False, (_M_Ice._t_Identity, _M_Ice._t_Identity), (), None, ())
    AdminSession._op_startUpdate = IcePy.Operation('startUpdate', Ice.OperationMode.Normal, False, (), (), IcePy._t_int, (_M_IceGrid._t_AccessDeniedException,))
    AdminSession._op_finishUpdate = IcePy.Operation('finishUpdate', Ice.OperationMode.Normal, False, (), (), None, (_M_IceGrid._t_AccessDeniedException,))

    _M_IceGrid.AdminSession = AdminSession
    del AdminSession

    _M_IceGrid.AdminSessionPrx = AdminSessionPrx
    del AdminSessionPrx

# End of module IceGrid

Ice.sliceChecksums["::IceGrid::AdapterInfo"] = "a22de437e0d82d91cca7d476992b2a43"
Ice.sliceChecksums["::IceGrid::AdapterInfoSeq"] = "9fdbbb3c2d938b4e5f3bf5a21f234147"
Ice.sliceChecksums["::IceGrid::Admin"] = "a0b4bc385ff686ccfd4c91b529c06449"
Ice.sliceChecksums["::IceGrid::AdminSession"] = "18cedff31453a5dc4186c37528b453"
Ice.sliceChecksums["::IceGrid::LoadInfo"] = "c28c339f5af52a46ac64c33864ae6"
Ice.sliceChecksums["::IceGrid::NodeInfo"] = "edbe81791e5ad4b6e2c33c7b8b96cdfc"
Ice.sliceChecksums["::IceGrid::ObjectInfo"] = "6c8a382c348df5cbda50e58d87189e33"
Ice.sliceChecksums["::IceGrid::ObjectInfoSeq"] = "1491c01cb93b575c602baed26ed0f989"
Ice.sliceChecksums["::IceGrid::ServerInfo"] = "3c7d20d1d03edfd06a90e56ce5111"
Ice.sliceChecksums["::IceGrid::ServerState"] = "d9d47a7e2a864af82033e01c4ee165"
Ice.sliceChecksums["::IceGrid::StringObjectProxyDict"] = "978c325e58cebefb212e5ebde28acdc"
