// **********************************************************************
//
// Copyright (c) 2003-2011 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************

package test.Ice.slicing.exceptions;

import test.Ice.slicing.exceptions.serverAMD.Test.AMD_TestIntf_baseAsBase;
import test.Ice.slicing.exceptions.serverAMD.Test.AMD_TestIntf_knownDerivedAsBase;
import test.Ice.slicing.exceptions.serverAMD.Test.AMD_TestIntf_knownDerivedAsKnownDerived;
import test.Ice.slicing.exceptions.serverAMD.Test.AMD_TestIntf_knownIntermediateAsBase;
import test.Ice.slicing.exceptions.serverAMD.Test.AMD_TestIntf_knownIntermediateAsKnownIntermediate;
import test.Ice.slicing.exceptions.serverAMD.Test.AMD_TestIntf_knownMostDerivedAsBase;
import test.Ice.slicing.exceptions.serverAMD.Test.AMD_TestIntf_knownMostDerivedAsKnownIntermediate;
import test.Ice.slicing.exceptions.serverAMD.Test.AMD_TestIntf_knownMostDerivedAsKnownMostDerived;
import test.Ice.slicing.exceptions.serverAMD.Test.AMD_TestIntf_shutdown;
import test.Ice.slicing.exceptions.serverAMD.Test.AMD_TestIntf_unknownDerivedAsBase;
import test.Ice.slicing.exceptions.serverAMD.Test.AMD_TestIntf_unknownIntermediateAsBase;
import test.Ice.slicing.exceptions.serverAMD.Test.AMD_TestIntf_unknownMostDerived1AsBase;
import test.Ice.slicing.exceptions.serverAMD.Test.AMD_TestIntf_unknownMostDerived1AsKnownIntermediate;
import test.Ice.slicing.exceptions.serverAMD.Test.AMD_TestIntf_unknownMostDerived2AsBase;
import test.Ice.slicing.exceptions.serverAMD.Test.Base;
import test.Ice.slicing.exceptions.serverAMD.Test.KnownDerived;
import test.Ice.slicing.exceptions.serverAMD.Test.KnownIntermediate;
import test.Ice.slicing.exceptions.serverAMD.Test.KnownMostDerived;
import test.Ice.slicing.exceptions.serverAMD.Test.UnknownDerived;
import test.Ice.slicing.exceptions.serverAMD.Test.UnknownIntermediate;
import test.Ice.slicing.exceptions.serverAMD.Test.UnknownMostDerived1;
import test.Ice.slicing.exceptions.serverAMD.Test.UnknownMostDerived2;
import test.Ice.slicing.exceptions.serverAMD.Test._TestIntfDisp;

public final class AMDTestI extends _TestIntfDisp
{
    public
    AMDTestI()
    {
    }

    public void
    shutdown_async(AMD_TestIntf_shutdown cb, Ice.Current current)
    {
        current.adapter.getCommunicator().shutdown();
        cb.ice_response();
    }

    public void
    baseAsBase_async(AMD_TestIntf_baseAsBase cb, Ice.Current current)
        throws Base
    {
        Base b = new Base();
        b.b = "Base.b";
        cb.ice_exception(b);
    }

    public void
    unknownDerivedAsBase_async(AMD_TestIntf_unknownDerivedAsBase cb, Ice.Current current)
        throws Base
    {
        UnknownDerived d = new UnknownDerived();
        d.b = "UnknownDerived.b";
        d.ud = "UnknownDerived.ud";
        cb.ice_exception(d);
    }

    public void
    knownDerivedAsBase_async(AMD_TestIntf_knownDerivedAsBase cb, Ice.Current current)
        throws Base
    {
        KnownDerived d = new KnownDerived();
        d.b = "KnownDerived.b";
        d.kd = "KnownDerived.kd";
        cb.ice_exception(d);
    }

    public void
    knownDerivedAsKnownDerived_async(AMD_TestIntf_knownDerivedAsKnownDerived cb, Ice.Current current)
        throws KnownDerived
    {
        KnownDerived d = new KnownDerived();
        d.b = "KnownDerived.b";
        d.kd = "KnownDerived.kd";
        cb.ice_exception(d);
    }

    public void
    unknownIntermediateAsBase_async(AMD_TestIntf_unknownIntermediateAsBase cb, Ice.Current current)
        throws Base
    {
        UnknownIntermediate ui = new UnknownIntermediate();
        ui.b = "UnknownIntermediate.b";
        ui.ui = "UnknownIntermediate.ui";
        cb.ice_exception(ui);
    }

    public void
    knownIntermediateAsBase_async(AMD_TestIntf_knownIntermediateAsBase cb, Ice.Current current)
        throws Base
    {
        KnownIntermediate ki = new KnownIntermediate();
        ki.b = "KnownIntermediate.b";
        ki.ki = "KnownIntermediate.ki";
        cb.ice_exception(ki);
    }

    public void
    knownMostDerivedAsBase_async(AMD_TestIntf_knownMostDerivedAsBase cb, Ice.Current current)
        throws Base
    {
        KnownMostDerived kmd = new KnownMostDerived();
        kmd.b = "KnownMostDerived.b";
        kmd.ki = "KnownMostDerived.ki";
        kmd.kmd = "KnownMostDerived.kmd";
        cb.ice_exception(kmd);
    }

    public void
    knownIntermediateAsKnownIntermediate_async(AMD_TestIntf_knownIntermediateAsKnownIntermediate cb,
                                               Ice.Current current)
        throws KnownIntermediate
    {
        KnownIntermediate ki = new KnownIntermediate();
        ki.b = "KnownIntermediate.b";
        ki.ki = "KnownIntermediate.ki";
        cb.ice_exception(ki);
    }

    public void
    knownMostDerivedAsKnownIntermediate_async(AMD_TestIntf_knownMostDerivedAsKnownIntermediate cb,
                                              Ice.Current current)
        throws KnownIntermediate
    {
        KnownMostDerived kmd = new KnownMostDerived();
        kmd.b = "KnownMostDerived.b";
        kmd.ki = "KnownMostDerived.ki";
        kmd.kmd = "KnownMostDerived.kmd";
        cb.ice_exception(kmd);
    }

    public void
    knownMostDerivedAsKnownMostDerived_async(AMD_TestIntf_knownMostDerivedAsKnownMostDerived cb,
                                             Ice.Current current)
        throws KnownMostDerived
    {
        KnownMostDerived kmd = new KnownMostDerived();
        kmd.b = "KnownMostDerived.b";
        kmd.ki = "KnownMostDerived.ki";
        kmd.kmd = "KnownMostDerived.kmd";
        cb.ice_exception(kmd);
    }

    public void
    unknownMostDerived1AsBase_async(AMD_TestIntf_unknownMostDerived1AsBase cb, Ice.Current current)
        throws Base
    {
        UnknownMostDerived1 umd1 = new UnknownMostDerived1();
        umd1.b = "UnknownMostDerived1.b";
        umd1.ki = "UnknownMostDerived1.ki";
        umd1.umd1 = "UnknownMostDerived1.umd1";
        cb.ice_exception(umd1);
    }

    public void
    unknownMostDerived1AsKnownIntermediate_async(AMD_TestIntf_unknownMostDerived1AsKnownIntermediate cb,
                                                 Ice.Current current)
        throws KnownIntermediate
    {
        UnknownMostDerived1 umd1 = new UnknownMostDerived1();
        umd1.b = "UnknownMostDerived1.b";
        umd1.ki = "UnknownMostDerived1.ki";
        umd1.umd1 = "UnknownMostDerived1.umd1";
        cb.ice_exception(umd1);
    }

    public void
    unknownMostDerived2AsBase_async(AMD_TestIntf_unknownMostDerived2AsBase cb, Ice.Current current)
        throws Base
    {
        UnknownMostDerived2 umd2 = new UnknownMostDerived2();
        umd2.b = "UnknownMostDerived2.b";
        umd2.ui = "UnknownMostDerived2.ui";
        umd2.umd2 = "UnknownMostDerived2.umd2";
        cb.ice_exception(umd2);
    }
}
