/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectionLostException;
import Ice.LocalException;
import Ice.Logger;
import Ice.SocketException;
import Ice.TimeoutException;
import IceInternal.BasicStream;
import IceInternal.ByteBuffer;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.TraceLevels;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.SocketConnection;

public final class Transceiver {
    private SocketConnection _connection;
    private TraceLevels _traceLevels;
    private Logger _logger;
    private String _desc;
    private InputStream _in;
    private OutputStream _out;
    private volatile boolean _shutdown;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object;
        if (this._traceLevels.network >= 1) {
            object = "closing tcp connection\n" + this.toString();
            this._logger.trace(this._traceLevels.networkCat, (String)object);
        }
        object = this;
        synchronized (object) {
            try {
                this._connection.close();
            }
            catch (IOException iOException) {
                SocketException socketException = new SocketException();
                socketException.initCause(iOException);
                throw socketException;
            }
            finally {
                this._connection = null;
            }
        }
    }

    public void shutdownReadWrite() {
        if (this._traceLevels.network >= 2) {
            String string = "shutting down tcp connection for reading and writing\n" + this.toString();
            this._logger.trace(this._traceLevels.networkCat, string);
        }
        try {
            this._in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this._out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._shutdown = true;
    }

    public void write(BasicStream basicStream, int n) {
        if (n == 0) {
            n = 1;
        }
        if (n < 0) {
            this.writeImpl(basicStream);
        } else {
            WriteThread writeThread = new WriteThread(basicStream, n);
            writeThread.start();
            writeThread.write();
        }
    }

    protected void writeImpl(BasicStream basicStream) {
        ByteBuffer byteBuffer = basicStream.prepareWrite();
        byte[] byArray = byteBuffer.array();
        int n = 512;
        while (byteBuffer.hasRemaining() && !this._shutdown) {
            Object object;
            int n2 = byteBuffer.position();
            try {
                int n3 = byteBuffer.remaining();
                if (n > 0 && n < n3) {
                    n3 = n;
                }
                this._out.write(byArray, n2, n3);
                this._out.flush();
                byteBuffer.position(n2 + n3);
                if (this._traceLevels.network < 3) continue;
                object = "sent " + n3 + " of " + byteBuffer.limit() + " bytes via tcp\n" + this.toString();
                this._logger.trace(this._traceLevels.networkCat, (String)object);
            }
            catch (InterruptedIOException interruptedIOException) {
                byteBuffer.position(n2 + interruptedIOException.bytesTransferred);
            }
            catch (IOException iOException) {
                object = new SocketException();
                ((LocalException)object).initCause(iOException);
                throw object;
            }
        }
        if (this._shutdown && byteBuffer.hasRemaining()) {
            throw new ConnectionLostException();
        }
    }

    public void read(BasicStream basicStream, int n) {
        if (n == 0) {
            n = 1;
        }
        if (n < 0) {
            this.readImpl(basicStream);
        } else {
            ReadThread readThread = new ReadThread(basicStream, n);
            readThread.start();
            readThread.read();
        }
    }

    protected void readImpl(BasicStream basicStream) {
        ByteBuffer byteBuffer = basicStream.prepareRead();
        int n = 0;
        if (this._traceLevels.network >= 3) {
            n = byteBuffer.remaining();
        }
        byte[] byArray = byteBuffer.array();
        while (byteBuffer.hasRemaining() && !this._shutdown) {
            Object object;
            int n2 = byteBuffer.position();
            try {
                int n3 = this._in.read(byArray, n2, byteBuffer.remaining());
                if (n3 == -1) {
                    throw new ConnectionLostException();
                }
                if (n3 <= 0) continue;
                if (this._traceLevels.network >= 3) {
                    object = "received " + n3 + " of " + n + " bytes via tcp\n" + this.toString();
                    this._logger.trace(this._traceLevels.networkCat, (String)object);
                }
                byteBuffer.position(n2 + n3);
            }
            catch (InterruptedIOException interruptedIOException) {
                if (interruptedIOException.bytesTransferred <= 0) continue;
                byteBuffer.position(n2 + interruptedIOException.bytesTransferred);
            }
            catch (IOException iOException) {
                if (Network.connectionLost(iOException)) {
                    object = new ConnectionLostException();
                    ((LocalException)object).initCause(iOException);
                    throw object;
                }
                object = new SocketException();
                ((LocalException)object).initCause(iOException);
                throw object;
            }
        }
        if (this._shutdown) {
            throw new ConnectionLostException();
        }
    }

    public String type() {
        return "tcp";
    }

    public String toString() {
        return this._desc;
    }

    Transceiver(Instance instance, Connection connection) {
        this._connection = (SocketConnection)connection;
        this._traceLevels = instance.traceLevels();
        this._logger = instance.logger();
        this._desc = Network.toString(this._connection);
        try {
            this._in = this._connection.openInputStream();
            this._out = this._connection.openOutputStream();
        }
        catch (IOException iOException) {
            try {
                this._connection.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            this._connection = null;
            SocketException socketException = new SocketException();
            socketException.initCause(iOException);
            throw socketException;
        }
        this._shutdown = false;
    }

    private class WriteThread
    extends Thread {
        int _timeout;
        BasicStream _stream;
        RuntimeException _ex = null;
        boolean _done = false;

        WriteThread(BasicStream basicStream, int n) {
            this._stream = basicStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Transceiver.this.writeImpl(this._stream);
            }
            catch (RuntimeException runtimeException) {
                this._ex = runtimeException;
            }
            WriteThread writeThread = this;
            synchronized (writeThread) {
                this._done = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write() {
            long l = System.currentTimeMillis() + (long)this._timeout;
            long l2 = this._timeout;
            WriteThread writeThread = this;
            synchronized (writeThread) {
                while (this._ex == null && !this._done) {
                    try {
                        this.wait(l2);
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                        l2 = l - System.currentTimeMillis();
                        if (l2 > 0L) continue;
                        throw new TimeoutException();
                    }
                }
                if (this._ex != null) {
                    throw this._ex;
                }
            }
        }
    }

    private class ReadThread
    extends Thread {
        int _timeout;
        BasicStream _stream;
        RuntimeException _ex = null;
        boolean _done = false;

        ReadThread(BasicStream basicStream, int n) {
            this._stream = basicStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Transceiver.this.readImpl(this._stream);
            }
            catch (RuntimeException runtimeException) {
                this._ex = runtimeException;
            }
            ReadThread readThread = this;
            synchronized (readThread) {
                this._done = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void read() {
            long l = System.currentTimeMillis() + (long)this._timeout;
            long l2 = this._timeout;
            ReadThread readThread = this;
            synchronized (readThread) {
                while (this._ex == null && !this._done) {
                    try {
                        this.wait(l2);
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                        l2 = l - System.currentTimeMillis();
                        if (l2 > 0L) continue;
                        throw new TimeoutException();
                    }
                }
                if (this._ex != null) {
                    throw this._ex;
                }
            }
        }
    }
}

