/*
    Copyright (c) 2007-2010 iMatix Corporation

    This file is part of 0MQ.

    0MQ is free software; you can redistribute it and/or modify it under
    the terms of the Lesser GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    0MQ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    Lesser GNU General Public License for more details.

    You should have received a copy of the Lesser GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __ZMQ_I_ENGINE_HPP_INCLUDED__
#define __ZMQ_I_ENGINE_HPP_INCLUDED__

#include <stddef.h>

#include "blob.hpp"

namespace zmq
{

    struct i_engine
    {
        virtual ~i_engine () {}

        //  Plug the engine to the session.
        virtual void plug (struct i_inout *inout_) = 0;

        //  Unplug the engine from the session.
        virtual void unplug () = 0;

        //  This method is called by the session to signalise that there
        //  are messages to send available.
        virtual void revive () = 0;

        virtual void resume_input () = 0;

        //  Engine should add the prefix supplied to all inbound messages.
        virtual void add_prefix (const blob_t &identity_) = 0;

        //  Engine should trim prefix from all the outbound messages.
        virtual void trim_prefix () = 0;
    };

}

#endif
