use Test::More tests => 16;
use File::Spec;
use Zim::File;

my $f = File::Spec->rel2abs(
	File::Spec->catfile('t', 'test_file.txt~') );
unlink $f;

my $file = Zim::File->new('t', 'test_file.txt~');

ok(! $file->exists, 'clean start'); #1
ok($file->path eq $f, 'path'); # 2
ok("$file" eq $f, 'overload'); # 3
ok(-d $file->dir, 'dir'); #4
ok($file->file eq 'test_file.txt~', 'file'); #5

$file->write("test 123\ntest 456\n");
ok( cat($f) eq "test 123\ntest 456\n", 'write'); #6
$file->append("test 789\n");
ok( cat($f) eq "test 123\ntest 456\ntest 789\n", 'append'); #7

ok($file->read eq "test 123\ntest 456\ntest 789\n", 'read scalar'); #8
is_deeply(
	[$file->read],
	["test 123\n","test 456\n","test 789\n"],
	'read list' ); #9

ok($file->exists, 'exists'); #10
$file->remove();
ok(! -e $f && ! $file->exists, 'remove'); #11

$file->write_config({a => 1, b => 3, c => 2}, [qw/a c b/]);
ok(cat($f) eq "a=1\nc=2\nb=3\n", 'write_config'); #12
is_deeply(
	[$file->read_config()],
	[{a => 1, b => 3, c => 2}, [qw/a c b/]],
	'read_config' ); #13

my $io = $file->open;
ok(ref($io) eq 'IO::File', 'open'); #14
close $io;

$file->remove;

my $dir = File::Spec->catdir(qw/t test_file foo bar baz/);
my $parent = File::Spec->catdir(qw/t test_file/);
Zim::File->remove_dir($dir) if -d $dir;
Zim::File->make_dir($dir);
ok(-d $dir, 'make_dir'); #15
Zim::File->remove_dir($dir);
ok(! -e $dir && ! -e $parent, 'remove_dir'); #16

sub cat {
	my $file = shift;
	open FILE, $file or die $!;
	my $content = join '', <FILE>;
	close FILE;
	return $content;
}

