use Test::Simple tests => 1;

use File::Spec;
use IO::File;
use Zim::Formats::Wiki;
my $class = 'Zim::Formats::Wiki';

my $file = File::Spec->catfile(qw/t repository Test_files wiki.txt/);
my $test = File::Spec->catfile(qw/t repository Test_files wiki.txt~/);
unlink $test or die "Could not unlink $test\n" if -e $test;

my $io = IO::File->new($file, 'r');
my $tree = $class->load_tree($io);
$io->close;

#use Data::Dumper; print STDERR Dumper $tree;

$io = IO::File->new($test, 'w');
$class->save_tree($io, $tree);
$io->close;

ok(cat($file) eq cat($test), 'formatter round trip');

sub cat {
	my $file = shift;
	open FILE, $file or die "Could not open $file\n";
	my $txt = join '', <FILE>;
	close FILE;
	return $txt;
}
