%define static_binary 0

Summary: A compression http proxy
Name: ziproxy
Version: 2.7.2
Release: 1
URL: http://ziproxy.sourceforge.net/
Source: http://downloads.sourceforge.net/ziproxy/%{name}-%{version}.tar.bz2
Packager: Daniel Mealha Cabrita <dancab@gmx.net>
License: GPL
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Group: Web
%if ! %{static_binary}
Requires: libungif4, libjpeg62, libpng3, libz1, libjasper1
%endif
PreReq: chkconfig, sed

%prep 

%setup

%build

# Ziproxy's make install is broken (cannot chroot)
./configure --prefix=%{_prefix} --bindir=%{_bindir} --sysconfdir=%{_sysconfdir} --localstatedir=%{_localstatedir} --with-jasper

%if %{static_binary}
cat Makefile | sed 's/^LIBS\ =\ .*$/LIBS\ =\ -lpthread\ -Wl,-dn,-lpng,-dy\ -Wl,-dn,-ljpeg,-dy\ -Wl,-dn,-lgif,-dy\ -Wl,-dn,-lm,-dy\ -Wl,-dn,-lz,-dy\ -Wl,-dn,-ljasper,-dy\ -Wl,-dn,-dy/g' >Makefile.tmp
cat src/Makefile | sed 's/^LIBS\ =\ .*$/LIBS\ =\ -lpthread\ -Wl,-dn,-lpng,-dy\ -Wl,-dn,-ljpeg,-dy\ -Wl,-dn,-lgif,-dy\ -Wl,-dn,-lm,-dy\ -Wl,-dn,-lz,-dy\ -Wl,-dn,-ljasper,-dy\ -Wl,-dn,-dy/g' >src/Makefile.tmp
mv -f Makefile.tmp Makefile
mv -f src/Makefile.tmp src/Makefile
%endif

make

%install
mkdir -p %{buildroot}%{_bindir}
mkdir -p %{buildroot}%{_mandir}/man1
mkdir -p %{buildroot}%{_sysconfdir}/init.d
mkdir -p %{buildroot}%{_sysconfdir}/xinetd.d
mkdir -p %{buildroot}%{_sysconfdir}/%{name}
mkdir -p %{buildroot}%{_localstatedir}/%{name}/error
mkdir -p %{buildroot}%{_localstatedir}/%{name}/scripts
mkdir -p %{buildroot}%{_localstatedir}/log/%{name}
install -m 755 src/%{name} %{buildroot}%{_bindir}
install -m 755 src/tools/ziproxylogtool %{buildroot}%{_bindir}
install -m 755 man/* %{buildroot}%{_mandir}/man1/
install -m 755 etc/init.d/%{name} %{buildroot}%{_sysconfdir}/init.d
install -m 644 etc/%{name}/%{name}.conf %{buildroot}%{_sysconfdir}/%{name}
install -m 644 etc/%{name}/replace.list %{buildroot}%{_sysconfdir}/%{name}
install -m 644 etc/%{name}/bo_exception.list %{buildroot}%{_sysconfdir}/%{name}
install -m 644 etc/%{name}/noprocess.list %{buildroot}%{_sysconfdir}/%{name}
install -m 644 etc/%{name}/http.passwd %{buildroot}%{_sysconfdir}/%{name}
install -m 644 etc/xinetd.d/%{name} %{buildroot}%{_sysconfdir}/xinetd.d
install -m 644 src/tools/ziproxy_genhtml_stats.sh %{buildroot}%{_localstatedir}/%{name}/scripts
install -m 644 var/%{name}/error/*.html %{buildroot}%{_localstatedir}/%{name}/error
chmod 700 %{buildroot}%{_localstatedir}/log/%{name}

%post
if [ "$1" = "1" ]; then
	/sbin/chkconfig --add %{name}
	/sbin/chkconfig %{name} off
fi

%clean
rm -rf %{buildroot}

%preun
if [ "$1" = "0" ]; then
        /sbin/service %{name} stop > /dev/null 2>&1 || :
        /sbin/chkconfig --del %{name} > /dev/null 2>&1 || :
fi

%files
%doc COPYING
%doc README
%doc README.ru
%doc README.tools
%doc README.tools.ru
%doc CREDITS
%doc ChangeLog
%doc JPEG2000.txt
%doc JPEG2000.ru.txt
%{_bindir}/%{name}
%{_bindir}/ziproxylogtool
%{_mandir}/man1/*
%{_sysconfdir}/init.d/%{name}
%config(noreplace) %{_sysconfdir}/%{name}/%{name}.conf
%config(noreplace) %{_sysconfdir}/%{name}/replace.list
%config(noreplace) %{_sysconfdir}/%{name}/replace_ct.list
%config(noreplace) %{_sysconfdir}/%{name}/bo_exception.list
%config(noreplace) %{_sysconfdir}/%{name}/noprocess.list
%config(noreplace) %{_sysconfdir}/%{name}/http.passwd
%config(noreplace) %{_sysconfdir}/%{name}/deny.list
%config(noreplace) %{_sysconfdir}/xinetd.d/%{name}
%{_localstatedir}/%{name}/scripts/*
%{_localstatedir}/%{name}/error/*
%dir %{_sysconfdir}/%{name}
%dir %{_localstatedir}/%{name}/scripts
%dir %{_localstatedir}/%{name}/error
%dir %{_localstatedir}/%{name}
%dir %{_localstatedir}/log/%{name}

%description
A http compression and optimizer, non-caching, fully configurable proxy.
Ziproxy features JPEG, GIF, PNG, JPEG2k and GZIP recompression for
lower HTTP traffic through low speed links, among other features.


