
package ONVIF::PTZ::Elements::ModifyPresetTour;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'http://www.onvif.org/ver20/ptz/wsdl' }

__PACKAGE__->__set_name('ModifyPresetTour');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    SOAP::WSDL::XSD::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %ProfileToken_of :ATTR(:get<ProfileToken>);
my %PresetTour_of :ATTR(:get<PresetTour>);

__PACKAGE__->_factory(
    [ qw(        ProfileToken
        PresetTour

    ) ],
    {
        'ProfileToken' => \%ProfileToken_of,
        'PresetTour' => \%PresetTour_of,
    },
    {
        'ProfileToken' => 'ONVIF::PTZ::Types::ReferenceToken',
        'PresetTour' => 'ONVIF::PTZ::Types::PresetTour',
    },
    {

        'ProfileToken' => 'ProfileToken',
        'PresetTour' => 'PresetTour',
    }
);

} # end BLOCK







} # end of BLOCK



1;


=pod

=head1 NAME

ONVIF::PTZ::Elements::ModifyPresetTour

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
ModifyPresetTour from the namespace http://www.onvif.org/ver20/ptz/wsdl.







=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * ProfileToken

 $element->set_ProfileToken($data);
 $element->get_ProfileToken();




=item * PresetTour

 $element->set_PresetTour($data);
 $element->get_PresetTour();





=back


=head1 METHODS

=head2 new

 my $element = ONVIF::PTZ::Elements::ModifyPresetTour->new($data);

Constructor. The following data structure may be passed to new():

 {
   ProfileToken => $some_value, # ReferenceToken
   PresetTour =>  { # ONVIF::PTZ::Types::PresetTour
     Name => $some_value, # Name
     Status =>  { # ONVIF::PTZ::Types::PTZPresetTourStatus
       State => $some_value, # PTZPresetTourState
       CurrentTourSpot =>  { # ONVIF::PTZ::Types::PTZPresetTourSpot
         PresetDetail =>          { # ONVIF::PTZ::Types::PTZPresetTourPresetDetail
           # One of the following elements.
           # No occurance checks yet, so be sure to pass just one...
           PresetToken => $some_value, # ReferenceToken
           Home =>  $some_value, # boolean
           PTZPosition =>  { # ONVIF::PTZ::Types::PTZVector
             PanTilt => ,
             Zoom => ,
           },
           TypeExtension =>  { # ONVIF::PTZ::Types::PTZPresetTourTypeExtension
           },
         },
         Speed =>  { # ONVIF::PTZ::Types::PTZSpeed
           PanTilt => ,
           Zoom => ,
         },
         StayTime =>  $some_value, # duration
         Extension =>  { # ONVIF::PTZ::Types::PTZPresetTourSpotExtension
         },
       },
       Extension =>  { # ONVIF::PTZ::Types::PTZPresetTourStatusExtension
       },
     },
     AutoStart =>  $some_value, # boolean
     StartingCondition =>  { # ONVIF::PTZ::Types::PTZPresetTourStartingCondition
       RecurringTime =>  $some_value, # int
       RecurringDuration =>  $some_value, # duration
       Direction => $some_value, # PTZPresetTourDirection
       Extension =>  { # ONVIF::PTZ::Types::PTZPresetTourStartingConditionExtension
       },
     },
     TourSpot =>  { # ONVIF::PTZ::Types::PTZPresetTourSpot
       PresetDetail =>        { # ONVIF::PTZ::Types::PTZPresetTourPresetDetail
         # One of the following elements.
         # No occurance checks yet, so be sure to pass just one...
         PresetToken => $some_value, # ReferenceToken
         Home =>  $some_value, # boolean
         PTZPosition =>  { # ONVIF::PTZ::Types::PTZVector
           PanTilt => ,
           Zoom => ,
         },
         TypeExtension =>  { # ONVIF::PTZ::Types::PTZPresetTourTypeExtension
         },
       },
       Speed =>  { # ONVIF::PTZ::Types::PTZSpeed
         PanTilt => ,
         Zoom => ,
       },
       StayTime =>  $some_value, # duration
       Extension =>  { # ONVIF::PTZ::Types::PTZPresetTourSpotExtension
       },
     },
     Extension =>  { # ONVIF::PTZ::Types::PTZPresetTourExtension
     },
   },
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

