""" monkey patch routines for reportlab 2.x dependencies """
import md5

class md5module:
   def new(self, arg=None):
      return md5instance(arg)

   def md5(self, arg=None):
      return md5instance(arg)

class md5instance:
   def __init__(self, arg=None):
      if arg is None:
         self.m = md5.new()
      else:
         self.m = md5.new(arg)
         
   def update(self, arg):
      return self.m.update(arg)

   def digest(self):
      return self.m.digest()
      
   def hexdigest(self):
      import base64
      return base64.encodestring(self.digest())

   def copy(self):
      return self.m.copy()


# this used to be a capabilities test, but i changed it into a version test
# because testing the capability was not reliable (and i dont want to spend
# more time on it).  This is for reportlab/Python 1.5 incompatibilities
# specifically having to do with the md5 module not having a hexdigest
# function in 1.5.2.
import sys
python_version = sys.version.split()[0]
if python_version < '2.1':
   import reportlab.pdfgen.canvas
   reportlab.pdfgen.canvas.md5 = md5module()
