# (C) Copyright 2005 Nuxeo SARL <http://nuxeo.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.
#
# $Id: getBlogAggregatorPortletLayout.py 469 2005-03-24 13:22:23Z rspivak $

blogaggregator_portlet_layout = {
    'widgets': {
        'portlet': {
            'type': 'Generic Portlet Widget',
            'data': {
                'title': '',
                'fields': ('portlet',),
                'is_required': False,
                'label': '',
                'label_edit': '',
                'description': '',
                'help': '',
                'is_i18n': False,
                'readonly_layout_modes': (),
                'hidden_layout_modes': ('edit',),
                'hidden_readonly_layout_modes': (),
                'hidden_empty': False,
                'hidden_if_expr': '',
                'css_class': '',
                'widget_mode_expr': '',
                'render_method': 'widget_portlet_blogaggregator',
                'field_types': ('CPS String Field',),
                },
            },
        'query_title': {
            'type': 'String Widget',
            'data': {'title': '',
                     'fields': ('query_title',),
                     'is_required': False,
                     'label': '',
                     'label_edit': 'label_search_title',
                     'description': '',
                     'help': '',
                     'is_i18n': True,
                     'readonly_layout_modes': (),
                     'hidden_layout_modes': ('view',),
                     'hidden_readonly_layout_modes': (),
                     'hidden_empty': False,
                     'hidden_if_expr': '',
                     'css_class': '',
                     'widget_mode_expr': '',
                     'vocabulary': '',
                     'translated': True,
                },
            },
        'query_description': {
            'type': 'String Widget',
            'data': {'title': '',
                     'fields': ('query_description',),
                     'is_required': False,
                     'label': '',
                     'label_edit': 'label_search_description',
                     'description': '',
                     'help': '',
                     'is_i18n': True,
                     'readonly_layout_modes': (),
                     'hidden_layout_modes': ('view',),
                     'hidden_readonly_layout_modes': (),
                     'hidden_empty': False,
                     'hidden_if_expr': '',
                     'css_class': '',
                     'widget_mode_expr': '',
                     'vocabulary': '',
                     'translated': True,
                },
            },
        'query_fulltext': {
            'type': 'String Widget',
            'data': {'title': '',
                     'fields': ('query_fulltext',),
                     'is_required': False,
                     'label': '',
                     'label_edit': 'label_search_full_text',
                     'description': '',
                     'help': '',
                     'is_i18n': True,
                     'readonly_layout_modes': (),
                     'hidden_layout_modes': ('view',),
                     'hidden_readonly_layout_modes': (),
                     'hidden_empty': False,
                     'hidden_if_expr': '',
                     'css_class': '',
                     'widget_mode_expr': '',
                     'vocabulary': '',
                     'translated': True,
                },
            },
        'query_categories': {
            'type': 'MultiSelect Widget',
            'data': {'title': '',
                     'fields': ('query_categories',),
                     'is_required': False,
                     'label': '',
                     'label_edit': 'blog_entry_categories_label_edit',
                     'description': '',
                     'help': '',
                     'is_i18n': True,
                     'readonly_layout_modes': (),
                     'hidden_layout_modes': ('view',),
                     'hidden_readonly_layout_modes': (),
                     'hidden_empty': False,
                     'hidden_if_expr': '',
                     'css_class': '',
                     'widget_mode_expr': '',
                     'vocabulary': 'blogaggregator_categories',
                     'translated': False,
                },
            },
        'query_modified': {
            'type': 'Select Widget',
            'data': {'title': '',
                     'fields': ('query_modified',),
                     'is_required': False,
                     'label': '',
                     'label_edit': 'label_search_modified_since',
                     'description': '',
                     'help': '',
                     'is_i18n': True,
                     'readonly_layout_modes': (),
                     'hidden_layout_modes': ('view',),
                     'hidden_readonly_layout_modes': (),
                     'hidden_empty': False,
                     'hidden_if_expr': '',
                     'css_class': '',
                     'widget_mode_expr': '',
                     'vocabulary': 'blogaggregator_modified',
                     'translated': True,
                },
            },
        'query_status': {
            'type': 'Select Widget',
            'data': {'title': '',
                     'fields': ('query_status',),
                     'is_required': False,
                     'label': '',
                     'label_edit': 'label_search_status',
                     'description': '',
                     'help': '',
                     'is_i18n': True,
                     'readonly_layout_modes': (),
                     'hidden_layout_modes': ('view',),
                     'hidden_readonly_layout_modes': (),
                     'hidden_empty': False,
                     'hidden_if_expr': '',
                     'css_class': '',
                     'widget_mode_expr': '',
                     'vocabulary': 'blogaggregator_status',
                     'translated': True,
                },
            },
        'view_mode': {
            'type': 'Select Widget',
            'data': {'title': '',
                     'fields': ('view_mode',),
                     'is_required': False,
                     'label': '',
                     'label_edit': 'blog_view_mode_label_edit',
                     'description': '',
                     'help': '',
                     'is_i18n': True,
                     'readonly_layout_modes': (),
                     'hidden_layout_modes': ('view',),
                     'hidden_readonly_layout_modes': (),
                     'hidden_empty': False,
                     'hidden_if_expr': '',
                     'css_class': '',
                     'widget_mode_expr': '',
                     'vocabulary': 'blog_view_mode',
                     'translated': True,
                },
            },
        'entries_per_page': {
            'type': 'Int Widget',
            'data': {'title': '',
                     'fields': ('entries_per_page',),
                     'is_required': False,
                     'label': '',
                     'label_edit': 'blog_entries_per_page_label_edit',
                     'description': '',
                     'help': '',
                     'is_i18n': True,
                     'readonly_layout_modes': (),
                     'hidden_layout_modes': ('view',),
                     'hidden_readonly_layout_modes': (),
                     'hidden_empty': False,
                     'hidden_if_expr': '',
                     'css_class': '',
                     'width': 3,
                     'widget_mode_expr': '',
                     'translated': True,
                },
            },
        'sort_by': {
            'type': 'Select Widget',
            'data': {'title': '',
                     'fields': ('sort_by',),
                     'is_required': False,
                     'label': '',
                     'label_edit': 'label_sort_by',
                     'description': '',
                     'help': '',
                     'is_i18n': True,
                     'readonly_layout_modes': (),
                     'hidden_layout_modes': ('view',),
                     'hidden_readonly_layout_modes': (),
                     'hidden_empty': False,
                     'hidden_if_expr': '',
                     'css_class': '',
                     'widget_mode_expr': '',
                     'vocabulary': 'blogaggregator_sort_by',
                     'translated': True,
                },
            },
        'search_limit': {
            'type': 'Int Widget',
            'data': {'title': '',
                     'fields': ('search_limit',),
                     'is_required': False,
                     'label': '',
                     'label_edit': 'blog_entries_search_limit_label_edit',
                     'description': '',
                     'help': '',
                     'is_i18n': True,
                     'readonly_layout_modes': (),
                     'hidden_layout_modes': ('view',),
                     'hidden_readonly_layout_modes': (),
                     'hidden_empty': False,
                     'hidden_if_expr': '',
                     'css_class': '',
                     'width': 3,
                     'widget_mode_expr': '',
                     'translated': True,
                },
            },

    },
    'layout': {
        'style_prefix': 'layout_portlet_',
        'flexible_widgets': (),
        'ncols': 1,
        'rows': [
            [{'widget_id': 'portlet', 'ncols': 1},],
            [{'widget_id': 'query_title'}],
            [{'widget_id': 'query_description'}],
            [{'widget_id': 'query_fulltext'}],
            [{'widget_id': 'query_categories'}],
            [{'widget_id': 'query_modified'}],
            [{'widget_id': 'query_status'}],
            [{'widget_id': 'view_mode'}],
            [{'widget_id': 'entries_per_page'}],
            [{'widget_id': 'search_limit'}],
            [{'widget_id': 'sort_by'}],
        ],
    },
}

layouts = {'blogaggregator_portlet': blogaggregator_portlet_layout}
return layouts
