## Script (Python) "connectorPlone.py"
##bind container=container
##bind context=context
##bind namespace=
##bind script=script
##bind subpath=traverse_subpath
##parameters= Type='',CurrentPath=''


from Products.PythonScripts.standard import html_quote
from Products.CMFCore.utils import getToolByName
from Products.FCKeditor.utils import fckCreateValidZopeId



# Author : jean-mat Grimaldi - jean-mat@macadames.com
# This upload function is plone specific
# Some functions need to be adapted for other Zope CMS compatibility

# 1. Config

# Path to user files relative to the document root.
ConfigUserFilesPath=""
# SECURITY TIP: Uncomment the following line to set a fixed path
# ConfigUserFilesPath = "/UserFiles/"
# SECURITY TIP: Uncomment the 3 following code lines to force the Plone Member Home Folder as fixed path
# You can do it as well with wysiwyg_support templates customization
# it's just more secure  
# portal=context.portal_url.getPortalObject()
# portal_url=portal.absolute_url()
# ConfigUserFilesPath = portal.portal_membership.getHomeUrl().replace(portal_url, '') + '/'

# dico fck parameters
fckParams=context.getFck_params()


# Allowed and denied extensions dictionaries

ConfigAllowedExtensions = {"File":None,"Image":("jpg","gif","jpeg","png"),"Flash":("swf","fla"),"Media":("swf","fla","jpg","gif","jpeg","png","avi","mpg","mpeg","mp1","mp2","mp3","mp4","wma","wmv","wav","mid","midi","rmi","rm","ram","rmvb","mov","qt")}
ConfigDeniedExtensions =  {"File":("py","pt","cpt","dtml","php","asp","aspx","ascx","jsp","cfm","cfc","pl","bat","exe","com","dll","vbs","js","reg"),"Image":None,"Flash":None,"Media":None}

# set link by UID for AT content Types 
linkbyuid=test(fckParams['allow_link_byuid'],1,0)

# check if upload allowed for Links Image and internal links

allow_file_upload=test(fckParams['allow_server_browsing'],test(fckParams['allow_file_upload'],1,0),0)
allow_image_upload=test(fckParams['allow_server_browsing'],test(fckParams['allow_image_upload'],1,0),0)
allow_flash_upload=test(fckParams['allow_server_browsing'],test(fckParams['allow_flash_upload'],1,0),0)

# check for portal_types when uploading internal links, images and files

file_portal_type = test(fckParams['file_portal_type'],fckParams['file_portal_type'],'File')
image_portal_type = test(fckParams['image_portal_type'],fckParams['image_portal_type'],'Image')
flash_portal_type = test(fckParams['flash_portal_type'],fckParams['flash_portal_type'],'File')


# PloneArticle based meta_types
pa_meta_types = fckParams['pa_meta_types']

# find Plone Site charset if possible
try:
  prop   = getToolByName(context, "portal_properties")
  charsetSite = prop.site_properties.getProperty("default_charset", "utf-8")
except:
  charsetSite ="utf-8"

# 2. utils

def RemoveFromStart(sourceString,charToRemove ):
  return sourceString.lstrip(charToRemove)

def utf8Decode(chaine) :
    # because fck rapid upload form are in utf-8 we need it
    errors="strict"
    if charsetSite.lower() in ("utf-8", "utf8"):
        return chaine
    else:
        try:
            chaine = unicode(chaine, "utf-8", "strict").encode(charsetSite, "strict")
        except:
            chaine = chaine.encode(charsetSite, "strict")
        return chaine


def utf8Encode(chaine) :

    errors="strict"
    if charsetSite.lower() in ("utf-8", "utf8"):
      return chaine
    else:
      return unicode(chaine, charsetSite, errors).encode("utf-8", errors)



# 3. io



def GetUrlFromPath( folderPath ) :

    return '%s%s' %(portal_path,folderPath.rstrip("/"))


def RemoveExtension( fileName ):

   sprout=fileName.split(".")
   return '.'.join(sprout[:len(sprout)-1])

def  IsAllowedExt( extension, resourceType ) :
  
   sAllowed = ConfigAllowedExtensions[resourceType]
   sDenied = ConfigDeniedExtensions[resourceType]

   if (sAllowed is None or extension in sAllowed) and (sDenied is None or extension not in sDenied) :
     return 1
   else :
     return 0

def FindExtension (fileName):

   sprout=fileName.split(RemoveExtension(fileName))
   return ''.join(sprout).lstrip('.')

  





       



# 6. upload

def UploadFile(resourceType, currentFolder, data, title, description) :

        user=context.REQUEST['AUTHENTICATED_USER']
        if currentFolder != "/" :
            obj = context.restrictedTraverse(currentFolder.lstrip('/'))
        else :
            obj = context.portal_url.getPortalObject()
        error=""
        fileUrl=""
        customMsg=""
        idObj=""
        folderUrl=GetUrlFromPath(currentFolder)+ "/"
        

        if obj.meta_type not in pa_meta_types:
            # define Portal Type to add

            if resourceType == 'File':
                typeToAdd = file_portal_type
            elif resourceType == 'Flash':
                typeToAdd = flash_portal_type
            elif resourceType == 'Image' :
                if obj.meta_type=="CMF ZPhotoSlides":
                    typeToAdd = 'ZPhoto'
                elif obj.meta_type=="Photo Album":
                    typeToAdd = 'Photo'
                elif obj.meta_type=="ATPhotoAlbum":
                    typeToAdd = 'ATPhoto'
                else:
                    typeToAdd = image_portal_type
        

            if not user.has_permission('Add portal content', obj) and not user.has_permission('Modify portal content', obj):
               error = "1"
               customMsg="upload denied - insufficient privileges"

            if resourceType == 'Image' and not allow_image_upload:
               error = "1"
               customMsg="image upload denied - contact your site admin"

            if resourceType == 'Flash' and not allow_flash_upload:
               error = "1"
               customMsg="flash upload denied - contact your site admin"

            if resourceType not in ('Flash','Image') and not allow_file_upload:
               error = "1"
               customMsg="file upload denied - contact your site admin"

            if not data:
              #pas de fichier 
              error= "1"        
              customMsg="no file uploaded"


            titre_data=''
            filename=utf8Decode(getattr(data,'filename', ''))
            titre_data=filename[max(string.rfind(filename, '/'),
                            string.rfind(filename, '\\'),
                            string.rfind(filename, ':'),
                            )+1:]                  

            idObj=fckCreateValidZopeId(utf8Encode(titre_data))

            if title :
               titre_data=title

            if not IsAllowedExt( FindExtension(idObj), resourceType ):
                  error= "202"        
                  customMsg="Invalid file type"

            if not error :              
                error="0"
                indice=0
                exemple_titre=idObj
                while exemple_titre in obj.objectIds():
                  indice=indice+1
                  exemple_titre=str(indice) + idObj
                if indice!=0:
                    error= "201"
                    idObj = exemple_titre                        
                    customMsg="an object already exists with the same name, the file has been renamed " + idObj 

                try:
                    obj.invokeFactory(id=idObj, type_name=typeToAdd, title=titre_data )
                    newFile = getattr(obj, idObj)
                    newFile.edit(file=data)
                    newFile.setDescription(description)
                    obj.reindexObject()
                    if linkbyuid and hasattr(newFile.aq_explicit, 'UID'):
                        uid = newFile.UID()
                        fileUrl = "./resolveUid/" + uid
                    else :
                        fileUrl = folderUrl + idObj

                except:
                    error = "1"
                    customMsg = "Server error"

        #Plone Article Specifique
        else :
            # find Plone Article version and brains
            try :
                image_brains = obj.getImageBrains()
                attachment_brains = obj.getAttachmentBrains()
                versionPA=3
            except:
                versionPA=2

            if not data:
                #pas de fichier 
                error= "1"        
                customMsg="no file uploaded"
            else :
                filename=utf8Decode(getattr(data,'filename', ''))
                titre_data=filename[max(string.rfind(filename, '/'),
                                string.rfind(filename, '\\'),
                                string.rfind(filename, ':'),
                                )+1:]                  

                # idObj can't be cleaned with PloneArticle attachements
                # it's a problem but we do the job
                idObj=fckCreateValidZopeId(utf8Encode(titre_data))
                if title :
                    titre_data=title
                
                if resourceType == 'Image' :

                    # Upload file
                    if not user.has_permission('Modify portal content', obj):
                        error = "103"
                    elif not allow_image_upload:
                        error = "103"
                    elif not IsAllowedExt( FindExtension(idObj), resourceType ):
                        error= "202"        
                        customMsg="Invalid file type"
                    elif obj.portal_article.checkImageSize(data):
                        if versionPA==2 :
                            try:
                                index = len(obj.listImages())
                                obj.appendImage(titre_data, data, )
                                error="0"
                                parent = obj.aq_parent
                                parent.reindexObject()
                                fileUrl= folderUrl + obj.getImageId(index)
                            except:
                                error="1"
                                customMsg="Server error"
                        else :
                            try:
                                index = len(image_brains)
                                obj.addImage(title=titre_data, description=description, image=data)
                                error="0"
                                obj.reindexObject()
                                # it's necessary to reload brains i don't know if a more rapid method exists
                                newFile= obj.getImageBrains()[index].getObject()
                                if linkbyuid and hasattr(newFile.aq_explicit, 'UID'):
                                    uid = newFile.UID()
                                    fileUrl = "./resolveUid/" + uid
                                else :
                                    image_id = newFile.getId()
                                    fileUrl= folderUrl + image_id
                            except:
                                error="1"
                                customMsg="Server error"
                            
                    else:
                        error="1"
                        customMsg="File exceeds allowed maximum size"
                else:

                    # uploadfile
                    if not user.has_permission('Modify portal content', obj):
                        error = "103"
                    elif not allow_file_upload:
                        error = "103"
                    elif not IsAllowedExt( FindExtension(idObj), resourceType ):
                        error= "202"        
                        customMsg="Invalid file type"
                    elif obj.portal_article.checkAttachmentSize(data):
                        if versionPA==2 :
                            try:
                                index = len(obj.listAttachments())
                                obj.appendAttachment(titre_data, data, )
                                error="0"
                                parent = obj.aq_parent
                                parent.reindexObject()
                                fileUrl= folderUrl + obj.getAttachmentId(index) + "/" + filename
                            except:
                                error="1"
                                customMsg="Server error"
                        else :
                            try:
                                index = len(attachment_brains)
                                obj.addAttachment(title=titre_data, description=description, file=data)
                                error="0"
                                obj.reindexObject()
                                # it's necessary to reload brains i don't know if a more rapid method exists
                                newFile= obj.getAttachmentBrains()[index].getObject()
                                if linkbyuid and hasattr(newFile.aq_explicit, 'UID'):
                                    uid = newFile.UID()
                                    fileUrl = "./resolveUid/" + uid
                                else :
                                    image_id = newFile.getId()
                                    fileUrl= folderUrl + image_id
                            except:
                                error="1"
                                customMsg="Server error"
                    else:
                        error="1"
                        customMsg="File exceeds allowed maximum size"
                        


        d= '''
        <script type="text/javascript">
        window.parent.OnUploadCompleted(%s,"%s","%s","%s") ;
        </script>
        '''% (error,fileUrl,idObj,customMsg)
        return d


#7. principial 


request = context.REQUEST
RESPONSE =  request.RESPONSE
dicoRequest = request.form
message_error=""
sCurrentFolder =""
portal_url=context.portal_url.getPortalObject().absolute_url()
server_url = request.SERVER_URL
portal_path = portal_url.replace(server_url,'')


if ConfigUserFilesPath != "" :
   sUserFilesPath = ConfigUserFilesPath
elif dicoRequest.has_key('ServerPath'):
   sUserFilesPath = dicoRequest ['ServerPath']
else :
   sUserFilesPath = "/"



if dicoRequest.has_key('CurrentPath'):
   sCurrentFolder = dicoRequest ['CurrentPath']
elif request.QUERY_STRING :
   sCurrentFolder= request.QUERY_STRING.replace('CurrentPath=','')
else :
   message_error="No CurrentFolder in request"


if sUserFilesPath!='/' and sUserFilesPath.rstrip('/') not in sCurrentFolder:
   sCurrentFolder = sUserFilesPath


if dicoRequest.has_key('Type'):
    sResourceType = dicoRequest ['Type']
else :
    sResourceType = 'File'

if dicoRequest.has_key('Description'):
    sDescription = utf8Decode(dicoRequest ['Description'])
    
else :
    sDescription = ''



# interception File Upload
if dicoRequest.has_key('NewFile'):
    sData = dicoRequest ['NewFile']
    sTitle = utf8Decode(dicoRequest ['Title'])

    chaineHtmlUpload = UploadFile(sResourceType, sCurrentFolder, sData, sTitle, sDescription)
    RESPONSE.setHeader('Content-type', 'text/html;charset=%s' % charsetSite)
    return chaineHtmlUpload

else :
    #pas de fichier 
    error= "1"        
    customMsg="no file uploaded"
    fileUrl=""
    fileName=""
    d= '''
    <script type="text/javascript">
    window.parent.OnUploadCompleted(%s,"%s","%s","%s") ;
    </script>
    '''% (error,fileUrl,fileName,customMsg)
    RESPONSE.setHeader('Content-type', 'text/html')
    return d
