__doc__='''Shopper's Basket implementation'''

__version__='$Revision: 1.7 $'[11:-2]

BasketError = "Basket Error."

from Globals import HTMLFile, MessageDialog, Persistent
import OFS.SimpleItem, Acquisition
import traceback

from Products import ZPatterns
    
import string
import time

class BasketItemManager( ZPatterns.Specialists.Specialist):

    def newBasketItem(self, basketId, marketItemId, quantity):
        """ create a new basket item... """
        newBasketItem = self.newItem( self.getBasketItemId(basketId, marketItemId ))
        newBasketItem.marketItemId = marketItemId
        newBasketItem.quantity = quantity

        return newBasketItem

    def getBasketItem(self, basketId, marketItemId):
        """ get a particular basket item... """
        return self.getItem( self.getBasketItemId( basketId, marketItemId))
                                     
    def getBasketItemId(self, basketId, marketItemId):
        """ return a basket item Id """
        return basketId + '_' + marketItemId

    def optionDict2Mapping(self):
        """ convert self.optionDict to a mapping object for display..."""
        first = string.find(self.optionDict,'(')
        last = string.rfind(self.optionDict,')')
        innerString = self.optionDict[first+1:last]  # should be '(a,b),(c,d),....'
        pairs = string.split(innerString,',')
        newMapping = {}
        for item in range(len(pairs)/2):
            [key,val] = pairs[2*item:2*item+2]
            key = string.strip(key)
            val = string.strip(val)
            if key[0] == '(':
                key = key[1:]
            if key[0] == "'":
                key = key[1:]
            if key[-1] == "'":
                key = key[:-1]
            if val[-1] == ')':
                val = val[:-1]
            if val[0] == "'":
                val = val[1:]
            if val[-1] == "'":
                val = val[:-1]

            newMapping[key] = val

        return newMapping
        
class BasketManager( ZPatterns.Specialists.Specialist):

    def newShoppingBasket(self, shopperId):
        """ make a basket for a new shopper... constructor like thingy """
        newBasket = self.newItem(self.shopperFolder.currentBasketId(shopperId))
        newBasket.basketItemIds = []
        return newBasket

    def getCurrentBasket(self, shopperId):
        """ get the current basket for a shopper... """
        return self.getItem( self.shopperFolder.currentBasketId( shopperId ))

    def addItemToBasket(self, shopperId, theItem, quantity, updateBasket, REQUEST):
        """ add an item to the shopper's basket... """

        theBasket = self.getCurrentBasket( shopperId )

        if theBasket is None:
            theBasket = self.newShoppingBasket( shopperId )

        basketItemIds = theBasket.basketItemIds
        
        theBasketItem = self.basketItemManager.getBasketItem( theBasket.id, theItem.id)

        if theBasketItem is None:
            theBasketItem = self.basketItemManager.newBasketItem( theBasket.id, theItem.id, 0 )

        if updateBasket:
            theBasketItem.quantity = quantity
        else:
            theBasketItem.quantity = theBasketItem.quantity + quantity

        if theBasketItem.id not in basketItemIds:
            basketItemIds.append(theBasketItem.id)
            theBasket.basketItemIds = basketItemIds

    def deleteItemFromBasket(self, theItem=None, shopperId=None, basketId=None, REQUEST=None):
        """ delete an item from the shopper's basket... """

        theBasket = None
        
        if basketId:
            theBasket = self.getItem( basketId )
        elif shopperId:
            theBasket = self.getCurrentBasket( shopperId )
            basketId = theBasket.id

        if theBasket is None:
            return # no point in deleting something from a non-existant basket!
            
        theBasketItem = self.basketItemManager.getBasketItem( basketId, theItem.id)

        if theBasketItem is None:
            return # there's no basket item here to delete!

        basketItemIds = theBasket.basketItemIds

        try:
            oldIndex = basketItemIds.index( theBasketItem.id )
            del basketItemIds[oldIndex]
        except ValueError:
            pass # we don't have that oldIndex! 
        
        theBasket.basketItemIds = basketItemIds

        theBasketItem.manage_delete()
        
    def calcTotal(self, basketId):
        """ calculate the total of the items in the basket...."""

        sum = 0.0

        theBasket = self.getItem( basketId )
        basketItemIds = getattr(theBasket, 'basketItemIds',[])
        
        for k in basketItemIds:
            
            theBasketItem = self.basketItemManager.getItem(k)
            theItem = self.marketItems.getItem(theBasketItem.marketItemId)
            quantity = theBasketItem.quantity
            if theItem:
                price = self.marketItems.calcPrice(theBasketItem)
            sum = sum + price*quantity

        return sum

