#
# Extensible User Folder
# 
# Postgres Property Source for exUserFolder
#
# (C) Copyright 2000,2001 The Internet (Aust) Pty Ltd
# ACN: 082 081 472  ABN: 83 082 081 472
# All Rights Reserved
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# Author: Andrew Milton <akm@theinternet.com.au>
# $Id: zodbPropSource.py,v 1.11 2001/12/19 21:39:03 rochael Exp $
from Globals import HTMLFile, MessageDialog, INSTANCE_HOME,Acquisition

from OFS.Folder import Folder

from Products.ZSQLMethods.SQL import SQL

from Products.exUserFolder.exUserFolder import exUserFolder
from Products.exUserFolder.Plugins import PluginRegister

import time
import zLOG

manage_addPropSourceForm=HTMLFile('manage_addzodbPropSourceForm', globals())

def manage_addzodbPropSource(self, REQUEST):
	""" Add a Postgres Prop Source """

	o = zodbPropSource()
	self._setObject('zodbPropSource', o, None, None, 0)
	o = getattr(self, 'zodbPropSource')

	# Allow Prop Source to setup default users...
	if hasattr(o, 'postInitialisation'):
		o.postInitialisation(REQUEST)
	self.currentPropSource=o

manage_addzodbPropSourceForm=HTMLFile('manage_addzodbPropSourceForm', globals())
manage_editzodbPropSourceForm=HTMLFile('manage_editzodbPropSourceForm', globals())

#
# Very very simple thing, used as an example of how to write a property source
# Not recommended for large scale production sites...
#

class zodbPropSource(Folder):
	""" Store User Data inside ZODB, the simplistic way """

	meta_type='Property Source'
	title='Simplistic ZODB Properties'
	icon ='misc_/exUserFolder/exUserFolderPlugin.gif'	
	manage_editForm=manage_editzodbPropSourceForm
	manage_tabs=Acquisition.Acquired
	
	def __init__(self):
		self.id='zodbPropSource'
		self.dict={}
		self.tempdict={}
		
	def hasProperty(self, key):
		zLOG.LOG("exUserFolder.zodbPropSource", zLOG.BLATHER,
                         "Property lookup",
                         "Looking for %s in %s" % (key, self.name))
		return self.dict[self.name].has_key(key)

	def setProperty(self, key, value):
		if not self.dict.has_key(self.name):
			self.dict[self.name]={}
		self.dict[self.name][key]=value
		self._p_changed=1
		
	def getProperty(self, key, default=None):
		if self.dict[self.name].has_key(key):
			return self.dict[self.name][key]
		return default

	def delProperty(self, key):
		self.delUserProperty(key=key, username=self.name)

	def delUserProperty(self, key, username):
		try:
			del self.dict[username][key]
			self._p_changed = 1
		except:
			pass

		try:
			del self.tempdict[username][key]
			self._p_changed = 1
		except:
			pass

	def setTempProperty(self, key, value):
		self.setUserProperty(key=key, value=value, username=self.name, temp=1)

	def listProperties(self):
		if self.dict.has_key(self.name):
			return self.dict[self.name].keys()
		return None

	def getUserProperty(self, key, username, default = None):
		return self.dict.get(username,{}).get(key,default)

	def setUserProperty(self, key, username, value, temp=0):
		if not self.dict.has_key(username):
			self.dict[username]={}
		self.dict[username][key]=value
		if temp:
			if not self.tempdict.has_key(username):
				self.tempdict[username]={}
			self.tempdict[username][key]=time.time()
		self._p_changed = 1

	def flushTempProperties(self):
		if self.tempdict.has_key(self.name):
			del self.tempdict[self.name]

	def listUserProperties(self, username):
		return self.dict.get(username,{}).keys()
	
	def createUser(self, username, REQUEST):
		self.dict[username]={}
		for k in REQUEST.keys():
			if k[:5]=='user_':
				key=k[5:]
				value=REQUEST[k]
				self.dict[username][key]=value
		self._p_changed=1

	def deleteUsers(self, userids):
		for u in userids:
			if self.dict.has_key(u):
				del self.dict[u]
		self._p_changed=1

	def updateUser(self, username, REQUEST):
		for k in REQUEST.keys():
			if k[:5]=='user_':
				key=k[5:]
				value=REQUEST[k]
				self.dict[username][key]=value
		self._p_changed=1
		
	def postInitialisation(self, REQUEST):
		pass

zodbPropReg=PluginRegister('zodbPropSource','Simplistic ZODB Property Source',
						   zodbPropSource, manage_addzodbPropSourceForm,
						   manage_addzodbPropSource,
						   manage_editzodbPropSourceForm)
exUserFolder.propSources['zodbPropSource']=zodbPropReg
