from StringIO import StringIO

from Products.CMFCore.utils import getToolByName
from Products.CMFCore.DirectoryView import addDirectoryViews

from Products.Archetypes import listTypes
from Products.Archetypes.Extensions.utils import installTypes

from Products.LinguaPlone import config

def installSkins(self, out):
    skins_tool = getToolByName(self, 'portal_skins')
    addDirectoryViews(skins_tool, 'skins', config.GLOBALS)
    for layer_name in config.SKIN_LAYERS:
        for skin_name in skins_tool.getSkinSelections():
            path = skins_tool.getSkinPath(skin_name)
            path = filter(None, [i.strip() for i in path.split(',')])
            if layer_name not in path:
                if 'custom' in path:
                    path.insert(path.index('custom') + 1, layer_name)
                else:
                    path.append(layer_name)
                print >> out, 'Layer %s added to skin %s.' % (layer_name,
                                                              skin_name)
            path = ','.join(path)
            skins_tool.addSkinSelection(skin_name, path)

def install(self):
    out = StringIO()

    if not hasattr(self, '_isPortalRoot'):
        print >> out, 'Must be installed in a CMF Site (read Plone)'
        return out.getvalue()

    qi = getToolByName(self, 'portal_quickinstaller', None)

    if not qi.isProductInstalled('PloneLanguageTool'):
        print >> out, 'Installed PloneLanguageTool product.'
        qi.installProduct('PloneLanguageTool')

    installSkins(self, out)

    types = listTypes(config.PKG_NAME)
    if types:
        installTypes(self, out, types, config.PKG_NAME)
        print >> out, 'Successfully installed types.'

    catalogtool = getToolByName(self, 'portal_catalog')
    if 'Language' not in catalogtool.indexes():
        catalogtool.addIndex('Language', 'FieldIndex')
        print >> out, 'Added Language to portal catalogs indexes.'
        catalogtool.reindexIndex('Language', None)
        print >> out, 'Reindexed Language index.'

    if 'Language' not in catalogtool.schema():
        catalogtool.addColumn('Language')
        print >> out, 'Added Language to portal catalogs columns.'

    return out.getvalue()
