from Testing import ZopeTestCase

# Make the boring stuff load quietly
ZopeTestCase.installProduct('CMFCore', quiet=1)
ZopeTestCase.installProduct('CMFDefault', quiet=1)
ZopeTestCase.installProduct('CMFCalendar', quiet=1)
ZopeTestCase.installProduct('CMFTopic', quiet=1)
ZopeTestCase.installProduct('DCWorkflow', quiet=1)
ZopeTestCase.installProduct('CMFActionIcons', quiet=1)
ZopeTestCase.installProduct('CMFQuickInstallerTool', quiet=1)
ZopeTestCase.installProduct('CMFFormController', quiet=1)
ZopeTestCase.installProduct('GroupUserFolder', quiet=1)
ZopeTestCase.installProduct('ZCTextIndex', quiet=1)
ZopeTestCase.installProduct('TextIndexNG2', quiet=1)
ZopeTestCase.installProduct('SecureMailHost', quiet=1)
ZopeTestCase.installProduct('CMFDynamicViewFTI', quiet=1)
ZopeTestCase.installProduct('CMFPlone')

ZopeTestCase.installProduct('Archetypes')
ZopeTestCase.installProduct('PortalTransforms', quiet=1)
ZopeTestCase.installProduct('MimetypesRegistry', quiet=1)
ZopeTestCase.installProduct('PloneLanguageTool')

# Make sure the dummy types are registered
from Products.LinguaPlone import examples
from Products.LinguaPlone.tests import dummy
ZopeTestCase.installProduct('LinguaPlone')

from Products.PloneTestCase import PloneTestCase
from Products.LinguaPlone.tests import utils
from Testing.ZopeTestCase.utils import setupCoreSessions

PORTAL_NAME = 'plone_ml'
PRODUCTS = ('Archetypes', 'PloneLanguageTool', 'LinguaPlone')

PloneTestCase.setupPloneSite(id=PORTAL_NAME, products=PRODUCTS)


class LinguaPloneTestCase(PloneTestCase.PloneTestCase):

    def getPortal(self):
        return self.app[PORTAL_NAME]

    def _setup(self):
        # Transparently extend the base setup
        PloneTestCase.PloneTestCase._setup(self)
        utils.setupGlobalRequest(self.app.REQUEST)
        setupCoreSessions(self.app)

    def addLanguage(self, language):
        self.portal.portal_languages.addSupportedLanguage(language)

    def setLanguage(self, language):
        request = self.app.REQUEST
        request['set_language'] = language
        self.portal.portal_languages.setLanguageBindings()


class LinguaPloneFunctionalTestCase(ZopeTestCase.Functional, LinguaPloneTestCase):
    pass
