from AccessControl import ClassSecurityInfo

from Products.LinguaPlone.public import *
from Products.LinguaPlone.config import *

if IS_PLONE_2_0:
    class BrowserDefaultMixin: pass
else:
    from Products.CMFDynamicViewFTI.browserdefault import BrowserDefaultMixin

SimpleSchema = BaseSchema + Schema((
    TextField('body',
              required = 1,
              searchable = 1,
              default_output_type = 'text/html',
              allowable_content_types = ('text/plain',
                                         'text/restructured',
                                         'text/html',
                                         'application/msword'),
              widget = RichWidget(description = "Enter or upload text for the body of the document."),
             ),
    StringField('contactName',
                languageIndependent = 1,
                widget = StringWidget(description = "Enter a contact person.")
               ),
    StringField('contactName2',
                languageIndependent = 1,
                widget = StringWidget(description = "Enter a contact person.")
               ),
    StringField('contactName3',
                languageIndependent = 1,
                widget = StringWidget(description = "Enter a contact person.")
               ),
    StringField('contactName4',
                languageIndependent = 0,
                accessor = 'getFourthContactName',
                mutator = 'setFourthContactName',
                widget = StringWidget(description = "This field has custom accessor and mutator.")
               ),
    StringField('contactName5',
                languageIndependent = 1,
                accessor = 'getFifthContactName',
                mutator = 'setFifthContactName',
                widget = StringWidget(description = "This field has custom accessor and mutator.")
               ),
    StringField('langIndependentInBase',
                languageIndependent = 1,
                widget = StringWidget(description = "This field is language independent in SimpleType.")
               ),
    StringField('langIndependentInDerived',
                languageIndependent = 0,
                widget = StringWidget(description = "This field is not language independent in DerivedType.")
               ),
    StringField('langIndependentInBoth',
                languageIndependent = 1,
                widget = StringWidget(description = "This field is language independent everywhere.")
               ),
    ))


class SimpleType(BaseContent):
    """A simple multilingual archetype"""
    schema = SimpleSchema

    security = ClassSecurityInfo()
    _at_rename_after_creation = True

    def setContactName(self, value, **kw):
        """Set contact name. This tests language independent method generation """
        self.getField('contactName').set(self, value, **kw)
        self.testing = value

    def getFourthContactName(self):
        """Custom accessor."""
        return 'getFourthContactName'

    def setFourthContactName(self, value, **kw):
        """Custom mutator."""
        self.getField('contactName4').set(self, 'cn4 ' + value, **kw)

    def getFifthContactName(self):
        """Custom accessor."""
        return 'getFifthContactName'

    def setFifthContactName(self, value, **kw):
        """Custom mutator."""
        self.getField('contactName5').set(self, 'cn5 ' + value, **kw)

registerType(SimpleType, PKG_NAME)


DerivedSchema = SimpleSchema.copy()
DerivedSchema['langIndependentInBase'].languageIndependent = 0
DerivedSchema['langIndependentInDerived'].languageIndependent = 1

class DerivedType(SimpleType):
    """A derived multilingual archetype"""
    schema = DerivedSchema

    security = ClassSecurityInfo()

registerType(DerivedType, PKG_NAME)


class SimpleFolder(BaseFolder):
    """A simple folderish multilingual archetype"""
    schema = BaseSchema

    security = ClassSecurityInfo()

registerType(SimpleFolder, PKG_NAME)


class DynamicFolder(BrowserDefaultMixin, BaseFolder):
    """A simple folderish multilingual archetype"""
    schema = BaseSchema

    security = ClassSecurityInfo()

registerType(DynamicFolder, PKG_NAME)


class OrderedFolder(OrderedBaseFolder):
    """A simple ordered-folderish multilingual archetype"""
    schema = BaseSchema

    security = ClassSecurityInfo()

registerType(OrderedFolder, PKG_NAME)


class BTreeFolder(BaseBTreeFolder):
    """A simple btree-folderish multilingual archetype"""
    schema = BaseSchema

    security = ClassSecurityInfo()

registerType(BTreeFolder, PKG_NAME)


# Unregistered types

class UnregSimpleType(BaseContent):
    """A simple multilingual archetype"""
    schema = SimpleSchema

    security = ClassSecurityInfo()

    def getFourthContactName(self):
        """Custom accessor."""
        return 'getFourthContactName'

    def setFourthContactName(self, value, **kw):
        """Custom mutator."""
        self.getField('contactName4').set(self, 'cn4 ' + value, **kw)

    def getFifthContactName(self):
        """Custom accessor."""
        return 'getFifthContactName'

    def setFifthContactName(self, value, **kw):
        """Custom mutator."""
        self.getField('contactName5').set(self, 'cn5 ' + value, **kw)


class UnregDerivedType(UnregSimpleType):
    """A derived multilingual archetype"""
    schema = DerivedSchema

    security = ClassSecurityInfo()
