"""
$Id: config.py,v 1.4 2005/12/15 13:04:19 b_mathieu Exp $
"""

__author__  = ''
__docformat__ = 'restructuredtext'

# Python imports
import os

# CMF imports
from Products.CMFCore import CMFCorePermissions

# Check if we have to be in debug mode
if os.path.isfile(os.path.abspath(os.path.dirname(__file__)) + '/debug.txt'):
    DEBUG_MODE = 1
else:
    DEBUG_MODE = 0

# Set log options correctly
import Log
if DEBUG_MODE:
    Log.LOG_LEVEL = Log.LOG_DEBUG
else:
    Log.LOG_LEVEL = Log.LOG_NOTICE

# Detect Plone version
HAS_PLONE_2_1 = False
try:
    # Plone 2.1
    from Products.CMFPlone.utils import transaction_note
    HAS_PLONE_2_1 = True
except ImportError:
    pass

from Products.PloneArticle.Log import *
Log = Log
Log(LOG_NOTICE, "Starting %s at %d debug level" % (os.path.dirname(__file__), LOG_LEVEL, ))

GLOBALS = globals()
PROJECTNAME = "PloneArticle"
SKINS_DIR = 'skins'

# Configlets
plonearticle_prefs_configlet = {
    'id': 'plonearticle_prefs',
    'appId': PROJECTNAME,
    'name': 'PloneArticle Preferences',
    'action': 'string:$portal_url/plonearticle_prefs_form',
    'category': 'Products',
    'permission': (CMFCorePermissions.ManagePortal,),
    'imageUrl': 'PloneArticle.gif',
    }
