"""
$Id: IArticle.py,v 1.2 2004/12/28 10:38:36 pjgrizel Exp $
"""
__author__  = ''
__docformat__ = 'restructuredtext'

from Interface import Attribute
try:
    from Interface import Interface
except ImportError:
    # for Zope versions before 2.6.0
    from Interface import Base as Interface


"""
VOCABULARY:

  - Article is a document containing "referencing" Images and Attachments

  - Attachments are files referenced in Article
"""

class IArticleAttachments(Interface):

    #
    # Attachments
    #
    
    def getAttachment(self, UID):
        """
        Parameters
            UID -> UID of attachment
            
        Returns a file object
        """
    
    def getAttachmentBrain(self, UID):
        """
        Parameters
            UID -> UID of attachment
            
        Returns a brain of attachment
        """
        
    def getAttachments(self):
        """
        Returns all attachment objects referenced in Article
        """
        
    def getAttachmentBrains(self):
        """
        Returns all attachment brains referenced in Article
        """
    
    def getAttachmentUIDs(self):
        """
        Returns all attachment uids referenced in Article
        """
        
    def addAttachment(self, title, description, file):
        """
        Attach a file to Article. Add attachment in Article.
        
        Parameters
            title -> title of attachment
            description -> description of attachment
            attachment -> file data (upload) to attach
        """
    
    def addAttachmentFromObject(self, attachment):
        """
        Attach a file to Article. Just add a reference between attachment and
        article.
        
        Parameters
            attachment -> file object to attach
        """
        
    def addAttachmentFromUID(self, UID):
        """
        Attach a file to Article. Just add a reference between attachment and
        article.
        
        Parameters
            UID -> UID of a file to attach
        """
    
    def editAttachment(self, UID, title, description):
        """
        Edit an attachment.
        
        Parameters
            UID -> UID of attachment
            title -> title of attachment
            description -> description of attachment
        """
    
    def editAttachments(self, attachment_infos):
        """
        Edit attachments.
        
        Parameters
            
            attachment_infos -> List of dictionnaries (UID, title, description)
        """
    
    def removeAttachment(self, UID):
        """
        Remove an attachment from Article.
        
        Parameters
            UID -> UID of attachment
        """
        
    def removeAttachments(self, UIDs):
        """
        Remove attachments from Article.
        
        Parameters
            UIDs -> list of attachment UIDs
        """
        
    def moveAttachmentsByDelta(self, UIDs, delta):
        """
        Change attachments order.
        
        Parameters
            UIDs -> list of attachment UIDs
            delta -> delta of move. 
        """
    
    def copyAttachmentsToClipboard(self, UIDs):
        """
        Copy attachments to clipboard.
        
        Parameters
            UIDs -> list of attachment UIDs
        """
    
    def isAttachmentContained(self, UID):
        """
        Return true if attachment is stored in article else return false.
        """
    
class IArticleImages(Interface):
    #
    # Images
    #
    
    def getImage(self, UID):
        """
        Parameters
            UID -> UID of image
            
        Returns a image object
        """
    
    def getImageBrain(self, UID):
        """
        Parameters
            UID -> UID of image
            
        Returns a brain of image
        """
        
    def getImages(self):
        """
        Returns all image objects referenced in Article
        """
        
    def getImageBrains(self):
        """
        Returns all image brains referenced in Article
        """
    
    def getImageBrains(self):
        """
        Returns all image references from Article
        """
    
    def getImageUIDs(self):
        """
        Returns all image uids referenced in Article
        """
        
    def addImage(self, title, description, image):
        """
        Attach an image to Article. Add image in Article.
        
        Parameters
            title -> title of image
            description -> description of image
            image -> image data (upload) to attach
        """
    
    def addImageFromObject(self, image):
        """
        Attach an image to Article. Just add a reference between image and
        article.
        
        Parameters
            image -> image object to attach
        """
        
    def addImageFromUID(self, UID):
        """
        Attach an image to Article. Just add a reference between image and
        article.
        
        Parameters
            UID -> UID of an image to attach
        """
    
    def editImage(self, UID, title, description):
        """
        Edit an image.
        
        Parameters
            UID -> UID of image
            title -> title of image
            description -> description of image
        """
    
    def editImages(self, image_infos):
        """
        Edit images.
        
        Parameters
            
            image_infos -> List of dictionnaries (UID, title, description)
        """
    
    def removeImage(self, UID):
        """
        Remove an image from Article.
        
        Parameters
            UID -> UID of image
        """
        
    def removeImages(self, UIDs):
        """
        Remove images from Article.
        
        Parameters
            UIDs -> list of image UIDs
        """
        
    def moveImagesByDelta(self, UIDs, delta):
        """
        Change images order.
        
        Parameters
            UIDs -> list of image UIDs
            delta -> delta of move. 
        """
    
    def copyImagesToClipboard(self, UIDs):
        """
        Copy images to clipboard.
        
        Parameters
            UIDs -> list of image UIDs
        """
        
    def isImageContained(self, UID):
        """
        Return true if image is stored in article else return false.
        """

class IArticleLinks(Interface):
    #
    # Links
    #
    
    def getLink(self, UID):
        """
        Parameters
            UID -> UID of link
            
        Returns a link object
        """
    
    def getLinkBrain(self, UID):
        """
        Parameters
            UID -> UID of link
            
        Returns a brain of link
        """
        
    def getLinks(self):
        """
        Returns all link objects referenced in Article
        """
        
    def getLinkBrains(self):
        """
        Returns all link brains referenced in Article
        """
    
    def getLinkBrains(self):
        """
        Returns all link references from Article
        """
    
    def getLinkUIDs(self):
        """
        Returns all link uids referenced in Article
        """
        
    def addLink(self, title, description, remote_url):
        """
        Attach a link to Article. Add link in Article.
        
        Parameters
            title -> title of link
            description -> description of link
            remote_url -> link url
        """
    
    def addLinkFromObject(self, object):
        """
        Attach an object to Article. Just add a reference between object and
        article.
        
        Parameters
            object -> object to attach
        """
        
    def addLinkFromUID(self, UID):
        """
        Attach an object to Article. Just add a reference between object and
        article.
        
        Parameters
            UID -> UID of an object to attach
        """
    
    def editLink(self, UID, title, description):
        """
        Edit an object.
        
        Parameters
            UID -> UID of object
            title -> title of object
            description -> description of object
        """
    
    def editLinks(self, link_infos):
        """
        Edit images.
        
        Parameters
            
            link_infos -> List of dictionnaries (UID, title, description)
        """
    
    def removeLink(self, UID):
        """
        Remove a link from Article.
        
        Parameters
            UID -> UID of link
        """
        
    def removeLinks(self, UIDs):
        """
        Remove links from Article.
        
        Parameters
            UIDs -> list of link UIDs
        """
        
    def moveLinksByDelta(self, UIDs, delta):
        """
        Change links order.
        
        Parameters
            UIDs -> list of link UIDs
            delta -> delta of move. 
        """
    
    def copyLinksToClipboard(self, UIDs):
        """
        Copy links to clipboard.
        
        Parameters
            UIDs -> list of link UIDs
        """
        
    def isLinkContained(self, UID):
        """
        Return true if link is stored in article else return false.
        """
