##
## Copyright (C) 2001 Thierry MICHEL <thierry@nekhem.com>
##  
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##  
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##  
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##  
##

## Here are requests to have informations about tables.

table_infos = """select  a.attnum,a.attname,
                   t.typname,a.attlen,a.attnotnull
                   from pg_attribute a, pg_type t, pg_class c
                   where 
                   c.relname = '%s' and 
                   a.attnum >0 and
                   a.attrelid = c.oid and
                   a.atttypid = t.oid
                   order by a.attnum """

table_infos2 = """select 
                   t1.typname AS basetable,
                   t2.typname AS reftable,
                   d.description,
                   r.tgnargs AS nargs,
                   r.tgargs AS arguments,
                   r.tgdeferrable AS deferrable,
                   r.tginitdeferred AS initiallydeferred,
                   r.tgconstrname AS constrname 
                   from pg_trigger r, pg_type t1, pg_type t2 ,pg_description d
                   where
                   t1.typname='%s'
                   and
                   d.description ~* 'referential integrity'
                   and
                   r.tgenabled='t'
                   and 
                   r.tgisconstraint ='t'
                   and
                   r.tgfoid = d.objoid
                   and
                   t1.typrelid=r.tgrelid
                   and
                   t2.typrelid=r.tgconstrrelid"""

table_infos3 = """SELECT x.indisprimary AS pkey,
                   pg_get_indexdef(x.indexrelid) AS indexdef
                   FROM pg_index x,
                   pg_class c, pg_class i
                   WHERE
                   ((c.oid = x.indrelid) AND
                   (i.oid = x.indexrelid)) AND
                   c.relname = '%s'
                   ;"""

from PoPy_DA import PoPyConnection, database_type, addPoPyConnectionForm
from string import find,split
from PoPy_DA import DTMLFile

def addPoPyConnectionBrowser(self, id, title, connection_string, connected=None,attempts=10,seconds=5,REQUEST=None):
    """Add a Z PoPy DB connection to a folder"""
        
    if not connected is None:
        connected = 1
    self._setObject(id, PoPyConnectionBrowser(id,
                                   title,
                                   connection_string,
                                   connected,
                                   attempts,
                                   seconds))
    if REQUEST is not None:
        return self.manage_main(self,REQUEST)

class PoPyConnectionBrowser(PoPyConnection):
    """PoPy Connection with tables browser feature"""

    
    manage_options=PoPyConnection.manage_options+(
        {'label':'Browser','action':'manage_browser'},
        )

    manage_browser = DTMLFile('dtml/PoPyconnectionBrowser',globals())

    def __is_foreign_key(self,description):
        res=1
        if find(description,'FOREIGN') == -1:
            res=0
        return res

    def __get_source_table(self,arguments):
        res=''
        res= split(arguments,'\\000')[2]

        return res

    def __get_source_field(self,arguments):
        res= split(arguments,'\\000')[4]
        return res

    def __set_table_fkeys(self,tablename):
        if self._v_connected:
            o,records = self._v_database_connection.query(table_infos2
                                                          % tablename)
        self.fkeys = []
        for r in records:
            if self.__is_foreign_key(r[2]):
                info = (self.__get_source_table(r[4]),
                        self.__get_source_field(r[4]))
                self.fkeys.append(info)
                

    def __set_table_pkeys(self,tablename):
        if self._v_connected:
            o,records = self._v_database_connection.query(table_infos3
                                                          % tablename)
        self.pkeys = []
        from re import search
        from string import split
        for r in records:
            if r[0] == 1:
                rgx = search('\(.*\)',r[1])
                info = split(rgx.string[rgx.regs[0][0]+1:rgx.regs[0][1]-1],' ')
                for i in range(0,len(info),2):
                    self.pkeys.append(info[i])

    def is_primary_key(self,field):
        if field in self.pkeys:
            return 1
        return 0
    
    def is_foreign_key(self,field):
        for i in self.fkeys:
            if field in i:
                return i[0]
        return None

    def manage_get_table_infos(self,tablename):
        " "
        if self._v_connected:
            o,r = self._v_database_connection.query(table_infos % tablename)
            self.__set_table_fkeys(tablename)
            self.__set_table_pkeys(tablename)
        else:
            return []
        result = []
        for item in r:
            rsp = {}
            i = 0
            for item2 in o:
                rsp[item2['name']] = item[i]
                i = i + 1
            result.append(rsp)
        return result

    def manage_get_tables (self):
        " "
        if self._v_connected:
            o,r = self._v_database_connection.query("select tablename,tableowner from pg_tables where tableowner != 'postgres'")
        else:
            return []

        result = []
        for item in r:
            rsp = {}
            rsp['tablename'] = item[0]
            rsp['tableowner'] = item[1]
            result.append(rsp)

        return result

    
