# -*- coding: UTF-8 -*-
# -*- Mode: Python; py-indent-offset: 4 -*-
# Authors: Nik Kim <fafhrd@legco.biz> 
"""
$Id: MailTransportInfo.py,v 1.5 2004/03/16 12:45:14 fafhrd91 Exp $
"""

import traceback
from Globals import InitializeClass
from Products.Archetypes.config import UID_CATALOG
from Products.Archetypes.Referenceable import Referenceable
from Products.Archetypes.interfaces.referenceable import IReferenceable
from Products.BTreeFolder2.BTreeFolder2 import BTreeFolder2
from Products.CMFCore.utils import getToolByName, SimpleItemWithProperties
from Products.CMFCore.CMFCorePermissions import View, ManagePortal

from AccessControl import ClassSecurityInfo
from AccessControl.SecurityManagement import \
     newSecurityManager, noSecurityManager, getSecurityManager

from email.Utils import parseaddr, formataddr

import Bouncers
from debug import log, log_exc
from interfaces.mailreceiver import IMailReceiver
from interfaces.subscribeable import IBaseSubscribeable
from config import mtinfo_relation, error_templates, PROJECTNAME


class MailTransportInfo(Referenceable, SimpleItemWithProperties):
    """ """

    __implements__ = IReferenceable
    
    meta_type = 'MailTransportInfo'

    security = ClassSecurityInfo()

    title = ''
    reply_to = ''
    return_path = ''
    handle_errors = 0
    list_id = ''

    _properties = (
        {'id':'title', 'type':'string', 'mode':'w'},
        
        {'id':'reply_to', 'type':'string', 'mode':'w'},
        {'id':'return_path', 'type':'string', 'mode':'w'},
        {'id':'handle_errors', 'type': 'boolean', 'mode':'w'},
       
        {'id':'list_id', 'type':'string', 'mode':'w'},
        )

    def __init__(self, id, object):
        self.id = id
        self._uid_ob = object

    def manage_afterAdd(self, item, container):
        Referenceable.manage_afterAdd(self, item, container)

        try:
            self.addReference(self._uid_ob, mtinfo_relation)
            del self._uid_ob
        except:
            traceback.print_exc()

        uidcatalog = getattr(self, UID_CATALOG)
        uidcatalog.catalog_object(self, '/'.join(self.getPhysicalPath()))

    def manage_beforeDelete(self, item, container):
        Referenceable.manage_beforeDelete(self, item, container)

        uidcatalog = getattr(self, UID_CATALOG)
        uidcatalog.uncatalog_object(self, '/'.join(self.getPhysicalPath()))

    def getHeaders(self):
        """ """
        headers = {}

        reply_to = self.reply_to
        if reply_to:
            headers['reply-to'] = reply_to
        else:
            headers['reply-to'] = self.email_from_address

        return_path = self.return_path
        if return_path:
            headers['errors-to'] = return_path

        return headers

    security.declarePrivate('getBouncePath')
    def getBouncePath(self):
        """ """
        return self.return_path

    security.declarePrivate('getReturnPath')
    def getReturnPath(self):
        """ """
        return_path = self.return_path
        if return_path:
            return return_path

        reply_to = self.reply_to
        if reply_to:
            return reply_to

        portal = getToolByName(self, 'portal_url').getPortalObject()
        return portal.email_from_address

    security.declareProtected(ManagePortal, 'getRecipientObject')
    def getRecipientObject(self):
        """ """
        refs = self.getRefs('MailTransport')
        if refs:
            return refs[0]
        else:
            return None

    security.declareProtected(ManagePortal, 'view')
    def view(self):
        """ """
        return self.mtinfo_view()

    __call__ = view
    index_html = None

    security.declarePrivate('deliver')
    def deliver(self, tool, to_hdr, message, portal):
        log('------------- begin loading from: %s ----------------'%
	    message.get('from',''))

        mtool = portal.portal_membership

        # find recipient
        recipient = self.getRecipientObject()
        if recipient is None:
            tool.replyError(PROJECTNAME, error_templates[2],
                            {'portal_email': portal.email_from_address,
                             'portal_email_from': portal.email_from_name
                             }, message)
            log("Can't find destination location.")
            return

        # check IMailReciever
        if not IMailReceiver.isImplementedBy(recipient):
            tool.replyError(PROJECTNAME, error_templates[4],
                            {'portal_email': portal.email_from_address,
                             'portal_email_from': portal.email_from_name
                             }, message)
            return
        recipient = recipient.__of__(self)

        # check bounce
        if self.handle_errors and (to_hdr == self.return_path):
            try:
                bouncedAddresses = Bouncers.ScanMessage(message)
                log('bounced: %s'%bouncedAddresses)
                if bouncedAddresses:
                    impl_subs = IBaseSubscribeable.isImplementedBy(recipient)
                    for email in bouncedAddresses:
                        members = mtool.searchMembers('email', email)
                        if impl:
                            for member in members:
                                try:
                                    recipient.message_bounce(member,message,tool,portal)
                                except Exception, e:
                                    log_exc(e)
                                   
                        elif impl_subs:
                            # try unsubscribe
                            try:
                                recipient.removeSubscribersByUserId(
                                    [member['username'] for member in members])
                                recipient.removeSubscribersByEMail(email)
                            except Exception, e:
                                log_exc(e)
                    return
            except Exception, e:
                log_exc(e)

        # find user
        mfrom = parseaddr(message['From'])[1]
        members = mtool.searchMembers('email', mfrom)
        if members:
            l_members = len(members)
            if l_members > 1:
                # more than one members found error
                tool.replyError(PROJECTNAME, error_templates[3], {}, message)
                log('More than one member found. %s, %s'%(members, mfrom))
                return
            elif l_members == 1:
                member = mtool.getMemberById(members[0]['username'])
        else:
            # member not found
            tool.replyError(PROJECTNAME, error_templates[1], {}, message)
            log('Member not found. %s'%mfrom)
            return

        charset = portal.portal_properties.site_properties.default_charset

        # set security manager
        user = member.getUser().__of__(portal.acl_users)
        newSecurityManager(None, user)

        # check command
        #command = self.check_command(msg)
        command = None
        if command:
            try:
                recipient.message_command(user, message, command, tool, portal, charset)
            except Exception, e:
                log_exc(e)
        else:
            # deliver message
            try:
                if message.has_key('In-Reply-To'):
                    recipient.message_reply(user,message,tool,charset)
                else:
                    recipient.message_new(user,message,tool,charset)
            except Exception, e:
                log_exc(str(e))

	noSecurityManager()

        log('------------- end loading --------------')


InitializeClass(MailTransportInfo)
