# -*- coding: UTF-8 -*-
# -*- Mode: Python; py-indent-offset: 4 -*-
# Authors: Nik Kim <fafhrd@legco.biz>

import re, traceback
from Globals import InitializeClass
from AccessControl import ClassSecurityInfo
from Products.CMFCore.utils import getToolByName
from Products.CMFCore.CMFCorePermissions import View, ModifyPortalContent
from Products.Archetypes.config import TOOL_NAME

from config import PROJECTNAME
from interfaces.subscribeable import *
from PortalTransportPermissions import *
from SubscribeableBase import BaseSubscribeable

siType = 'PT_SIAnonymous'

class SubscribeableAnonymous(BaseSubscribeable):
    """ """

    __implements__ = (IAnonymousSubscribeable,)

    security = ClassSecurityInfo()

    security.declareProtected(AllowSubscription, 'isAllowAnonymousSubscribers')
    def isAllowAnonymousSubscribers(self):
        """ """
        return 1

    security.declareProtected(AllowSubscription,
                              'isAutoActivateAnonymousSubscription')
    def isAutoActivateAnonymousSubscription(self):
	""" auto activate or start activate process """
        return 0

    security.declareProtected(AllowSubscription,
                              'isSendSubscriptionNotifications')
    def isSendSubscriptionNotifications(self):
        """ """
        return 1

    security.declareProtected(AllowSubscription, 'isAnonymousSubscribed')
    def isAnonymousSubscribed(self, email):
        """ """
        subs = getToolByName(self, 'portal_subscriptions')
        return subs.isSubscribed(self, email=email, member_id='Anonymous User',
                                 review_state=('active', 'deactivation'))

    security.declareProtected(AllowSubscription, 'subscribeAnonymous')
    def subscribeAnonymous(self, email, fullname,
                           text_format='plain', hint=''):
        """ """
        mtool = self.portal_membership
        subs = self.portal_subscriptions

        if not mtool.isAnonymousUser():
            raise ValueError, 'Only Anonymous User can be subscribed.'

        if subs.isAnonymousSubscribed(email):
            raise ValueError, 'Anonymous user with %s email alredy subscribed.'%email

        subs_info = subs.getSubscriptions(self, email=email, review_state='activation')
        if subs_info:
            for si in subs_info:
                si.wm_activation()
        else:
            subs.addSubscriptions(siType, ({'email': email, 'content': self,
                                            'hint': hint, 'text_format': text_format,
                                            'fullname': fullname},))

    security.declareProtected(AllowSubscription, 'unsubscribeAnonymous')
    def unsubscribeAnonymous(self, email):
        """ """
        subs = self.portal_subscriptions

        for si in subs.getSubscriptions(self, email=email):
            si.unsubscribe()

InitializeClass(SubscribeableAnonymous)
