# -*- coding: UTF-8 -*-
# -*- Mode: Python; py-indent-offset: 4 -*-
# Authors: Nik Kim <fafhrd@legco.biz>

from ExtensionClass import Base
from Globals import InitializeClass
from AccessControl import ClassSecurityInfo
from Products.CMFCore.utils import getToolByName
from Products.CMFCore.CMFCorePermissions import View, ModifyPortalContent

from config import mtinfo_relation
from interfaces.subscribeable import IBaseSubscribeable
from PortalTransportPermissions import *

class BaseSubscribeable(Base):
    """ """

    __implements__ = (IBaseSubscribeable,)

    security = ClassSecurityInfo()

    security.declareProtected(View, 'isSendSubscriptionNotifications')
    def isSendSubscriptionNotifications(self):
        """ """
        return 1

    security.declareProtected(View, 'getEmailAddress')
    def getEmailAddress(self):
        """ """
        mtinfo = self.getBRefs(mtinfo_relation)
        if mtinfo:
            return mtinfo[0].getReturnPath()
        else:
            self.email_from_address

    security.declareProtected(ModifyPortalContent, 'getSubscribers')
    def getSubscribers(self, hint=''):
        """ """
        subs = getToolByName(self, 'portal_subscriptions')
        return subs.getSubscriptions(self, hint=hint)

    security.declareProtected(ModifyPortalContent, 'removeSubscribers')
    def removeSubscribers(self, ids, noemail=0):
        """ """
        subs = getToolByName(self, 'portal_subscriptions')
        subs.removeSubscriptions(ids, noemail)

    security.declareProtected(ModifyPortalContent, 'removeSubscribersByEMail')
    def removeSubscribersByEMail(self, emails, noemail=0):
        """ """
        subs = getToolByName(self, 'portal_subscriptions')

        sis = subs.getSubscriptions(self, email=emails)
        subs.removeSubscriptions([si.getId() for si in sis], noemail)

    security.declareProtected(ModifyPortalContent, 'removeSubscribersByUserId')
    def removeSubscribersByUserId(self, user_ids, noemail=0):
        """ """
        subs = getToolByName(self, 'portal_subscriptions')

        sis = subs.getSubscriptions(self, member_id=user_ids)
        subs.removeSubscriptions([si.getId() for si in sis], noemail)

    security.declarePrivate('sendMessage')
    def sendMessage(self, content, parent):
        """ send message to subscribers """
        pass

InitializeClass(BaseSubscribeable)
