# -*- coding: UTF-8 -*-
# -*- Mode: Python; py-indent-offset: 4 -*-
# Authors: Nik Kim <fafhrd@legco.biz> 
__version__ = '$Revision: 1.2 $'[11:-2]

import re, traceback
from Globals import InitializeClass
from Acquisition import aq_parent, aq_inner
from AccessControl import ClassSecurityInfo
from Products.CMFCore.utils import UniqueObject, _checkPermission
from Products.CMFCore.CMFCorePermissions import View, ManagePortal

from Products.Archetypes.config import TOOL_NAME
from Products.Archetypes.interfaces.referenceable import IReferenceable

from config import *
from SubscriptionEngine import SubscriptionEngine

class SubscriptionsTool(UniqueObject, SubscriptionEngine):
    """ class for manage single subscription """

    id = 'portal_subscriptions'
    meta_type = PROJECTNAME + ' Subscriptions Tool'

    security = ClassSecurityInfo()

    def __init__(self):
        SubscriptionEngine.__init__(self, self.id)

    security.declareProtected(View, 'subscribe')
    def getMemberSubscriptions(self):
        """ """
        mtool = aq_parent(aq_inner(self)).portal_membership
        if mtool.isAnonymousUser():
            return []

        subs = self.getSubscriptions(None, (str(mtool.getAuthenticatedMember()),))

        result = []
        for s in subs:
            info = self._getOb(s[2], None)

            if info is not None:
                content = info.getSubscribedContent()
                if (content is not None) and (_checkPermission('View', content)):
                    result.append(s + (content,))
        return result
    
    security.declareProtected(View, 'subscribe')
    def subscribe(self, content):
        """ """
        portal = aq_parent(aq_inner(self))
        
        mtool = portal.portal_membership
        if mtool.isAnonymousUser():
            return

        props = portal.portal_properties.portaltransport_properties
        if content.getTypeInfo().getId() not in props.subscriptions_types:
            return

        self.addSubscriptions((str(mtool.getAuthenticatedMember()),), content)

    security.declareProtected(View, 'unsubscribe')
    def unsubscribe(self, content):
        """ """
        mtool = aq_parent(aq_inner(self)).portal_membership
        if mtool.isAnonymousUser():
            return 0

        member = mtool.getAuthenticatedMember()
        subs = self.getSubscriptions(content, member_id=member.getMemberId())
        if subs:
           for si in subs:
               try:
                   si.wm_deactivate()
               except:
		   pass
        else:
           raise Exception, 'You are not subscribed.'	


InitializeClass(SubscriptionsTool)
