# -*- coding: UTF-8 -*-
# -*- Mode: Python; py-indent-offset: 4 -*-
# Authors: Nik Kim <fafhrd@legco.kz> 
__version__ = '$Revision: 1.11 $'[11:-2]

import os
from Globals import package_home
from Products.CMFCore.CMFCorePermissions import \
     AddPortalContent, ModifyPortalContent, ManagePortal

GLOBALS = globals()

_zptdir = os.path.join(package_home(globals()), 'zpt')

ADD_CONTENT_PERMISSION = AddPortalContent
PROJECTNAME = "PortalTransport"
SKINS_DIR = 'skins'

error_templates = {
    1: 'error_1',
    2: 'error_2',
    3: 'error_3',
    4: 'error_4', # recipient can't recieve mails
    }

mailtransportSkin = 'portaltransport/maillist'

mtinfo_relation = 'MailTransport'

portaltransport_properties = (
    ('unique_emails', 'boolean', 0),
    ('types', 'lines', ['ForumNB']),
    ('mailer', 'string', 'PortalTransport MailTransport'),
    ('mta_ips', 'lines', []),
    ('max_size', 'int', 0),
    ('commands', 'lines', ['subscribe', 'unsubscribe']),
    ('allow_subscriptions', 'boolean', 0),
    ('subscriptions_types', 'lines', ['Document', 'Event']),
    )

mailtransport_configlet = {
    'id': 'PortalTransport_mailtransport',
    'appId': PROJECTNAME,
    'name': 'Mail Transport settings',
    'action': 'string:$portal_url/prefs_mailtransport_form',
    'category': 'Products',
    'permission': ('Manage portal',),
    'imageUrl': 'mailtransport_icon.gif',
    }

mailtemplates_configlet = {
    'id': 'PortalTransport_mailtemplates',
    'appId': PROJECTNAME,
    'name': 'Mail Templates settings',
    'action': 'string:$portal_url/prefs_mailtemplates',
    'category': 'Products',
    'permission': ('Manage portal',),
    'imageUrl': 'mailtransport_icon.gif',
    }

subscriptions_configlet = {
    'id': 'PortalTransport_subscriptions',
    'appId': PROJECTNAME,
    'name': 'Portal Subscriptions settings',
    'action': 'string:$portal_url/prefs_portalsubscriptions',
    'category': 'Products',
    'permission': ('Manage portal',),
    'imageUrl': 'mailtransport_icon.gif',
    }


# portal subscriptions
subscription_activation = 'subscription_activation'
subscription_deactivation = 'subscription_deactivation'
activate_action = 'pt_activate?uid=%s'
deactivate_action = 'pt_deactivate?uid=%s'
