""" TTW Object

a generic object for holding generic data :-)

(C) 2003 by Christian Scholz/MrTopf of COM.lounge

"""


from AccessControl import ClassSecurityInfo, getSecurityManager
from Products.CMFCore.PortalContent import PortalContent
from Products.CMFCore import CMFCorePermissions
from Products.CMFCore.utils import getToolByName
from Products.CMFDefault.DublinCore import DefaultDublinCoreImpl
from Products.CMFDefault.SkinnedFolder  import SkinnedFolder
from Globals import PersistentMapping, InitializeClass

# list of field types to be used for a fulltext index

SEARCHABLE_FIELD_TYPES=[
    'StringField',
    'TextAreaField',
    'EmailField',
    'RawTextAreaField',
    'LinesField',
    'LinkField'
]


class TTWObject(PortalContent, DefaultDublinCoreImpl):
    """ a generic object for ttw creation """

    __implements__ = ( PortalContent.__implements__
		     , DefaultDublinCoreImpl.__implements__
		     )
    
    security=ClassSecurityInfo()

    meta_type="TTWObject"

    def __init__(self,id,portal_type,title=''):
	""" create a new type """
	DefaultDublinCoreImpl.__init__(self,title=title)
	
	self.portal_type=portal_type.id
	self.id=id
	self.title=title

	# get the field definition
	form=portal_type.form

	self._fieldnames=[]
	for field in form.get_fields():
	    self._fieldnames.append(field.id)


    def set(self, field, value):
	""" set a value """
	setattr(self,field,value)

    def get(self,field,default=None):
	""" get a field value """
	return getattr(self,field,default)

    def getFields(self):
	""" return the list formulator field objects """
	return self.getTypeInfo().getForm().get_fields()

    def fieldNames(self):
	""" return list of field names """
	fields=self.getFields()
	return map(lambda x: x.id, fields)

    def store(self,field,value):
	""" a frontend to set in order to catch FileUploads """
	from ZPublisher.HTTPRequest import FileUpload
	from OFS.Image import File, Image
	from imghdr import what

	# this should be configurable at some point
	# to choose which object to create
	if isinstance(value,FileUpload):
	    # test for image type
	    if what(value) in ('gif','jpeg','png'):
		# create an Image instance
		value=Image(field,field,value)
	    else:
		# create a File instance
		value=File(field,field,value)

	# now really store it
	self.set(field,value)

    def edit(self, **kwargs):
	""" update object data """
	keys=kwargs.keys()
	for field in self.fieldNames():
	    if field in keys:
		self.store(field,kwargs[field])
	
	# set Title
	if 'title' in keys:
	    self.title=kwargs['title']
	self.reindexObject()

    # make everything searchable
    def SearchableText(self):
	""" return an indexable text """
	index=[self.title_or_id()]
	for f in self.getFields():
	    if f.meta_type in SEARCHABLE_FIELD_TYPES:
		index.append(self.get(f.id))
	index=map(str, index)
	index=' '.join(index)
	return index

InitializeClass(TTWObject)

def manage_addTTWObject(self, id, portal_type, title=''):
    """ add a new TTW object """
    o=TTWObject(id,portal_type,title)
    self._setObject(id,o)
