###################################################################################################
# _blobfields.py
#
# $Id: _blobfields.py,v 1.10 2004/11/30 20:03:16 dnordmann Exp $
# $Name:  $
# $Author: dnordmann $
# $Revision: 1.10 $
#
# Implementation of classes MyFile, MyImage, etc. (see below).
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
###################################################################################################

# Imports.
from __future__ import nested_scopes
from OFS.Image import Image, File
from cStringIO import StringIO
import copy
# Product Imports.
import _fileutil
import _globals
import _mimetypes


# ----------------------------------------------------------------------------------------------
#  _blobfields.hex2bin:
# ----------------------------------------------------------------------------------------------
def hex2bin(m):
  return ''.join(map(lambda x: chr(16*int('0x%s'%m[x*2],0)+int('0x%s'%m[x*2+1],0)),range(len(m)/2)))


# ----------------------------------------------------------------------------------------------
#  _blobfields.bin2hex:
# ----------------------------------------------------------------------------------------------
def bin2hex(m):
  return ''.join(map(lambda x: hex(ord(x)/16)[-1]+hex(ord(x)%16)[-1],m))


# ----------------------------------------------------------------------------------------------
#  _blobfields.recurse_downloadRessources:
#
#  Download from ZODB to file-system during Export.
# ----------------------------------------------------------------------------------------------
def recurse_downloadRessources(self, base, folder='.', deep=True):
  ressources = []
  obj_attrs = self.getObjAttrs()
  # Attributes.
  for key in obj_attrs.keys():
    obj_attr = self.getObjAttr(key)
    datatype = obj_attr['datatype_key']
    if datatype in _globals.DT_BLOBS:
      for lang in self.getLangIds():
        try:
          if obj_attr['multilang']==1 or lang==self.getPrimaryLanguage():
            req = {'lang':lang,'preview':'preview'}
            obj_vers = self.getObjVersion(req)
            blob = self._getObjAttrValue(obj_attr,obj_vers,lang)
            if blob is not None: 
              filepath = self.absolute_url()[len(base.absolute_url())+1:]
              filename = blob.getFilename()
              filename = getLangFilename(self,filename,lang)
              filename = '%s/%s/%s'%(folder,filepath,filename)
              filename = _fileutil.getOSPath(filename)
              _fileutil.exportObj(blob,filename)
              ressources.append( { 'filepath':filename, 'content_type':blob.getContentType()})
        except:
          _globals.writeException(self,"[recurse_downloadRessources]: Can't export %s"%key)
  if self.meta_type == 'ZMSCustom':
    metaObjId = self.meta_id
    for metaObjAttrId in self.getMetaobjAttrIds( metaObjId):
      metaObjAttr = self.getMetaobjAttr( metaObjId, metaObjAttrId)
      if metaObjAttr['type'] == 'resource':
        try:
          blob = metaObjAttr['custom']
          filepath = self.absolute_url()[len(base.absolute_url())+1:]
          filename = blob.getFilename()
          filename = '%s/%s/%s'%(folder,filepath,filename)
          filename = _fileutil.getOSPath(filename)
          _fileutil.exportObj(blob,filename)
          ressources.append( { 'filepath':filename, 'content_type':blob.getContentType()})
        except:
          _globals.writeException( self, "[recurse_downloadRessources]: Can't export %s.%s"%(metaObjId,metaObjAttrId))
  # Process children.
  for child in self.getChildNodes():
    if deep or child.isPageElement():
      ressources.extend( recurse_downloadRessources( child, base, folder, deep))
  # Return list of ressources.
  return ressources


# ----------------------------------------------------------------------------------------------
#  _blobfields.recurse_uploadRessources:
#
#  Upload from file-system to ZODB during Import.
# ----------------------------------------------------------------------------------------------
def recurse_uploadRessources(self, folder='.'):
  message = ''
  obj_attrs = self.getObjAttrs()
  # Attributes.
  for key in obj_attrs.keys():
    obj_attr = self.getObjAttr(key)
    datatype = obj_attr['datatype_key']
    if datatype in _globals.DT_BLOBS:
      for lang in self.getLangIds():
        try:
          if obj_attr['multilang']==1 or lang==self.getPrimaryLanguage():
            req = {'lang':lang,'preview':'preview'}
            obj_vers = self.getObjVersion(req)
            blob = self._getObjAttrValue(obj_attr,obj_vers,lang)
            if blob is not None:
              filename = _fileutil.getOSPath('%s/%s'%(folder,blob.getFilename()))
              # Backup properties (otherwise manage_upload sets it).
              bk = {}
              for __xml_attr__ in blob.__xml_attrs__:
                bk[__xml_attr__] = getattr(blob,__xml_attr__,'')
              # Read file to ZODB.
              f = open(filename,'rb')
              uploadBlobField(self,blob,f.read(),blob.filename)
              f.close()
              # Restore properties.
              for __xml_attr__ in blob.__xml_attrs__:
                if bk.get(__xml_attr__,'') not in ['','text/x-unknown-content-type']:
                  setattr(blob,__xml_attr__,bk[__xml_attr__])
              blob.filename = _fileutil.extractFileName(filename)
              self.setObjProperty(key,blob,lang)
              self.onChangeObj(req,forced=1)
        except:
          _globals.writeException(self,"[recurse_uploadRessources]")
  # Process children.
  for child in self.getChildNodes():
    message = message + recurse_uploadRessources(child,folder)
  # Return message.
  return message


# --------------------------------------------------------------------------------------------------
#  _blobfields.createBlobField:
#
#  Create blob-field of desired object-type and initialize it with given file.
#
#  IN:	objtype	[DT_IMAGE|DT_FILE|'{{MyImage}}'|'{{MyFile}}'
#	file	[ZPublisher.HTTPRequest.FileUpload|dictionary]
#  OUT:	blob	[MyImage|MyFile]
# --------------------------------------------------------------------------------------------------
def createBlobField(self, objtype, file=''):
  blob = None
  i = MyImage(id='',title='',file='')
  f = MyFile(id='',title='',file='')
  if objtype == _globals.DT_IMAGE or objtype == str(i):
    blob = i
  elif objtype == _globals.DT_FILE or objtype == str(f):
    blob = f
  if blob is not None:
    blob.mediadbfile = None
    if type(file) is type({}):
      uploadBlobField(self,blob,StringIO(file.get('data','')),file.get('filename',''))
      if file.has_key('content_type'): blob.content_type = file.get('content_type')
    elif file:
      uploadBlobField(self,blob,file,file.filename)
  return blob


# --------------------------------------------------------------------------------------------------
#  _blobfields.uploadBlobField
# --------------------------------------------------------------------------------------------------
def uploadBlobField(self, blob, data, filename):
  if data:
    filename = _fileutil.extractFileName(filename)
    blob.filename = filename
    blob.uploadData(self, data)
    if self is not None:
      mediadb = self.getMediaDb()
      if mediadb is not None:
	blob.aq_parent = self
        blob.mediadbfile = mediadb.storeFile(blob)
        blob.data = ''


# --------------------------------------------------------------------------------------------------
#  _blobfields.getLangFilename:
#  
#  Returns filename concatenated with language suffix.
# --------------------------------------------------------------------------------------------------
def getLangFilename(self, filename, lang):
  i = filename.rfind('.')
  name = filename[:i]
  name = name.replace(' ','_')
  ext = filename[i+1:]
  if len(self.getLangIds()) > 1 and lang is not None:
    suffix = '_' + lang
    if len(name) < len(suffix) or name[-len(suffix):] != suffix:
      name += suffix
  name += '.' + ext
  return name


"""
###################################################################################################
###
###   T H U M B N A I L S
###
###################################################################################################
"""

# --------------------------------------------------------------------------------------------------
#  _blobfields.thumbnailImageFields:
#
#  Process image-fields and shrink superres to hires and hires to lores. 
# --------------------------------------------------------------------------------------------------
def thumbnailImageFields(self, lang, manage_lang,REQUEST):
  message = ""
  if self.getConfProperty('InstalledProducts.pil',0) == 1 and \
     self.getConfProperty('InstalledProducts.pil.thumbnail',0) == 1:
    obj_attrs = self.getObjAttrs()
    for key in obj_attrs.keys():
      obj_attr = self.getObjAttr(key)
      datatype = obj_attr['datatype_key']
      if datatype == _globals.DT_IMAGE:
        message += thumbnailImage(self,'%ssuperres'%key,'%shires'%key,self.getConfProperty('InstalledProducts.pil.hires.thumbnail.max',600),lang,manage_lang,REQUEST)
        message += thumbnailImage(self,'%shires'%key,'%s'%key,self.getConfProperty('InstalledProducts.pil.thumbnail.max',100),lang,manage_lang,REQUEST)
  return message


# --------------------------------------------------------------------------------------------------
#  _blobfields.thumbnailImage:
#
#  Process image-field and shrink attribute given by hiresKey to attribute given by loresKey. 
# --------------------------------------------------------------------------------------------------
def thumbnailImage(self, hiresKey, loresKey, maxdim, lang, manage_lang, REQUEST):
  message = ""
  try:
    if hiresKey in self.getObjAttrs().keys():
      hiresImg = self.getObjProperty(hiresKey,REQUEST)
      if hiresImg is not None and REQUEST.get('generate_preview_%s_%s'%(hiresKey,lang),0) == 1:
        if _globals.debug( self): 
          _globals.writeLog( self, "[manage_changeProperties]: Create >%s< from >%s<..."%(loresKey,hiresKey))
        loresImg = _fileutil.createThumbnail(hiresImg,maxdim)
        self.setObjProperty(loresKey,loresImg,lang)
  except:
    pass
  return message


###################################################################################################
###################################################################################################

class MyBlob:

    # Documentation string.
    __doc__ = """ZMS product module."""
    # Version string. 
    __version__ = '0.1' 
    

    # ---------------------------------------------------------------------------------------------
    #  MyBlob.__call__: 
    # ---------------------------------------------------------------------------------------------
    def __bobo_traverse__(self, TraversalRequest, name):
      return self

    __call____roles__ = None
    def __call__(self, REQUEST={}, **kw):
      """"""
      if REQUEST.has_key('path_to_handle'):
        REQUEST['path_to_handle']=[]
        filename = self.getFilename()
        content_type = getattr(self,'content_type','application/octet-stream')
        REQUEST.RESPONSE.setHeader('Content-Type',content_type)
        REQUEST.RESPONSE.setHeader('Content-Disposition','inline;filename=%s'%filename)
        return self.getData()
      return self

    index_html=None

    
    # ---------------------------------------------------------------------------------------------
    #  MyBlob.getObjAttrs:
    # ---------------------------------------------------------------------------------------------
    getObjAttrs__roles__ = None
    def getObjAttrs(self, meta_type=None):
      return {}


    # ---------------------------------------------------------------------------------------------
    #  MyBlob.getData:
    # ---------------------------------------------------------------------------------------------
    getData__roles__ = None
    def getData(self, parent=None):
      data = ''
      mediadbfile = self.getMediadbfile()
      if mediadbfile is not None:
        if parent is None:
          parent = self.aq_parent
        mediadb = parent.getMediaDb()
        if mediadb is not None:
          try:
            data = mediadb.retrieveFile( mediadbfile)
          except:
            _globals.writeException( parent, "[getData]: can't retrieve file from mediadb: %s"%str(mediadbfile))
      else:
        data = str(getattr(self,'data',''))
      return data


    # ---------------------------------------------------------------------------------------------
    #  MyBlob.getHref:
    # ---------------------------------------------------------------------------------------------
    getHref__roles__ = None
    def getHref(self, REQUEST):
      parent = self.aq_parent
      key = self.key
      rownum = ''
      i = key.find( ':')
      if i > 0:
        rownum = '/@%s'%key[ i+1:]
      filename = getLangFilename( parent, self.getFilename(), self.lang)
      qs = ''
      if REQUEST.get('ZMS_VERSION',None) is not None:
        qs = _globals.qs_append(qs,'ZMS_VERSION',REQUEST['ZMS_VERSION'])
      elif _globals.isPreviewRequest(REQUEST):
        qs = _globals.qs_append(qs,'preview','preview')
      try:
        filename=parent.absolute_url()+rownum+'/'+filename
      except:
        filename=parent.id+rownum+'/'+filename
      return filename+qs


    # ---------------------------------------------------------------------------------------------
    #  MyBlob.getMediadbfile: 
    #
    #  Returns mediadb-filename.
    # ---------------------------------------------------------------------------------------------
    getMediadbfile__roles__ = None
    def getMediadbfile(self):
      return getattr(self,'mediadbfile',None)


    # ---------------------------------------------------------------------------------------------
    #  MyBlob.getFilename: 
    #
    #  Returns filename.
    # ---------------------------------------------------------------------------------------------
    getFilename__roles__ = None
    def getFilename(self):
      filename = self.filename
      filename = _globals.filename_quote(filename)
      if filename != self.filename: self.filename = filename
      return filename

    
    # ---------------------------------------------------------------------------------------------
    #  MyBlob.get_size: 
    #
    #  Returns file-size.
    # ---------------------------------------------------------------------------------------------
    get_size__roles__ = None
    def get_size(self):
      size = 0
      data = self.getData()
      if data is not None:
        size = len(data)
      return size

    
    # ---------------------------------------------------------------------------------------------
    # 	MyBlob.getDataSizeStr: 
    #
    #	Returns display string of file-size (KB).
    # ---------------------------------------------------------------------------------------------
    getDataSizeStr__roles__ = None
    def getDataSizeStr(self):
      return _fileutil.getDataSizeStr(self.get_size())


    # ---------------------------------------------------------------------------------------------
    # 	MyBlob.getContentType:
    #
    #	MIME-type.
    # ---------------------------------------------------------------------------------------------
    getContentType__roles__ = None
    def getContentType(self):
      return self.content_type


    # ---------------------------------------------------------------------------------------------
    # 	MyBlob.getMimeTypeIconSrc:
    #
    #	Image source for MIME-type.
    # ---------------------------------------------------------------------------------------------
    getMimeTypeIconSrc__roles__ = None
    def getMimeTypeIconSrc(self):
      content_type = self.getContentType()
      if not _mimetypes.dctMimeType.has_key(content_type):
        content_type = 'content/unknown'
      return 'misc_/zms/%s'%_mimetypes.dctMimeType[content_type]


    # ---------------------------------------------------------------------------------------------
    # 	MyBlob.xmlGetTagName: 
    #
    #	Returns <XML> Tag-Name.
    # ---------------------------------------------------------------------------------------------
    def xmlGetTagName(self):
      return 'data'


###################################################################################################
###################################################################################################

class MyImage(MyBlob,Image):

    # Documentation string.
    __doc__ = """ZMS product module."""
    # Version string. 
    __version__ = '0.1' 
    

    __obj_attrs__ = ['content_type','size','data','filename','mediadbfile','width','height']
    __xml_attrs__ = ['content_type','width','height']
    
    def __str__(self):
      return '{{MyImage}}'


    # ---------------------------------------------------------------------------------------------
    # 	MyImage.uploadData:
    # ---------------------------------------------------------------------------------------------
    def uploadData(self, parent, data):
      ob = Image(id='',title='',file='')
      ob.manage_upload(data)
      for key in ['size','width','height','content_type','data']:
        if hasattr(ob, key):
          setattr(self, key, getattr(ob,key) )
      # Check size.
      if parent is not None:
        maxlength = parent.getConfProperty('ZMS.input.image.maxlength','')
        if len(maxlength) > 0:
          size = self.get_size()
          if size > int(maxlength):          
            raise 'Exception','size=%i > ZMS.input.image.maxlength=%i' %(size,int(maxlength))


    # ---------------------------------------------------------------------------------------------
    # 	MyImage._getCopy:
    # ---------------------------------------------------------------------------------------------
    def _getCopy(self):
      self.getFilename() # Normalize filename
      ob = self
      clone = MyImage(id='',title='',file='')
      attrs = self.__obj_attrs__
      for attr in attrs:
        if hasattr(ob,attr):
          setattr(clone,attr,getattr(ob,attr))
      return clone


    # ---------------------------------------------------------------------------------------------
    # 	MyImage.toXml:
    # ---------------------------------------------------------------------------------------------
    def toXml(self, sender=None, base=None, base_path=''):
      data = ''
      objtype = ''
      filename = _fileutil.getOSPath(_fileutil.extractFileName(getattr(self,'filename','')))
      if base is None:
        if getattr(self,'content_type','').find('text/') == 0:
          data = '<![CDATA[%s]]>'%str(self.getData( sender))
        else:
          data = bin2hex(self.getData( sender))
        objtype = ' type="image"'
      else:
        filepath = sender.absolute_url()[len(base.absolute_url())+1:]
        filename = self.getFilename()
        filename = getLangFilename(sender,filename,self.lang)
        filename = '%s/%s'%(filepath,filename)
      xml = '\n<%s'%self.xmlGetTagName()
      xml += ' width="%s"'%str(getattr(self,'width',''))
      xml += ' height="%s"'%str(getattr(self,'height',''))
      xml += ' content_type="%s"'%str(getattr(self,'content_type',''))
      xml += ' filename="%s%s"'%(base_path,filename)
      xml += objtype + '>' + data
      xml += '</%s>'%self.xmlGetTagName()
      return xml


    # ---------------------------------------------------------------------------------------------
    # 	MyImage.getWidth:
    # ---------------------------------------------------------------------------------------------
    getWidth__roles__ = None
    def getWidth(self):
      return self.width


    # ---------------------------------------------------------------------------------------------
    # 	MyImage.getHeight:
    # ---------------------------------------------------------------------------------------------
    getHeight__roles__ = None
    def getHeight(self):
      return self.height


###################################################################################################
###################################################################################################

class MyFile(MyBlob,File):

    # Documentation string.
    __doc__ = """ZMS product module."""
    # Version string. 
    __version__ = '0.1' 
    

    __obj_attrs__ = ['content_type','size','data','filename','mediadbfile']
    __xml_attrs__ = ['content_type']

    def __str__(self):
      return '{{MyFile}}'


    # ---------------------------------------------------------------------------------------------
    # 	MyFile.uploadData:
    # ---------------------------------------------------------------------------------------------
    def uploadData(self, parent, data):
      ob = File(id='',title='',file=data)
      for key in ['size','content_type','data']:
        if hasattr(ob,key):
          setattr(self,key,getattr(ob,key))
      # Check size.
      if parent is not None:
        maxlength = parent.getConfProperty('ZMS.input.file.maxlength','')
        if len(maxlength) > 0:
          size = self.get_size()
          if size > int(maxlength):          
            raise 'Exception','size=%i > ZMS.input.file.maxlength=%i' %(size,int(maxlength))


    # ---------------------------------------------------------------------------------------------
    # 	MyFile._getCopy:
    # ---------------------------------------------------------------------------------------------
    def _getCopy(self):
      self.getFilename() # Normalize filename
      ob = self
      clone = MyFile(id='',title='',file='')
      attrs = self.__obj_attrs__
      for attr in attrs:
        if hasattr(ob,attr):
          setattr(clone,attr,getattr(ob,attr))
      return clone


    # ---------------------------------------------------------------------------------------------
    # 	MyFile.toXml:
    # ---------------------------------------------------------------------------------------------
    def toXml(self, sender=None, base=None, base_path=''):
      data = ''
      objtype = ''
      filename = _fileutil.getOSPath(_fileutil.extractFileName(getattr(self,'filename','')))
      if base is None:
        if getattr(self,'content_type','').find('text/') == 0:
          data = '<![CDATA[%s]]>'%str(self.getData( sender))
        else:
          data = bin2hex(self.getData( sender))
        objtype = ' type="file"'
      else:
        filepath = sender.absolute_url()[len(base.absolute_url())+1:]
        filename = self.getFilename()
        filename = getLangFilename(sender,filename,self.lang)
        filename = '%s/%s'%(filepath,filename)
      xml = '\n<%s'%self.xmlGetTagName()
      xml += ' content_type="%s"'%str(getattr(self,'content_type',''))
      xml += ' filename="%s%s"'%(base_path,filename)
      xml += objtype + '>' + data
      xml += '</%s>'%self.xmlGetTagName()
      return xml

###################################################################################################
