###################################################################################################
# _cachemanager.py
#
# $Id: _cachemanager.py,v 1.7 2004/11/24 21:02:52 dnordmann Exp $
# $Name:  $
# $Author: dnordmann $
# $Revision: 1.7 $
#
# Implementation of class CacheManager (see below).
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
###################################################################################################

# Imports.
from Globals import HTMLFile
import time
import urllib
# Product Imports.
import _globals 


dct_op = {'index':'','sitemap':'sitemap','index_print':'print'}


###################################################################################################
#
#   S T A T I C   C A C H E
#
###################################################################################################

# ------------------------------------------------------------------------------------------
# _getIdFromUrl
# ------------------------------------------------------------------------------------------
def _getIdFromUrl(REQUEST):
  id = REQUEST['URL']
  id = id[:-5]
  id = id[id.rfind('/')+1:]
  if id.find('_') < 0 and REQUEST.has_key('lang'):
    id = '%s_%s'%(id,REQUEST['lang'])
  return _getCacheId(id)


# ------------------------------------------------------------------------------------------
# _getCacheId
# ------------------------------------------------------------------------------------------
def _getCacheId(id):
  return 'cache_' + id + '_html'


# ------------------------------------------------------------------------------------------
# clearCachePage
# ------------------------------------------------------------------------------------------
def _clearCachePage(self, id):
  if not self.isPage():
    return _clearCachePage(self.getParentNode(),id)
  if id in self.objectIds():
    if _globals.debug( self): 
      _globals.writeLog( self, "[_clearCachePage]: Removing ID=%s"%id)
    self.manage_delObjects(ids=[id])


# ------------------------------------------------------------------------------------------
# refresh
# ------------------------------------------------------------------------------------------
def _refreshCachePage(self, id, REQUEST):
  if not self.isPage():
    return _refreshCachePage(self.getParentNode(),id,REQUEST)
  _clearCachePage(self,id)
  if _globals.debug( self): 
    _globals.writeLog( self, "[_refreshCachePage]: Generating ID=%s"%id)
  REQUEST.set('__cache__',1)
  title = '*** CACHE ***'
  raw = self.index_html(self,REQUEST)
  self.manage_addDTMLMethod(id,title,raw)
  self.setConfProperty('ZMS.cache.empty',0)


###################################################################################################
#
#   R E Q U E S T   B U F F E R
#
###################################################################################################

# ------------------------------------------------------------------------------------------
# getReqBuffId:
#
# Gets buffer-id in Http-Request.
#
# @throws Exception
# ------------------------------------------------------------------------------------------
def getReqBuffId(self, key, REQUEST):
  id = str(self)
  id = id[id.rfind(' ')+1:-1]
  id = '%s_%s'%(id,key)
  parent = self.getParentNode()
  if parent is not None:
    id = '%s_%s'%( parent.id, id)
  lang = REQUEST.get( 'lang', None)
  if lang is not None:
    id = '%s_%s'%( id, lang)
  return id


# ------------------------------------------------------------------------------------------
# getReqBuff:
#
# Gets buffer from Http-Request.
#
# @throws Exception
# ------------------------------------------------------------------------------------------
def getReqBuff(self, REQUEST):
  buff = REQUEST.get('__buff__',None)
  if buff == None:
    buff = _globals.MyClass()
  return buff


###################################################################################################
#
# ReqBuff
#
###################################################################################################
class ReqBuff:

    # ------------------------------------------------------------------------------------------
    # fetchReqBuff:
    #
    # Fetch buffered value from Http-Request.
    #
    # @throws Exception
    # ------------------------------------------------------------------------------------------
    def fetchReqBuff(self, key, REQUEST):
      if REQUEST.get('URL','/manage').find('/manage') < 0:
        buff = getReqBuff(self,REQUEST)
        reqBuffId = getReqBuffId(self,key,REQUEST)
        try:
          value = getattr(buff,reqBuffId)
          return value
        except:
          raise '%s not found in ReqBuff!'%reqBuffId
      raise 'ReqBuff is inactive!'
    
    # ------------------------------------------------------------------------------------------
    # storeReqBuff:
    #
    # Returns value and stores it in buffer of Http-Request.
    # ------------------------------------------------------------------------------------------
    def storeReqBuff(self, key, value, REQUEST):
      try:
        if REQUEST.get('URL','/manage').find('/manage') < 0:
          buff = getReqBuff(self,REQUEST)
          reqBuffId = getReqBuffId(self,key,REQUEST)
          setattr(buff,reqBuffId,value)
          REQUEST.set('__buff__',buff)
      except:
        pass
      return value
    
    # ------------------------------------------------------------------------------------------
    # clearReqBuff:
    #
    # Clears key from buffer of Http-Request.
    # ------------------------------------------------------------------------------------------
    def clearReqBuff(self, key, REQUEST):
      try:
        if REQUEST.get('URL','/manage').find('/manage') < 0:
          buff = getReqBuff(self,REQUEST)
          reqBuffId = getReqBuffId(self,key,REQUEST)
          delattr(buff,reqBuffId)
          REQUEST.set('__buff__',buff)
      except:
        pass
    
    
###################################################################################################
###################################################################################################
###
###   C l a s s   C a c h e a b l e O b j e c t :
###
###################################################################################################
###################################################################################################
class CacheableObject(ReqBuff):

    # ------------------------------------------------------------------------------------------
    # CacheableObject.clearCachePage: 
    # ------------------------------------------------------------------------------------------
    def clearCachePage(self):
      for s_lang in self.getLangIds():
        for s_op in dct_op.keys():
          id = _getCacheId('%s_%s'%(s_op,s_lang))
          _clearCachePage(self,id)


    # ------------------------------------------------------------------------------------------
    # CacheableObject.clearCache: 
    # ------------------------------------------------------------------------------------------
    def clearCache(self):
      if self.isPage() and self.meta_type != 'ZMSSysFolder':
        self.clearCachePage()
        for ob in self.objectValues(self.dGlobalAttrs.keys()):
          ob.clearCache()
        self.clearFragmentedCache()
        self.setConfProperty('ZMS.cache.cleared.time',time.time())
        self.setConfProperty('ZMS.cache.empty',1)


    # ------------------------------------------------------------------------------------------
    # CacheableObject.synchronizeCachePage: 
    # ------------------------------------------------------------------------------------------
    def synchronizeCachePage(self, REQUEST):
    
      # PAGES.
      # ------
      if self.getConfProperty('ZMS.cache.active')==1:
        s_lang = REQUEST.get('lang',self.getPrimaryLanguage())
        if self.isPageElement():
          _clearCachePage(self,_getCacheId('index_%s'%s_lang))
          _clearCachePage(self,_getCacheId('index_print_%s'%s_lang))
        elif self.isPage():
          self.synchronizeCache()
        elif self.isMetaType(['ZMSTeaserContainer','ZMSTeaserElement'],REQUEST):
          self.getParentNode().synchronizeCachePage(REQUEST)
          
      # FRAGMENTS.
      # ----------
      self.synchronizeFragmentedCachePage(REQUEST)


    # ------------------------------------------------------------------------------------------
    # CacheableObject.isCachedPage:
    # ------------------------------------------------------------------------------------------
    def isCachedPage(self, REQUEST):
      if not self.isPage():
        return self.getParentNode().isCachedPage(REQUEST)
      id = _getIdFromUrl(REQUEST)
      found = False
      for s_lang in self.getLangIds():
        for s_op in dct_op.keys():
          if id == _getCacheId('%s_%s'%(s_op,s_lang)):
            found = True
      root = self.getHome()
      rtn = True
      rtn = rtn and found
      rtn = rtn and (not 'attr_cacheable' in self.getObjAttrs().keys() or str(self.getObjProperty('attr_cacheable',REQUEST))=='1')
      rtn = rtn and self.getConfProperty('ZMS.cache.active')==1
      rtn = rtn and not _globals.isPreviewRequest(REQUEST)
      rtn = rtn and not _globals.isCacheRequest(REQUEST)
      rtn = rtn and not REQUEST['AUTHENTICATED_USER'].has_role('Authenticated')
      try: rtn = rtn and not len(REQUEST.form.keys()) > 0
      except: pass
      return rtn


    # ------------------------------------------------------------------------------------------
    # CacheableObject.getCachedPage:
    # ------------------------------------------------------------------------------------------
    def getCachedPage(self, REQUEST):
      if not self.isPage():
        return self.getParentNode().getCachedPage(REQUEST)
      id = _getIdFromUrl(REQUEST)
      # Clear cache at least daily.
      t0 = self.getConfProperty('ZMS.cache.cleared.time',time.time())
      t1 = time.time()
      if _globals.compareDate(t0,t1,accuracy_time=0)==1:
        self.clearCache()
      # Refresh cache.
      if not id in self.objectIds(['DTML Method']):
        _refreshCachePage(self,id,REQUEST)
      # Return cache.
      for ob in self.objectValues(['DTML Method']):
        if ob.id() == id:
	  return ob.raw


    """
    ############################################################################################
    ###
    ###  F R A G M E N T E D   C A C H E
    ###
    ############################################################################################
    """

    # ------------------------------------------------------------------------------------------
    #  CacheableObject.initFragmentedCachePage:
    # ------------------------------------------------------------------------------------------
    def initFragmentedCachePage(self, id, langs):
      if _globals.debug( self):
        _globals.writeLog( self, "[initFragmentedCachePage]")
      if not id in self.objectIds():
        data = []
        data.append('<!-- BO %s::%s -->\n'%(self.id,id))
        el = ''
        for lang in langs:
          content = '<dtml-return "_.None">'
          data.append('<dtml-%sif "REQUEST[\'lang\']==\'%s\'">%s'%(el,lang,content))
          el = 'el'
        data.append('</dtml-if>\n')
        data.append('<!-- EO %s::%s -->\n'%(self.id,id))
        data = "".join(data)
        self.manage_addDTMLMethod(id,'*** ZMS fragmented cache ***',data)


    # ------------------------------------------------------------------------------------------
    #  CacheableObject.setFragmentedCachePage:
    # ------------------------------------------------------------------------------------------
    def setFragmentedCachePage(self, id, langs, reset, REQUEST):
      if _globals.debug( self):
        _globals.writeLog( self, "[setFragmentedCachePage]: id=%s"%id)
      dtmlMthd = getattr(self,id)
      if dtmlMthd.title_or_id()=='*** ZMS fragmented cache ***':
        content = dtmlMthd(self,REQUEST)
        if (reset==0 and content is None) or \
           (reset==1 and content is not None):
          #++ print "[]: Refresh element in language <<%s>>."%REQUEST['lang']
          data = []
          data.append('<!-- BO %s::%s -->\n'%(self.id,id))
          el = ''
          for lang in langs:
            if lang == REQUEST['lang']:
              if reset:
                content = None
              else:
                content = getattr(self.getHome(),id)(self,REQUEST={'lang':lang,'ZMS_COMMON':REQUEST['ZMS_COMMON']})
            else:
              content = dtmlMthd(self,REQUEST={'lang':lang})
            if content is None:
              content = '<dtml-return "_.None">'
            data.append('<dtml-%sif "lang==\'%s\'">%s'%(el,lang,content))
            el = 'el'
          data.append('</dtml-if>\n')
          data.append('<!-- EO %s::%s -->\n'%(self.id,id))
          data = "".join(data)
          dtmlMthd.manage_edit(data,'*** ZMS fragmented cache ***')


    # ------------------------------------------------------------------------------------------
    #  CacheableObject.getFragCacheConf:
    # ------------------------------------------------------------------------------------------
    def getFragCacheConf(self):
      rtn = []
      for ob in self.breadcrumbs_obj_path():
        if 'cache.conf' in ob.objectIds(['DTML Method']):
          conf = getattr(ob,'cache.conf')(self)
          for i in range(len(conf)/2):
            id = conf[i*2]
            dict = conf[i*2+1]
            dict['root'] = ob
            if dict.get('inherit',0)==1:
              dict['node'] = ob
            else: 
              dict['node'] = self
            rtn.extend([id,dict])
      return rtn


    # ------------------------------------------------------------------------------------------
    #  CacheableObject.clearFragmentedCache:
    # ------------------------------------------------------------------------------------------
    def clearFragmentedCache(self):
      if _globals.debug( self):
        _globals.writeLog( self, "[clearFragmentedCache]")
      ids = []
      for ob in self.objectValues(['DTML Method']):
        if ob.title_or_id()=='*** ZMS fragmented cache ***':
          ids.append(ob.id())
      self.manage_delObjects(ids=ids)


    # ------------------------------------------------------------------------------------------
    #  CacheableObject.synchronizeFragmentedCachePage:
    # ------------------------------------------------------------------------------------------
    def synchronizeFragmentedCachePage(self, REQUEST):
      if self.getConfProperty('ZMS.cache.frag.active')!=1: return
      if _globals.debug( self):
        _globals.writeLog( self, "[synchronizeFragmentedCachePage]")
      conf = self.getFragCacheConf()
      for i in range(len(conf)/2):
        id = conf[i*2]  
        dict = conf[i*2+1]
        if dict.has_key('meta_types') and self.isMetaType(dict['meta_types']):
          langs = self.getLangIds()
          if dict.get('inherit',0)==1:
            nodes = [dict['node']]
          else:
            nodes = []
            node = self
            for i in range(self.getLevel()-dict['root'].getLevel()+1):
              nodes.append(node)
              node = node.getParentNode()
          for node in nodes:
            #++ print '[]: Element <<%s>> at <<%s>>...'%(id,node.id)
            #-- Init element.
            node.initFragmentedCachePage(id,langs)
            #-- Reset element in current language.
            node.setFragmentedCachePage(id,langs,dict.get('reset',1),REQUEST)


    # ------------------------------------------------------------------------------------------
    #  CacheableObject.fragmentedCachedPage:
    #
    #  Refresh elements of fragemented cache.
    # ------------------------------------------------------------------------------------------
    def fragmentedCachedPage(self, REQUEST):
      if self.getConfProperty('ZMS.cache.frag.active')!=1: return
      if _globals.debug( self):
        _globals.writeLog( self, "[fragmentedCachedPage]")
      conf = self.getFragCacheConf()
      for i in range(len(conf)/2):
        id = conf[i*2]  
        dict = conf[i*2+1]
        langs = self.getLangIds()
        nodes = [dict['node']]
        for node in nodes:
          #++ print '[]: Element <<%s>> at <<%s>>...'%(id,node.id)
          #-- Init element.
          node.initFragmentedCachePage(id,langs)
          #-- Refresh element in current language.
          node.setFragmentedCachePage(id,langs,0,REQUEST)


###################################################################################################
###################################################################################################
###
###   C l a s s   C a c h e M a n a g e r :
###
###################################################################################################
###################################################################################################
class CacheManager(CacheableObject): 

    # Management Permissions.
    # -----------------------
    __administratorPermissions__ = (
                'manage_changeCacheProperties',
                )
    __ac_permissions__=(
                ('ZMS Administrator', __administratorPermissions__),
                )


    # ------------------------------------------------------------------------------------------
    # CacheManager.synchronizeCache: 
    #	IN:   forced_update	0= not forced (update once a day), 
    #				1= forced (call from management-interface).
    # ------------------------------------------------------------------------------------------
    def synchronizeCache(self, forced_update=0):
      if self.getConfProperty('ZMS.cache.empty',0)==0 or forced_update:
        self.clearCache()


    ###############################################################################################
    #  CacheManager.manage_changeCacheProperties:
    #
    #  Change cache properties.
    ###############################################################################################
    def manage_changeCacheProperties(self, btn, lang, manage_lang, REQUEST): 
      """ CacheManager.manage_changeCacheProperties """

      cache_before0 = self.getConfProperty('ZMS.cache.active')
      cache_before1 = self.getConfProperty('ZMS.cache.frag.active')
        
      # Change.
      # -------
      self.setConfProperty('ZMS.cache.active',REQUEST.has_key('cache_active'))
      self.setConfProperty('ZMS.cache.frag.active',REQUEST.has_key('cache_frag_active'))
        
      # Clear.
      # ------
      cache_after0 = self.getConfProperty('ZMS.cache.active')
      cache_after1 = self.getConfProperty('ZMS.cache.frag.active')
      if (cache_before0 != cache_after0 and cache_before0) or \
         (cache_before1 != cache_after1 and cache_before1) or \
         (btn == 'Clear'):
        self.synchronizeCache(forced_update=1)
            
      # Return with message.
      message = urllib.quote(self.getLangStr('MSG_CHANGED',manage_lang))
      return REQUEST.RESPONSE.redirect('manage_customize?lang=%s&manage_lang=%s&manage_tabs_message=%s#_cache'%(lang,manage_lang,message))

###################################################################################################
