###################################################################################################
# zms.py
#
# $Id: zms.py,v 1.13 2004/03/24 18:05:13 dnordmann Exp $
# $Name:  $
# $Author: dnordmann $
# $Revision: 1.13 $
#
# Implementation of class ZMS (see below).
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
###################################################################################################

# Imports.
from __future__ import nested_scopes
from Globals import HTMLFile
from AccessControl.User import UserFolder
from App.Common import package_home
from OFS.Image import Image
from sys import *
import copy
import string 
import time
import urllib
# Product imports.
import _accessmanager
import _builder
import _cachemanager
import _confmanager
import _enummanager
import _fileutil
import _ftpmanager
import _globals
import _importable
import _language
import _multilangmanager
import _objattrs
import _textformatmanager
import _xmllib
import _zcatalogmanager
import zmscontainerobject
from zmscustom import ZMSCustom
from zmsdocument import ZMSDocument
from zmsfile import ZMSFile
from zmsgraphic import ZMSGraphic
from zmslinkcontainer import ZMSLinkContainer
from zmslinkelement import ZMSLinkElement
from zmsnote import ZMSNote
from zmsrubrik import ZMSRubrik
from zmssqldb import ZMSSqlDb
from zmssysfolder import ZMSSysFolder
from zmstable import ZMSTable
from zmsteasercontainer import ZMSTeaserContainer
from zmsteaserelement import ZMSTeaserElement
from zmstextarea import ZMSTextarea
from zmstrashcan import ZMSTrashcan


###################################################################################################
###################################################################################################
###   
###   C o m m o n   F u n c t i o n ( s )
###   
###################################################################################################
###################################################################################################

# ---------------------------------------------------------------------------------------------
#  initTheme:
# ---------------------------------------------------------------------------------------------
def initTheme(self, theme, folder_id, REQUEST):

  ### Import theme from ZEXP.
  theme_zexp = theme + '.zexp'
  _fileutil.importZexp(self,package_home(globals())+'/import/',theme_zexp)

  ### Assign folder-id.
  if folder_id != theme: self.manage_renameObject(theme,folder_id)

  ### Return new ZMS home instance.
  return getattr(self,folder_id)


# ---------------------------------------------------------------------------------------------
#  initZMS:
# ---------------------------------------------------------------------------------------------
def initZMS(self, titleshort, title, lang, manage_lang, REQUEST):
  
  ### Constructor.
  id = 'content'
  obj = ZMS(id)
  self._setObject(obj.id, obj)
  obj = getattr(self,obj.id)
  
  ### Init Configuration.
  obj.setConfProperty('ZMS.autocommit',1)
  obj.setConfProperty('ZMS.Version.active',0)
  obj.setConfProperty('ZMS.Version.autopack',2)
  obj.setConfProperty('ZMSAdministrator.email',REQUEST.get('manager_email',''))
  obj.setConfProperty('ASP.ip_or_domain',REQUEST.get('asp_ip_or_domain',''))
  obj.setConfProperty('ZMSSqlDb.enabled',0)
  obj.setConfProperty('ZMSSysFolder.enabled',0)
  
  ### Init zcatalog.
  obj.recreateCatalog()
  
  ### Init languages.
  obj.setPrimaryLanguage(lang)
  obj.__set_lang__(lang,REQUEST['lang_label'],'',manage_lang)
  
  ### Init configuration.
  _confmanager.initConf(obj, 'default_'+manage_lang, REQUEST)
  
  ### Init text-formats.
  xml = open(package_home(globals())+'/import/textfmt.xml')
  _textformatmanager.importXml(obj,xml=xml)
  xml.close()
  
  ### Init Object-Attributes.
  obj.synchronizeObjAttrs()
  
  ### Init Role-Definitions and Permission Settings.
  obj.initRoleDefs()
  
  ### Init Properties: active, titlealt, title.
  obj.setObjStateNew(REQUEST)
  obj.updateVersion(lang,manage_lang,REQUEST)
  obj.setObjProperty('active',1,lang)
  obj.setObjProperty('titleshort',titleshort,lang)
  obj.setObjProperty('title',title,lang)
  obj.onChangeObj(REQUEST,forced=1)
  
  ### Init CSS Stylesheets.
  root = self.common
  id = 'defaultCSS'
  css = getattr( root, id)
  root.manage_delObjects(ids=[id])
  obj.getStylesheet(css.raw)
  for id in root.objectIds(['DTML Method']):
    if id[-3:] == 'CSS':
      cb_copy_data = root.manage_cutObjects(ids=[id])
      obj.manage_pasteObjects(cb_copy_data)
      obj.manage_renameObject(id=id,new_id=id[:-3]+'.css')


  ### Init Access Manager.
  obj.manage_usersInit(btn=obj.getLangStr('BTN_INIT',manage_lang),lang=lang,manage_lang=manage_lang,REQUEST=REQUEST)

  ### Return new ZMS instance.
  return obj


# ---------------------------------------------------------------------------------------------
#  initContent:
# ---------------------------------------------------------------------------------------------
def initContent(self, filename, REQUEST):
  xmlfile = open(_fileutil.getOSPath(package_home(globals())+'/import/'+filename),'rb')
  _importable.importFile(self,xmlfile,REQUEST)
  xmlfile.close()


###################################################################################################
###################################################################################################
###   
###   constructor ZMS:
###   
###################################################################################################
###################################################################################################
manage_addZMSForm = HTMLFile('manage_addzmsform', globals()) 
def manage_addZMS(self, lang, manage_lang, REQUEST, RESPONSE):
  """ manage_addZMS """
  message = ''
  t0 = time.time()
  
  if REQUEST['btn'] == 'Add':
  
    ##### Add Theme ####
    homeElmnt = initTheme(self,REQUEST['theme'],REQUEST['folder_id'],REQUEST)
      
    #-- Zope Manager.
    if not homeElmnt.objectValues(['User Folder']):
      userFldr = UserFolder()
      homeElmnt._setObject(userFldr.id, userFldr)
    name = REQUEST.get('manager_name','')
    password = REQUEST.get('manager_password','')
    confirm = password
    roles = ['Manager']
    domains = []
    userFldr._addUser(name,password,confirm,roles,domains)
    
    ##### Add ZMS ####
    titlealt = 'ZMS home'
    title = 'ZMS - ZOPE-based contentmanagement system for science, technology and medicine'
    obj = initZMS(homeElmnt,titlealt,title,lang,manage_lang,REQUEST)
    
    ##### Default content ####
    if REQUEST.get('initialization',0)==1:
      initContent(obj,'content.default.zip',REQUEST)
      
    ##### E-Learning components ####
    if REQUEST.get('initialization',0)==2:
      # Create Home.
      lcmsHomeElmnt = initTheme(homeElmnt,'lcms','lcms',REQUEST)
      # Create LCMS.
      titlealt = 'LCMS'
      title = 'Learning Content Management System'
      lcms = initZMS(lcmsHomeElmnt,titlealt,title,lang,manage_lang,REQUEST)
      # Init language-dictionary.
      xml = open(package_home(globals())+'/import/lms.langdict.xml')
      _multilangmanager.importXml(obj,xml=xml)
      xml.close()
      # Init configuration.
      _confmanager.initConf(lcms, 'lcms', REQUEST)
      _confmanager.initConf(obj, 'lms', REQUEST)
      # Register Portal/Client.
      lcms.setConfProperty('Portal.Master',homeElmnt.id)
      obj.setConfProperty('Portal.Clients',[lcmsHomeElmnt.id])
      # Add manage_login.
      id = 'manage_login'
      title = 'Template_L0: Member login'
      raw = HTMLFile('import/lms.manage_login',globals())
      obj.manage_addDTMLMethod(id,title,raw)
      mthd = getattr(obj,id)
      mthd.manage_role(role_to_manage='Authenticated',permissions=['View'])
      mthd.manage_acquiredPermissions([])
      # Add manage_register.
      id = 'manage_register'
      title = 'Template_L0: Member registration'
      raw = HTMLFile('import/lms.manage_register',globals())
      homeElmnt.manage_addDTMLMethod(id,title,raw)
      mthd = getattr(homeElmnt,id)
      mthd.manage_proxy(roles=['Manager'])
      # Modify standard_html_request.
      mthd = getattr(homeElmnt,'standard_html_request')
      data_footer = '<!-- EO standard_html_request -->'
      data = mthd.raw
      data = data[:data.find(data_footer)]
      data += ' <!-- ZMS eLearning components -->\n'
      data += ' <dtml-call "REQUEST.set(\'thisObj\',this())">\n'
      data += ' <dtml-call "REQUEST.set(\'member\',_.None)">\n'
      data += ' <dtml-in "e200000.filteredChildNodes(REQUEST,\'personalProfile\')">\n'
      data += '  <dtml-if "getObjProperty(\'profileEmail\',REQUEST)==_.str(AUTHENTICATED_USER)">\n'
      data += '   <dtml-call "REQUEST.set(\'member\',_[\'sequence-item\'])">\n'
      data += '  </dtml-if>\n'
      data += ' </dtml-in>\n\n'
      data += data_footer
      mthd.manage_edit(title=mthd.title,data=data)
      # Init content.
      initContent(lcms,'lcms.default.zip',REQUEST)
      initContent(obj,'lms.default.zip',REQUEST)
    
    ##### Configuration ####
    
    #-- Example Database
    if REQUEST.get('specobj_exampledb',0) == 1:
      # Init configuration.
      _confmanager.initConf(obj, 'exampledb', REQUEST)
      # Init content.
      initContent(obj,'exampledb.content.xml',REQUEST)
    
    #-- Bulletin Board
    if REQUEST.get('specobj_discussions',0) == 1:
      # Init configuration.
      _confmanager.initConf(obj, 'discussions', REQUEST)
      # Init content.
      initContent(obj,'discussions.content.xml',REQUEST)
    
    #-- Newsletter
    if REQUEST.get('specobj_newsletter',0) == 1:
      # Init configuration.
      _confmanager.initConf(obj, 'newsletter', REQUEST)
    
    #-- Calendar
    if REQUEST.get('specobj_calendar',0) == 1:
      # Init configuration.
      _confmanager.initConf(obj, 'calendar', REQUEST)
    
    # Return with message.
    message = obj.getLangStr('MSG_INSERTED',manage_lang)%obj.meta_type
    message += ' (in '+str(int((time.time()-t0)*100.0)/100.0)+' secs.)'
    RESPONSE.redirect('%s/%s/manage?manage_tabs_message=%s'%(homeElmnt.absolute_url(),obj.id,urllib.quote(message)))
  
  else:
    RESPONSE.redirect('%s/manage_main'%self.absolute_url())


###################################################################################################
###################################################################################################
###   
###   class ZMS:
###   
###################################################################################################
###################################################################################################
class ZMS(
	zmscontainerobject.ZMSContainerObject,
	_accessmanager.AccessManager,
	_builder.Builder,
	_cachemanager.CacheManager,
        _confmanager.ConfManager,
	_ftpmanager.FtpManager,
	_language.Language,
	_objattrs.ObjAttrsManager,
	_zcatalogmanager.ZCatalogManager,
	):

    # Version-Info.
    # -------------
    zms_version = '2.3.2-b57'	# Display purposes only!
    zms_build = '122'		# Internal use only, designates object model!
    zms_patch = 'b'		# Internal use only!

    # Properties.
    # -----------
    meta_type = 'ZMS'
    icon = "misc_/zms/zms.gif"
    icon_disabled = 'misc_/zms/zms_disabled.gif'

    # Management Options.
    # -------------------
    manage_options = (
	{'label': 'TAB_EDIT',         'action': 'manage_main'},
	{'label': 'TAB_PROPERTIES',   'action': 'manage_properties'},
	{'label': 'TAB_ACCESS',       'action': 'manage_users'},
	{'label': 'TAB_IMPORTEXPORT', 'action': 'manage_importexport'},
	{'label': 'TAB_TASKS',        'action': 'manage_tasks'},
	{'label': 'TAB_REFERENCES',   'action': 'manage_RefForm'},
	{'label': 'TAB_HISTORY',      'action': 'manage_UndoVersionForm'},
	{'label': 'TAB_CONFIGURATION','action': 'manage_customize'},
	{'label': 'TAB_PREVIEW',      'action': 'preview_html'}, # empty string defaults to index_html
	)

    # Management Permissions.
    # -----------------------
    __administratorPermissions__ = (
		'manage_importexportFtp',
		'manage_addZMSSysFolder',
		'manage_customize', 'manage_customizeSystem',
		'manage_changeLanguages', 'manage_customizeLanguagesForm',
		'manage_changeMetapattern', 'manage_customizeMetapatternForm',
		'manage_changeMetaobjs', 'manage_customizeMetaobjForm',
                'manage_changeMetadicts', 'manage_customizeMetadictForm',
		'manage_changeMetacmds', 'manage_customizeMetacmdForm',
                'manage_changeWorkflow', 'manage_changeWfTransitions', 'manage_changeWfActivities', 'manage_customizeWorkflowForm',
                'manage_customizeTextFormat', 'manage_customizeTextFormatForm',
		'manage_customizeDesign', 'manage_customizeDesignForm',
		)
    __authorPermissions__ = (
		'manage','manage_main','manage_workspace',
		'manage_wait',
		'manage_addZMSRubrik','manage_addZMSDocument','manage_addZMSTextarea','manage_addZMSGraphic','manage_addZMSTable','manage_addZMSFile','manage_addZMSTeaserContainer','manage_addZMSNote','manage_addZMSLinkContainer','manage_addZMSLinkElement','manage_addZMSSqlDb',
		'manage_deleteObjs','manage_moveObjUp','manage_moveObjDown','manage_cutObjects','manage_copyObjects','manage_pasteObjs',
		'manage_properties','manage_changeProperties',
		'manage_search','manage_tasks',
		'manage_wfTransition', 'manage_wfTransitionFinalize',
		'manage_userForm', 'manage_user',
		'manage_importexport', 'manage_import', 'manage_export',
		)
    __userAdministratorPermissions__ = (
		'manage_users', 'manage_usersSitemap', 'manage_userProperties', 'manage_roleProperties', 'manage_usersInit',
		)
    __ac_permissions__=(
		('ZMS Administrator', __administratorPermissions__),
		('ZMS Author', __authorPermissions__),
		('ZMS UserAdministrator', __userAdministratorPermissions__),
		)

    # Properties.
    # -----------
    __obj_attrs__ = {
        # Changed by
        'change_uid':{'datatype':'string','multilang':1,'lang_inherit':0},
        'change_dt':{'datatype':'datetime','multilang':1,'lang_inherit':0},
        # Versioned by
        'work_uid':{'datatype':'string','multilang':1,'lang_inherit':0},
        'work_dt':{'datatype':'datetime','multilang':1,'lang_inherit':0},
        # Properties
        'active':{'datatype':'boolean','multilang':1},
        'attr_active_start':{'datatype':'datetime','multilang':1},
        'attr_active_end':{'datatype':'datetime','multilang':1},
        'title':{'datatype':'string','multilang':1,'size':40},
        'titleshort':{'datatype':'string','multilang':1,'size':20},
        'titleimage':{'datatype':'image','multilang':1},
        'levelnfc':{'datatype':'string','type':'select','options':[0,0,1,1,2,2],'label':'ATTR_LEVELNFC'},
        'attr_cacheable':{'datatype':'boolean','default':1},
        # Meta-Dictionaries        
        '$metadict':{'datatype':'MetaDict'},
    }

    # Globals.
    # --------
    dGlobalAttrs = {
	'ZMS':{	 		'obj_class':None, 
				'constructor':None, 
				'obj_attrs':__obj_attrs__ },
	'ZMSCustom':{ 		'obj_class':ZMSCustom, 
				'constructor':None, 
				'obj_attrs':ZMSCustom.__obj_attrs__ },
	'ZMSDocument':{ 	'obj_class':ZMSDocument,
				'constructor':'manage_addzmsdocumentform',
				'obj_attrs':ZMSDocument.__obj_attrs__ },
	'ZMSFile':{ 		'obj_class':ZMSFile,
				'constructor':'manage_addzmsfileform',
				'obj_attrs':ZMSFile.__obj_attrs__ },
	'ZMSGraphic':{ 		'obj_class':ZMSGraphic,
				'constructor':'manage_addZMSGraphic',
				'obj_attrs':ZMSGraphic.__obj_attrs__ },
	'ZMSLinkContainer':{ 	'obj_class':ZMSLinkContainer,
				'constructor':'manage_addZMSLinkContainer',
				'obj_attrs':ZMSLinkContainer.__obj_attrs__ },
	'ZMSLinkElement':{ 	'obj_class':ZMSLinkElement,
				'constructor':'manage_addzmslinkelementform',
				'obj_attrs':ZMSLinkElement.__obj_attrs__ },
	'ZMSNote':{		'obj_class':ZMSNote,
				'constructor':'manage_addZMSNote',
				'obj_attrs':ZMSNote.__obj_attrs__ },
	'ZMSRubrik':{ 		'obj_class':ZMSRubrik,
				'constructor':'manage_addzmsrubrikform',
				'obj_attrs':ZMSRubrik.__obj_attrs__ },
	'ZMSSqlDb':{ 		'obj_class':ZMSSqlDb,
				'constructor':'manage_addzmssqldbform',
				'obj_attrs':ZMSSqlDb.__obj_attrs__ },
	'ZMSSysFolder':{	'obj_class':ZMSSysFolder,
				'constructor':'manage_addzmssysfolderform',
				'obj_attrs':ZMSSysFolder.__obj_attrs__ },
	'ZMSTable':{		'obj_class':ZMSTable,
				'constructor':'manage_addzmstableform',
				'obj_attrs':ZMSTable.__obj_attrs__ },
	'ZMSTeaserElement':{	'obj_class':ZMSTeaserElement,
				'constructor':'manage_addZMSTeaserElement',
				'obj_attrs':ZMSTeaserElement.__obj_attrs__ },
	'ZMSTeaserContainer':{	'obj_class':ZMSTeaserContainer,
				'constructor':'manage_addZMSTeaserContainer',
				'obj_attrs':ZMSTeaserContainer.__obj_attrs__ },
	'ZMSTextarea':{		'obj_class':ZMSTextarea,
				'constructor':'manage_addZMSTextarea',
				'obj_attrs':ZMSTextarea.__obj_attrs__ },
	'ZMSTrashcan':{		'obj_class':ZMSTrashcan,
				'constructor':None,
				'obj_attrs':ZMSTrashcan.__obj_attrs__ },
	}

    # Interface.
    # ----------
    index_html = HTMLFile('dtml/zms/index', globals()) # index_html
    f_inactive_html = HTMLFile('dtml/zms/f_inactive', globals()) # inactive_html
    f_headDoctype = HTMLFile('dtml/zms/f_headdoctype', globals()) # Template_L1: DOCTYPE
    f_bodyContent = HTMLFile('dtml/zms/f_bodycontent', globals()) # Template: Body-Content / Element
    f_bodyContent_Float = HTMLFile('dtml/zms/f_bodycontent_float', globals()) # Template: Body-Content
    f_bodyContent_Sitemap = HTMLFile('dtml/zms/f_bodycontent_sitemap', globals()) # Template: Sitemap
    f_bodyContent_Search = HTMLFile('dtml/zms/f_bodycontent_search', globals()) # Template: Search
    f_headTitle = HTMLFile('dtml/zms/f_headtitle', globals()) # Head.Title
    f_headMeta_DC = HTMLFile('dtml/zms/f_headmeta_dc', globals()) # Head.Meta.DC
    f_headMeta_Locale = HTMLFile('dtml/zms/f_headmeta_locale', globals()) # Head.Locale (Content-Type & Charset)
    f_sitemap = HTMLFile('dtml/zms/f_sitemap', globals()) # f_sitemap
    f_standard_html_request = HTMLFile('dtml/zms/f_standard_html_request', globals()) # f_standard_html_request
    f_standard_html_header = HTMLFile('dtml/zms/f_standard_html_header', globals()) # f_standard_html_header
    f_standard_html_footer = HTMLFile('dtml/zms/f_standard_html_footer', globals()) # f_standard_html_footer
    headScript = HTMLFile('dtml/zms/headscript', globals()) # Head.Script
    headMeta = HTMLFile('dtml/zms/headmeta', globals()) # Head.Meta
    headCStyleSheet = HTMLFile('dtml/zms/headcstylesheet', globals()) # Template_L1: CSS-Referenz
    headCSS = HTMLFile('dtml/zms/headcstylesheet', globals()) # Template_L1: CSS-Referenz
    search_nav_html = HTMLFile('dtml/zms/search_nav', globals()) # search_nav_html
    
    # Enumerations.
    # -------------
    browse_enum = HTMLFile('dtml/zms/browse_enum', globals()) 
    enumManager = _enummanager.EnumManager()


    ###############################################################################################    
    #
    #   CONSTRUCTOR
    #
    ###############################################################################################    

    # ------------------------------------------------------------------------------------------
    #  ZMS.__init__: 
    # ------------------------------------------------------------------------------------------
    def __init__(self, id):
      """
      Constructor.
      """
      self.id = id
      file = open(_fileutil.getOSPath(package_home(globals())+'/images/logo.gif'),'rb')
      self.logo = Image(id='logo', title='', file=file.read())
      file.close()


    # ------------------------------------------------------------------------------------------
    #  ZMS.recurse_updateVersion:
    #
    #  Update version.
    # ------------------------------------------------------------------------------------------
    def recurse_updateVersion(self, REQUEST):
      message = ''
      
      build = getattr(self,'build','000')

      # ---------------------------------------------------------------------
      # 13.12.2002
      # Build #106: Configuration.
      # ---------------------------------------------------------------------
      #-- ZMS.autocommit
      if hasattr(self,'autocommit'):
        self.setConfProperty('ZMS.autocommit',getattr(self,'autocommit',1))
        try: delattr(self,'autocommit')
        except: pass
      #-- ZMS.custom.*
      if hasattr(self,'__attr_dc_metadicts__'):
        self.setConfProperty('ZMS.custom.metas',copy.deepcopy(getattr(self,'__attr_dc_metadicts__',[])))
        try: delattr(self,'__attr_dc_metadicts__')
        except: pass
      if hasattr(self,'__attr_dc_metaobjs__'):
        self.setConfProperty('ZMS.custom.objects',getattr(self,'__attr_dc_metaobjs__',{}).copy())
        try: delattr(self,'__attr_dc_metaobjs__')
        except: pass
      if hasattr(self,'__attr_lang_dict__'):
        self.setConfProperty('ZMS.custom.langs.dict',getattr(self,'__attr_lang_dict__',{}).copy())
        try: delattr(self,'__attr_lang_dict__')
        except: pass
      #-- ZMS.cache.*
      if hasattr(self,'__cache_active__'):
        self.setConfProperty('ZMS.cache.active',getattr(self,'__cache_active__',0))
        try: delattr(self,'__cache_active__')
        except: pass

      # -----------------------------------------------------------
      # 09.03.2002
      # Build #114: Deactivate ZMSSqlDb.
      # -----------------------------------------------------------
      if getattr(self.getDocumentElement(),'build','') < '114':
        self.setConfProperty('ZMSSqlDb.enabled',0)
      
      # -----------------------------------------------------------
      # 19.03.2002
      # Build #116: Textformats.
      # -----------------------------------------------------------
      if hasattr(self,'__attr_text_formats__'):
        self.setConfProperty('ZMS.custom.textformats',copy.deepcopy(getattr(self,'__attr_text_formats__')))
        delattr(self,'__attr_text_formats__')
      if hasattr(self,'__attr_text_formats_default__'):
        self.setConfProperty('ZMS.custom.textformats.default',getattr(self,'__attr_text_formats_default__','body'))
        delattr(self,'__attr_text_formats_default__')
      
      # Process patch.
      # ---------------
      self.recurse_updateVersionPatch(REQUEST)
      
      # Process super-objects.
      # ----------------------
      message += zmscontainerobject.ZMSContainerObject.recurse_updateVersion(self,REQUEST)
      
      # Return with message.
      return message


    # ------------------------------------------------------------------------------------------
    #  ZMS.recurse_updateVersionPatch:
    #
    #  Update version patch.
    # ------------------------------------------------------------------------------------------
    def recurse_updateVersionPatch(self, REQUEST):
      message = ''
      
      _confmanager.updateConf(self,REQUEST)
      self.getStylesheet()
      self.getSequence()
      self.recurse_updateVersionMetaDicts(REQUEST)
      self.recurse_updateVersionMetaObjs()
      self.recurse_updateVersionMetaCmds()
      self.recurse_updateVersionTextFormats(REQUEST)
      self.recurse_updateVersionLanguages(REQUEST)
      self.recurse_updateVersionWorkflow(REQUEST)
      self.synchronizeObjAttrs()
      self.initLangStr()
      self.initRoleDefs()
      
      # Return with message.
      return message


    # ---------------------------------------------------------------------------------------------
    #  ZMS.getDocumentElement
    # ---------------------------------------------------------------------------------------------
    def getDocumentElement(self):
      """
      The root element of the site.
      """
      return self

    # ---------------------------------------------------------------------------------------------
    #  ZMS.getHome
    # ---------------------------------------------------------------------------------------------
    def getHome(self):
      """
      Returns the home-folder of the site.
      """
      ob = self.getDocumentElement()
      while ob.meta_type != 'Folder': 
        ob = ob.aq_parent
      return ob
    
    # ---------------------------------------------------------------------------------------------
    #  ZMS.getNewId
    # ---------------------------------------------------------------------------------------------
    def getNewId(self, id_prefix='e'):
      """
      Returns new (unique) Object-ID.
      """
      return '%s%i'%(id_prefix,self.getSequence().nextVal())

    # ---------------------------------------------------------------------------------------------
    #  ZMS.getMetaTypes:
    # ---------------------------------------------------------------------------------------------
    def getMetaTypes(self, REQUEST, excl_meta_types=['ZMS','ZMSCustom','ZMSTrashcan']): 
      """
      Returns list of meta-types.
      """
      meta_types = []
      for meta_type in self.dGlobalAttrs.keys():
        if meta_type not in excl_meta_types:
          meta_types.append((self.display_type(REQUEST,meta_type),meta_type))
      meta_types.extend(map(lambda meta_type: (self.display_type(REQUEST,meta_type),meta_type),self.getMetaobjIds()))
      meta_types.sort()
      return meta_types

    # ---------------------------------------------------------------------------------------------
    #  ZMS.getDCCoverage
    # ---------------------------------------------------------------------------------------------
    def getDCCoverage(self, REQUEST={}):
      """
      Returns Dublin-Core Meta-Attribute Coverage.
      """
      return 'global.'+self.getPrimaryLanguage()

    # ---------------------------------------------------------------------------------------------
    #  ZMS.sendMail
    # ---------------------------------------------------------------------------------------------
    def sendMail(self, mto, msubject, mbody, REQUEST):
      """
      Sends Mail via MailHost.
      """
      
      ##### Get Sender ####
      auth_user = REQUEST['AUTHENTICATED_USER']
      mfrom = self.getUserAttr(auth_user,'email',self.getConfProperty('ZMSAdministrator.email',''))
      
      ##### Get MailHost ####
      mailhost = None
      homeElmnt = self.getHome()
      if len(homeElmnt.objectValues(['Mail Host'])) == 1:
        mailhost = homeElmnt.objectValues(['Mail Host'])[0]
      elif getattr(homeElmnt,'MailHost',None) is not None:
        mailhost = getattr(homeElmnt,'MailHost',None)
      
      ##### Get MessageText ####
      messageText = ''
      messageText += 'Content-Type: text/plain; charset=unicode-1-1-utf-8\n'
      messageText += 'From: %s\n'%mfrom
      messageText += 'To: %s\n'%mto
      messageText += 'Subject: %s\n\n'%msubject
      messageText += '%s\n'%mbody
      
      ##### Send mail ####
      try:
        _globals.writeBlock( self, "[sendMail]: %s"%messageText)
        mailhost.send(messageText)
        return 0
      except:
        return -1


    ###############################################################################################    
    #
    #   ZMS - Portals
    #
    ###############################################################################################    

    # ---------------------------------------------------------------------------------------------
    #  ZMS.getPortalMaster
    # ---------------------------------------------------------------------------------------------
    def getPortalMaster(self):
      """
      Returns portal-master, none if it does not exist.
      """
      masterDocElmnt = None
      v = self.getConfProperty('Portal.Master','')
      if len(v) > 0:
        thisHome = self.getHome()
        try:
          masterHome = getattr(thisHome,v,None)
          masterDocElmnt = masterHome.objectValues(['ZMS'])[0]
        except:
          _globals.writeException(self, '[getPortalMaster]: %s not found!'%str(v))
      return masterDocElmnt

    # ---------------------------------------------------------------------------------------------
    #  ZMS.getPortalClients
    # ---------------------------------------------------------------------------------------------
    def getPortalClients(self):
      """
      Returns portal-clients, empty list if none exist.
      """
      clientDocElmnts = []
      v = self.getConfProperty('Portal.Clients',[])
      if len(v) > 0:
        thisHome = self.getHome()
        for id in v:
          try:
            clientHome = getattr(thisHome,id,None)
            clientDocElmnt = clientHome.objectValues(['ZMS'])[0]
            clientDocElmnts.append(clientDocElmnt)
          except:
            _globals.writeException(self, '[getPortalClients]: %s not found!'%str(id))
      return clientDocElmnts


    ###############################################################################################    
    #
    #   ZMS - Versions
    #
    ###############################################################################################    

    # ---------------------------------------------------------------------------------------------
    #  ZMS.updateVersion:
    #
    #  Update version.
    # ---------------------------------------------------------------------------------------------
    def updateVersion(self, lang, manage_lang, REQUEST):
      message = ''
      build = getattr( self, 'build', '000')
      patch = getattr( self, 'patch', '000')
      if build < self.zms_build:
        message += self.recurse_updateVersion( REQUEST)
        setattr( self, 'build', self.zms_build)
        setattr( self, 'patch', self.zms_patch)
        message += '[%s]: Updated object-model from  build #%s%s to #%s%s!<br/>'%(self.getHome().id,build,patch,self.zms_build,self.zms_patch)
      if patch < self.zms_patch:
        message += self.recurse_updateVersionPatch(REQUEST)
        setattr( self, 'patch', self.zms_patch)
        message += 'Synchronized object-model from build #%s%s to #%s%s!'%(build,patch,self.zms_build,self.zms_patch)
      self.getTrashcan( ).run_garbage_collection( )
      self.run_pack_history( )
      
      # Process clients.
      for portalClient in self.getPortalClients():
        message += portalClient.updateVersion( lang, manage_lang, REQUEST )
      
      return message


    ###############################################################################################
    ###  
    ###  DOM-Methoden 
    ### 
    ###############################################################################################

    # ---------------------------------------------------------------------------------------------
    #  ZMS.completeTreeNodes:
    # ---------------------------------------------------------------------------------------------
    def _completeTreeNodes(self, ob, curr_dict={}):
      tree_nodes = []
      obs = map(lambda x: (getattr(x.getObjVersion(self.REQUEST),'sort_id',''), x), ob.objectValues(self.dGlobalAttrs.keys()))
      obs.sort()
      ids = map(lambda x: str(x[1].id), obs)
      for id in ids:
        if id in curr_dict.keys():
          tree_nodes.append(self.getRefObjPath(getattr(ob,id)))
          tree_nodes.extend(self._completeTreeNodes(getattr(ob,id), curr_dict[id]))
      return tree_nodes
    #++
    def completeTreeNodes(self, nodes=[]):
      """
      Completes list of nodes by their parents and returns a complete sub-set of the object tree.
      """
      docElmnt = self.getDocumentElement()
      tree_dict = {docElmnt.id:{}}
      for node in nodes:
        curr_dict = tree_dict
	for ob in self.getLinkObj(node).breadcrumbs_obj_path():
	  curr_dict[ob.id] = curr_dict.get(ob.id,{})
	  curr_dict = curr_dict[ob.id]
      tree_nodes = [self.getRefObjPath(docElmnt)]
      tree_nodes.extend(self._completeTreeNodes(docElmnt,tree_dict[docElmnt.id]))
      return tree_nodes


    # ---------------------------------------------------------------------------------------------
    #  ZMS.getParentNode
    # ---------------------------------------------------------------------------------------------
    def getParentNode(self): 
      """
      The parent of this node. 
      All nodes except root may have a parent.
      """
      return None


    ###############################################################################################    
    ###
    ###   XML-Builder
    ###
    ###############################################################################################    

    # ---------------------------------------------------------------------------------------------
    # ZMS.xmlOnStartElement
    # ---------------------------------------------------------------------------------------------
    def xmlOnStartElement(self, sTagName, dTagAttrs, oParentNode, oRoot):
      """
      Handler for XML-Builder (_builder.py)
      """
      if _globals.debug( self):
        _globals.writeLog( self, "[xmlOnStartElement]: sTagName=%s"%sTagName)
      
      # remove all ZMS-objects.
      self.manage_delObjects(self.objectIds(self.dGlobalAttrs.keys()))
      # remove all languages.
      for s_lang in self.getLangIds():
        self.__del_lang__(s_lang)
      
      self.dTagStack = _globals.MyStack()
      self.dValueStack  = _globals.MyStack()
      
      # WORKAROUND! The member variable "aq_parent" does not contain the right parent object at 
      # this stage of the creation process (it will later on!). Therefore, we introduce a special
      # attribute containing the parent object, which will be used by xmlGetParent() (see below).
      self.oParent = None

###################################################################################################
