######################################################################
# flags, constants and built-in defaults for ZWiki

DEFAULT_PAGE_TYPE = 'stxprelinkhtml'    # default render type for new pages
DISABLE_JAVASCRIPT = 1                  # disable javascript in edits ?
LARGE_FILE_SIZE = 1024*1024             # unused ?
AUTO_UPGRADE = 1                        # upgrade old pages when viewed
MAX_NEW_LINES_DISPLAY = 200             # truncate each diff (and mailout)
MAX_OLD_LINES_DISPLAY = 20              # at this number of lines
PAGE_METATYPE = 'ZWiki Page'

# CMF stuff
PAGE_PORTALTYPE = 'Wiki Page'
WIKI_PORTALTYPE = WIKI_METATYPE = 'Wiki Folder'
default_regs = {
    'create': 'nonanon',
    'edit': 'nonanon',
    'comment': 'nonanon',
    'move': 'owners',
    }

# built-in defaults for UI methods
# there seems to be a difference between these and zodb-based DTML methods -
# the latter allow # in multi-line python expressions but these don't
from Globals import HTMLFile
default_standard_wiki_header = HTMLFile(
    'skins/default/standard_wiki_header', globals())
default_standard_wiki_footer = HTMLFile(
    'skins/default/standard_wiki_footer', globals())
default_backlinks = HTMLFile('skins/default/backlinks', globals())
default_contentspage = HTMLFile('skins/default/contentspage', globals())
default_diffform = HTMLFile('skins/default/diffform', globals())
default_editform = HTMLFile('skins/default/editform', globals())
default_subscribeform = HTMLFile('skins/default/subscribeform', globals())

# ZPT-based defaults
# with older zope versions ZPTs might not be available
try:
    # with zope 2.5.x < 2.5.1, need to import Zope first
    # (http://lists.zope.org/pipermail/zope-coders/2002-March/000953.html)
    # hmm can't do that.. how can we support PageTemplateFile with <2.5.1 ?
    #try:
    #    from Products.PageTemplates.PageTemplateFile import PageTemplateFile
    #except ImportError:
    #    import Zope
    #    from Products.PageTemplates.PageTemplateFile import PageTemplateFile
    #default_wikipage = PageTemplateFile('skins/default/wikipage',
    #                                    globals(),__name__='wikipage')
    from Products.PageTemplates.PageTemplateFile import PageTemplateFile
    #default_wikipage = PageTemplateFile('skins/default/wikipage',
    #                                    globals(),__name__='wikipage')
    #oh gawd
    #subclass it to make here & container simulate the zwiki page's context
    from Products.PageTemplates.Expressions import SecureModuleImporter
    class MyPageTemplateFile(PageTemplateFile):
        def pt_getContext(self):
            root = self.getPhysicalRoot()
            c = {'template': self,
                 'here': self.aq_inner.aq_parent,
                 'container': self.aq_inner.aq_parent.aq_parent,
                 'nothing': None,
                 'options': {},
                 'root': root,
                 'request': getattr(root, 'REQUEST', None),
                 'modules': SecureModuleImporter,
                 }
            return c
    default_wikipage = MyPageTemplateFile('skins/default/wikipage',
                                          globals(),__name__='wikipage')

except ImportError:
    default_wikipage = None


