# UI-related methods

import os, sys, re, string, time, math, traceback
import string
from string import split,join,find,lower,rfind,atoi,strip
from Utils import DLOG
from Defaults import DEFAULT_PAGE_TYPE, DISABLE_JAVASCRIPT, \
     LARGE_FILE_SIZE, AUTO_UPGRADE, \
     default_standard_wiki_header, default_standard_wiki_footer, \
     default_editform, default_backlinks, default_subscribeform, \
     default_wikipage, default_contentspage, default_diffform
from AccessControl import getSecurityManager, ClassSecurityInfo
import Permissions
from LocalizerSupport import LocalDTMLFile, _, N_
from Globals import MessageDialog

class UI:
    """
    Holds most of ZWikiPage's UI-related methods.
    """
    security = ClassSecurityInfo()

    # methods to generate standard forms & dialogs; most of these can be
    # overridden by a DTML method of the same name. 
    # Return a placeholder if there is an error; useful if someone's
    # custom header has broken or if we are running tests.
    # XXX REQUEST & authentication not passed to page templates ?

    # make this a page method so tests/support.py can override it
    # and perhaps flesh it out later
    security.declareProtected(Permissions.View, 'wikipage')
    wikipage = default_wikipage

    security.declareProtected(Permissions.View, 'standard_wiki_header')
    def standard_wiki_header(self,client=None,REQUEST=None,RESPONSE=None,**kw):
        """
        Return a default or custom wiki page header. 

        May be overridden by a DTML method of the same name.
        """
        try:
            if hasattr(self.folder(), 'standard_wiki_header'):
                return self.folder().standard_wiki_header(self,REQUEST)
            else:
                return default_standard_wiki_header(self,self,REQUEST)
        except:
            type, val, tb = sys.exc_info()
            err = string.join(traceback.format_exception(type,val,tb),'')
            return '<html>\n<body>\ncould not render this.\n<!--\n%s\n-->\n'\
                   % err

    security.declareProtected(Permissions.View, 'standard_wiki_footer')
    def standard_wiki_footer(self,client=None,REQUEST=None,RESPONSE=None,**kw):
        """
        Return a default or custom wiki page footer. 

        May be overridden by a DTML method of the same name.
        """
        try:
            if hasattr(self.folder(), 'standard_wiki_footer'):
                return self.folder().standard_wiki_footer(self,REQUEST)
            else:
                return default_standard_wiki_footer(self,self,REQUEST)
        except:
            type, val, tb = sys.exc_info()
            err = string.join(traceback.format_exception(type,val,tb),'')
            return 'could not render this.\n<!--\n%s\n-->\n</body>\n</html>\n'\
                   % err

    security.declareProtected(Permissions.View, 'backlinks')
    def backlinks(self, REQUEST=None):
        """
        Display a default or custom backlinks page. 

        May be overridden by a page template or DTML method of the same name.
        """
        form = getattr(self.folder(),'backlinks',default_backlinks)
        type = getattr(form,'meta_type','DEFAULT')
        if type in ('Page Template','Filesystem Page Template'):
            return apply(form.__of__(self),(self,REQUEST),{})
        elif type == 'DTML Method':
            return form(self,REQUEST)
        elif type == 'DEFAULT':
            return form(self,self,REQUEST) # defaults are HTMLFiles
        else:
            return 'Bad form type - use a page template or dtml method.'

    security.declareProtected(Permissions.View, 'contentspage')
    def contentspage(self, hierarchy, singletons, REQUEST=None):
        """
        Display a default or custom contents page. 

        May be overridden by a page template or DTML method of the same
        name.  Adds hierarchy and singletons to the template namespace for
        rendering.
        """
        form = getattr(self.folder(),'contentspage',default_contentspage)
        type = getattr(form,'meta_type','DEFAULT')
        if type in ('Page Template','Filesystem Page Template'):
            return apply(form.__of__(self),(self,REQUEST),
                         {'hierarchy':hierarchy,'singletons':singletons})
        elif type == 'DTML Method':
            return form(self,REQUEST,
                        getattr(REQUEST,'RESPONSE',None), #need this ?
                        hierarchy=hierarchy,singletons=singletons)
        elif type == 'DEFAULT':
            return form(self,self,REQUEST, # defaults are HTMLFiles
                        hierarchy=hierarchy,singletons=singletons)
        else:
            return 'Bad form type - use a page template or dtml method.'

    security.declareProtected(Permissions.View, 'diffform')
    def diffform(self, revA, difftext, REQUEST=None):
        """
        Display a default or custom contents page. 

        May be overridden by a page template or DTML method of the same
        name.  Adds hierarchy and singletons to the template namespace for
        rendering.
        """
        form = getattr(self.folder(),'diffform',default_diffform)
        type = getattr(form,'meta_type','DEFAULT')
        if type in ('Page Template','Filesystem Page Template'):
            return apply(form.__of__(self),(self,REQUEST),
                         {'revA':revA,'difftext':difftext})
        elif type == 'DTML Method':
            return form(self,REQUEST,
                        revA=revA,difftext=difftext)
        elif type == 'DEFAULT':
            return form(self,self,REQUEST, # defaults are HTMLFiles
                        revA=revA,difftext=difftext)
        else:
            return 'Bad form type - use a page template or dtml method.'

    security.declareProtected(Permissions.Change, 'editform')
    def editform(self, REQUEST=None, page=None, text=None, action='Change'):
        """
        Display a default or custom form to edit or create the specified page.

        For new pages, initial text may be specified.
        May be overridden by a page template or DTML method of the same name.
        """
        if hasattr(self,'wl_isLocked') and self.wl_isLocked():
            return self.davLockDialog()

        # what are we going to do ? set up page, text & action accordingly
        if page is None:
            # no page specified - editing the current page
            page = self.title_or_id()
            text = self.read()
        #elif hasattr(self.folder(), page):
        elif self.pageWithName(page):
            # editing a different page
            text = self.pageWithName(page).read()
        else:
            # editing a brand-new page
            action = 'Create'
            text = ''

        # display the edit form - a dtml method or the builtin default
        # NB we redefine id as a convenience, so that one header can work
        # for pages and editforms
        # XXX can we simplify this/make dtml more version independent ?
        # no way to restrict /editform currently
        form = getattr(self.folder(),'editform',default_editform)
        type = getattr(form,'meta_type','DEFAULT')
        if type in ('Page Template','Filesystem Page Template'):
            return apply(form.__of__(self),(self,REQUEST),
                         {'page':page,'text':text,'action':action,
                          'id':page,'oldid':self.getId()})
        elif type == 'DTML Method':
            return form(self,REQUEST,
                        page=page,text=text,action=action,
                        id=page,oldid=self.id())
        elif type == 'DEFAULT':
            return form(self,self,REQUEST, # defaults are HTMLFiles
                        page=page,text=text,action=action,
                        id=page,oldid=self.id())
        else:
            return 'Bad form type - use a page template or dtml method.'

    security.declareProtected(Permissions.View, 'subscribeform')
    def subscribeform(self, REQUEST=None):
        """
        Display a default or custom mail subscription form. 

        May be overridden by a page template or DTML method of the same name.
        """
        form = getattr(self.folder(),'subscribeform',default_subscribeform)
        type = getattr(form,'meta_type','DEFAULT')
        if type in ('Page Template','Filesystem Page Template'):
            return apply(form.__of__(self),(self,REQUEST),{})
        elif type == 'DTML Method':
            return form(self,REQUEST)
        elif type == 'DEFAULT':
            return form(self,self,REQUEST) # defaults are HTMLFiles
        else:
            return 'Bad form type - use a page template or dtml method.'
    
    security.declareProtected(Permissions.View, 'editConflictDialog')
    def editConflictDialog(self):
        """
        web page displayed in edit conflict situations.
        """
        titlestr=_('Edit conflict')
        return MessageDialog(
            title=titlestr,
            message="""
            <b>%s</b>
            <p>
            %s.
            %s:
            <ol>
            <li>%s
            <li>%s
            <li>%s
            <li>%s
            <li>%s.
            </ol>
            %s,
            <p>
            %s.
            """ % (
            titlestr,
            _("Someone else has saved this page while you were editing"),
            _("To resolve the conflict, do this"),
            _("Click your browser's back button"),
            _("Copy your recent edits to the clipboard"),
            _("Click your browser's refresh button"),
            _("Paste in your edits again, being mindful of the latest changes"),
            _("Click the Change button again"),
            _("or"),
            _("To discard your changes and start again, click OK"),
            ),
            action=self.page_url()+'/editform')

    security.declareProtected(Permissions.View, 'davLockDialog')
    def davLockDialog(self):
        """
        web page displayed in webDAV lock conflict situations.
        """
        titlestr=_('Page is locked')
        return MessageDialog(
            title=titlestr,
            message="""
            <b>%s</b>
            <p>
            %s
            <p>
            %s
            """ % (
            titlestr,
            _("""
            This page has a webDAV lock. Someone is probably editing it
            with an external editor.  You'll need to wait until they've
            finished and then try again.  If you've just made some changes,
            you may want to back up and copy your version of the text for
            reference.
            """),
            _("To discard your changes and try again, click OK."),
            ),
            action=self.page_url()+'/editform')

