<?php
/*
 * This file is part of Zoph.
 *
 * Zoph is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Zoph is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with Zoph; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
    require_once("include.inc.php");
    if ($_action=="insert") {
        $search=new search();
        $search->set("owner", $user->get("user_id"));
    } else if ($_action == "update" || 
               $_action == "confirm" || 
               $_action == "delete" ) {
        $search_id=getvar("search_id");
        $search=new search($search_id);
        $search->lookup($user);
        if (!($search->get("owner") == $user->get("user_id") || 
            $user->is_admin())) {
            header("Location: " . add_sid("zoph.php"));
            die("You are not allowed to do that!");
        }
    }
    
    if (strtolower($_action) == strtolower(rtrim(translate("search")))) {
        $request_vars = clean_request_vars($request_vars);
        require_once("photos.php");
    } else if ($_action=="new" || $_action=="edit") {
        if($_action=="new") {
            $action="insert";
            unset($request_vars["_action"]);
            $request_vars = clean_request_vars($request_vars);

            foreach($request_vars as $key => $val) {
                $key=preg_replace("/\#([0-9]+)/", "[$1]", $key);
                if($url) {
                    $url.="&";
                }   
                $url.=$key. "=" . $val;
            }
            $search=new search; 
            $search->set("search", $url);
            $search->set("owner", $user->get("user_id"));
        } else if ($_action=="edit") {
            $action="update";
            $search_id=getvar("search_id");
            $search=new search($search_id);
            $search->lookup($user);
            $url=$search->get("search");
        }   
        require_once("header.inc.php");
?>
    <h1><?php echo translate("Save search")?></h1>
    <div class="main">
    <form>
        <input type="hidden" name="search_id" value="<?php echo $search->get("search_id") ?>">

        <?php echo create_edit_fields($search->get_edit_array($user)) ?>
        <input type="hidden" name="search" value="<?php echo $url ?>">
        <input type="hidden" name="_action" value="<?php echo $action?>">
        <input type="submit" name="_button" value="<?php echo translate($action)?>">
    </form>
    <div>
<?php
        require_once("footer.inc.php");
        end;
    
    
    } else if ($_action=="update" || 
               $_action=="confirm" || 
               $_action=="insert") {
        $redirect = "search.php";
        $obj = &$search;
        require_once("actions.inc.php");
        header("Location: " . add_sid($redirect));
    } else if ($_action=="delete") {
        $search_id=getvar("search_id");
        $search=new search($search_id);
        $search->lookup($user);
        $url="search.php?search_id=" . $search->get("search_id") . 
            "&_action=confirm";
        require_once("header.inc.php");
?>
    <h1><?php echo translate("Delete saved search")?></h1>
    <div class="main">
        <span class="actionlink">
            <a href='<?php echo $url ?>'><?php echo translate("confirm") ?></a>
            | <a href='search.php'><?php echo translate("cancel") ?></a>
        </span>
        <?php printf(translate("Confirm deletion of saved search '%s'"), $search->get("name")) ?>
        <br>
     </div>
<?php
        require_once("footer.inc.php");
        end;
    } else {

        $today = date("Y-m-d");

        require_once("header.inc.php");

/*
  Each search item is stored in a set of arrays. The increment button increases the size of the array.
  The form is generated by looping through the array from the first element to the second to last element,
  displaying it without an increment button. Then the last element is displayed with an increment button.

  Each time a search item is added to the form, it is regenerated with the contents intact. -RB
*/
?>
          <h1><?php echo translate("search") ?></h1>
<?php
    echo check_js($user);
?>
      <div class="main">

      <form method="GET" action="search.php">
        <!-- There is a search button here to make it the first submit in the form for submit on Enter -->
        <span>
            <input type="submit" name="_action" value="<?php echo translate("search", 0); ?>">
        </span>
      <table id="search">
<?php
      /* photo taken date */

    $date = getvar('date'); 
    $_date_conj = getvar('_date_conj'); 
    $_date_op = getvar('_date_op');
  
    $count = sizeof($date) - 1;
    if ( $date[$count] == "+" ) {
        $date[$count] = "";
    }
    for ($i = 0; $i <= $count; $i++) {
?>
        <tr>
          <td>
<?php
    if($i==$count) {
?>
        <input type="submit" class="increment" name="date[<?php echo $count + 1; ?>]" value="+">
<?php
    } else {
?>
        &nbsp;
<?php
    }
?>
          </td>
          <td>
<?php echo create_conjunction_pulldown("_date_conj[$i]", $_date_conj[$i]) ?>
          </td>
          <td><?php echo translate("photos taken") ?></td>
          <td>
<?php echo create_inequality_operator_pulldown("_date_op[$i]", $_date_op[$i]) ?>
          </td>
          <td colspan="2">
<?php echo create_pulldown("date[$i]", $date[$i], get_date_select_array($today, MAX_DAYS_PAST)) ?>
<?php echo translate("days ago") ?>
          </td>
        </tr>
<?php
    }
      /* photos last modified */

    $timestamp = getvar('timestamp'); 
    $_timestamp_conj = getvar('_timestamp_conj'); 
    $_timestamp_op = getvar('_timestamp_op');
  
    $count = sizeof($timestamp) - 1; 
    if ( $timestamp[$count] == "+" ) { 
        $timestamp[$count] = "";
    }
for ($i = 0; $i <= $count; $i++) {
?>
        <tr>
          <td>
<?php
    if($i==$count) {
?>
        <input type="submit" class="increment" name="timestamp[<?php echo $count + 1; ?>]" value="+">
<?php
    } else {
?>
        &nbsp;
<?php
    }
?>
          </td>
          <td>
<?php echo create_conjunction_pulldown("_timestamp_conj[$i]", $_timestamp_conj[$i]) ?>
          </td>
          <td><?php echo translate("photos modified") ?></td>
          <td>
<?php echo create_inequality_operator_pulldown("_timestamp_op[$i]", $_timestamp_op[$i]) ?>
          </td>
          <td colspan="2">
<?php echo create_pulldown("timestamp[$i]", $timestamp[$i], get_date_select_array($today, MAX_DAYS_PAST)) ?>
<?php echo translate("days ago") ?>
          </td>
        </tr>
<?php
  } 
      /* photo album */

    $album_id = getvar('album_id'); 
    $_album_id_conj = getvar('_album_id_conj'); 
    $_album_id_op = getvar('_album_id_op');
    $_album_id_children = getvar('_album_id_children');

    $count = sizeof($album_id) - 1; 
    if ( $album_id[$count] == "+" ) { 
        $album_id[$count] = "";
    }
    
    for ($i = 0; $i <= $count; $i++) {
        if ($_album_id_children[$i]) {
            $checked="checked";
        } else {
            $checked="";
        }
?>
        <tr>
          <td>
<?php
    if($i==$count) {
?>
        <input type="submit" class="increment" name="album_id[<?php echo $count + 1; ?>]" value="+">
<?php
    } else {
?>
        &nbsp;
<?php
    }
?>
          </td>
          <td>
<?php echo create_conjunction_pulldown("_album_id_conj[$i]", $_album_id_conj[$i]) ?>
          </td>
          <td><?php echo translate("album") ?></td>
          <td>
<?php echo create_binary_operator_pulldown("_album_id_op[$i]", $_album_id_op[$i]) ?>
          </td>
          <td colspan="2">
<?php
            echo create_album_pulldown("album_id[$i]", $album_id[$i], $user);
?>
          <br><input type="checkbox" name="_album_id_children[<?php echo $i ?>]" value="yes" <?php echo $checked ?>><label for="_album_id_children[<?php echo $i ?>]"><?php echo translate("include sub-albums") ?></label>
          </td>
        </tr>
<?php
  } 
      /* photo category */

    $category_id = getvar('category_id'); 
    $_category_id_conj = getvar('_category_id_conj'); 
    $_category_id_op = getvar('_category_id_op');
    $_category_id_children = getvar('_category_id_children');
    
    $count = sizeof($category_id) - 1; 
    if ( $category_id[$count] == "+" ) { 
        $category_id[$count] = "";
    }
    
    for ($i = 0; $i <= $count; $i++) {
        if ($_category_id_children[$i]) {
            $checked="checked";
        } else {
            $checked="";
        }
?>
        <tr>
          <td>
<?php
    if($i==$count) {
?>
        <input type="submit" class="increment" name="category_id[<?php echo $count + 1; ?>]" value="+">
<?php
    } else {
?>
        &nbsp;
<?php
    }
?>
          </td>
          <td>
<?php echo create_conjunction_pulldown("_category_id_conj[$i]", $_category_id_conj[$i]) ?>
          </td>
          <td><?php echo translate("category") ?></td>
          <td>
<?php echo create_binary_operator_pulldown("_category_id_op[$i]", $_category_id_op[$i]) ?>
          </td>
          <td colspan="2">
<?php
            echo create_cat_pulldown("category_id[$i]", $category_id[$i], $user);
?>
          <br><input type="checkbox" name="_category_id_children[<?php echo $i ?>]" value="yes" <?php echo $checked ?>><label for="_category_id_children[<?php echo $i ?>]"><?php echo translate("include sub-categories") ?></label>
          </td>
        </tr>
<?php
  }
      /* photo location */

    $location_id = getvar('location_id'); 
    $_location_id_conj = getvar('_location_id_conj'); 
    $_location_id_op = getvar('_location_id_op');
    $_location_id_children = getvar('_location_id_children');
    
    $count = sizeof($location_id) - 1; 
    if ( $location_id[$count] == "+" ) { 
        $location_id[$count] = "";
    }
    
    for ($i = 0; $i <= $count; $i++) {
        if ($_location_id_children[$i]) {
            $checked="checked";
        } else {
            $checked="";
        }
?>
        <tr>
          <td>
<?php
    if($i==$count) {
?>
        <input type="submit" class="increment" name="location_id[<?php echo $count + 1; ?>]" value="+">
<?php
    } else {
?>
        &nbsp;
<?php
    }
?>
          </td>
          <td>
<?php echo create_conjunction_pulldown("_location_id_conj[$i]", $_location_id_conj[$i]) ?>
          </td>
          <td><?php echo translate("location") ?></td>
          <td>
<?php echo create_binary_operator_pulldown("_location_id_op[$i]", $_location_id_op[$i]) ?>
          </td>
          <td colspan="2">
<?php
            echo create_place_pulldown("location_id[$i]", $location_id[$i], $user);
?>
          <br><input type="checkbox" name="_location_id_children[<?php echo $i ?>]" value="yes" <?php echo $checked ?>><label for="_location_id_children[<?php echo $i ?>]"><?php echo translate("include sub-places") ?></label>
          </td>
        </tr>
<?php
  } 
      /* photo rating */

    $rating = getvar('rating'); 
    $_rating_conj = getvar('_rating_conj'); 
    $_rating_op = getvar('_rating_op');
  
    $count = sizeof($rating) - 1; 
    if ( $rating[$count] == "+" ) { 
        $rating[$count] = "";
    }
  
    for ($i = 0; $i <= $count; $i++) {
?>
        <tr>
          <td>
<?php
    if($i==$count) {
?>
        <input type="submit" class="increment" name="rating[<?php echo $count + 1; ?>]" value="+">
<?php
    } else {
?>
        &nbsp;
<?php
    }
?>
          </td>
          <td>
<?php echo create_conjunction_pulldown("_rating_conj[$i]", $_rating_conj[$i]) ?>
          </td>
          <td><?php echo translate("rating") ?></td>
          <td>
<?php echo create_operator_pulldown("_rating_op[$i]", $_rating_op[$i]) ?>
          </td>
          <td colspan="2">
<?php echo create_rating_pulldown($rating[$i], "rating[$i]") ?>
          </td>
        </tr>
<?php
  } 
      /* photo person */

    $person_id = getvar('person_id'); 
    $_person_id_conj = getvar('_person_id_conj'); 
    $_person_id_op = getvar('_person_id_op');
    
    $count = sizeof($person_id) - 1; 
    if ( $person_id[$count] == "+" ) { 
        $person_id[$count] = "";
    }
    
    for ($i = 0; $i <= $count; $i++) {
?>
        <tr>
          <td>
<?php
    if($i==$count) {
?>
        <input type="submit" class="increment" name="person_id[<?php echo $count + 1; ?>]" value="+">
<?php
    } else {
?>
        &nbsp;
<?php
    }
?>
          </td>
          <td>
<?php echo create_conjunction_pulldown("_person_id_conj[$i]", $_person_id_conj[$i]) ?>
          </td>
          <td><?php echo translate("person") ?></td>
          <td>
<?php echo create_present_operator_pulldown("_person_id_op[$i]", $_person_id_op[$i]) ?>
          </td>
          <td colspan="2">
<?php
            echo create_person_pulldown("person_id[$i]", $person_id[$i], $user);
?>
          </td>
        </tr>
<?php
  } 
      /* photographer */

    $photographer_id = getvar('photographer_id'); 
    $_photographer_id_conj = getvar('_photographer_id_conj');
    $_photographer_id_op = getvar('_photographer_id_op');
    
    $count = sizeof($photographer_id) - 1; 
    if ( $photographer_id[$count] == "+" ) { 
        $photographer_id[$count] = "";
    }
    
    for ($i = 0; $i <= $count; $i++) {
?>
        <tr>
          <td>
<?php
    if($i==$count) {
?>
        <input type="submit" class="increment" name="photographer_id[<?php echo $count + 1; ?>]" value="+">
<?php
    } else {
?>
        &nbsp;
<?php
    }
?>
          </td>
          <td>
<?php echo create_conjunction_pulldown("_photographer_id_conj[$i]", $_photographer_id_conj[$i]) ?>
          </td>
          <td><?php echo translate("photographer") ?></td>
          <td>
<?php echo create_binary_operator_pulldown("_photographer_id_op[$i]", $_photographer_id_op[$i]) ?>
          </td>
          <td colspan="2">
<?php 
            echo create_photographer_pulldown("photographer_id[$i]", $photographer_id[$i], $user);
?>
          </td>
        </tr>
<?php
    } 
      /* photo exif field data */

    $field = getvar('field'); 
    $_field = getvar('_field'); 
    $_field_conj = getvar('_field_conj'); 
    $_field_op = getvar('_field_op');
    
    $count = sizeof($_field) - 1; 
    if ( $_field[$count] == "+" ) { 
        $_field[$count] = "";
    }
    for ($i = 0; $i <= $count; $i++) {
?>
        <tr>
          <td>
<?php
    if($i==$count) {
?>
        <input type="submit" class="increment" name="_field[<?php echo $count + 1; ?>]" value="+">
<?php
    } else {
?>
        &nbsp;
<?php
    }
?>
          </td>
          <td>
<?php echo create_conjunction_pulldown("_field_conj[$i]", $_field_conj[$i]) ?>
          </td>
          <td>
<?php echo create_photo_field_pulldown("_field[$i]", $_field[$i]) ?>
          </td>
          <td>
<?php echo create_operator_pulldown("_field_op[$i]", $_field_op[$i]) ?>
          </td>
          <td colspan="2">
            <input type="text" name="field[<?php echo $i; ?>]" value="<?php echo $field[$i]; ?>" size="24" maxlength="64">
          </td>
        </tr>
<?php
    }
      /* Text search for albums/categories/people/photographers */

    $text = getvar('text'); 
    $_text = getvar('_text'); 
    $_text_conj = getvar('_text_conj'); 
    $_text_op = getvar('_text_op');
    
    $count = sizeof($_text) - 1; 
    if ( $_text[$count] == "+" ) { 
        $_text[$count] = "";
    }
    for ($i = 0; $i <= $count; $i++) {
?>
        <tr>
          <td>
<?php
    if($i==$count) {
?>
        <input type="submit" class="increment" name="_text[<?php echo $count + 1; ?>]" value="+">
<?php
    } else {
?>
        &nbsp;
<?php
    }
?>
          </td>
          <td>
<?php echo create_conjunction_pulldown("_text_conj[$i]", $_text_conj[$i]) ?>
          </td>
          <td>
<?php echo create_photo_text_pulldown("_text[$i]", $_text[$i]) ?>
          </td>
          <td>
            <?php echo translate("like"); ?>
          </td>
          <td colspan=2>
            <input type="text" name="text[<?php echo $i; ?>]" value="<?php echo $text[$i]; ?>" size="24" maxlength="64">
          </td>
        </tr>
<?php
    }
?>
      </table>
      <!-- And another search button for consistancy -->
      <span>
          <input type="submit" name="_action" value="<?php echo translate("search", 0); ?>">
      </span>
  </form>
<?php
    echo get_list_of_saved_searches($user)
?>

</div>
<?php
require_once("footer.inc.php");

}
?>
