/***************************************************************************
 *
 * COPYRIGHTHERE
 *
 * $Id: authprovider.c,v 1.5.2.4 2004/02/03 09:16:28 sasa Exp $
 *
 * Author  : Bazsi
 * Auditor :
 * Last audited version:
 * Notes:
 *
 ***************************************************************************/

#include <zorp/authprovider.h>
#include <zorp/log.h>

#include <crypt.h>

void
z_auth_free_command(ZAuthCommand *cmd)
{
  guint i;
  
  z_enter();
  
  for (i = 0; i < cmd->header_len * 2; i++)
    {
      if (cmd->headers[i])
        g_free(cmd->headers[i]);
    }

  g_free(cmd);
  z_leave();
}

PyObject *
z_py_zorp_auth_get_python_from_cmd(ZAuthCommand *cmd)
{
  PyObject *args = NULL;
  guint i, j;
  guint len = 0;
  
  for (i = 0; i < cmd->header_len; i++)
    {
      if (cmd->headers[i * 2] && cmd->headers[i * 2 + 1])
        {
          len++;
        }
    }
  
  args = PyList_New(len);
  
  if (len > 0)
    {
      j = 0;

      for (i = 0; i < cmd->header_len; i++)
        {
          if (cmd->headers[i * 2] && cmd->headers[i * 2 + 1])
            {
            PyList_SetItem(args,
                           j,
                           z_policy_var_build("(ss)",
                                              cmd->headers[i * 2],
                                              cmd->headers[i * 2 + 1]));
            j++;
            }
        }
    }
  return args;
}

gboolean
z_py_zorp_auth_get_cmd_from_python(PyObject *args, ZAuthCommand *cmd)
{
  guint i;
  PyObject *header;

  z_enter();
  header = PyObject_Str(args);
  if (PyList_Check(args))
    {
      cmd->header_len = PyList_Size(args);

      if (cmd->header_len > 0)
        {
          cmd->headers = g_new(char *, cmd->header_len * 2);
        }

      for (i = 0; i < cmd->header_len; i++)
        {
          header = PyList_GetItem(args, i);
          if (PyTuple_Size(header) == 2)
            {
              cmd->headers[i * 2] = g_strdup(PyString_AsString(PyTuple_GetItem(header, 0)));
              cmd->headers[i * 2 + 1] = g_strdup(PyString_AsString(PyTuple_GetItem(header, 1)));
            }
          else
            {
              cmd->headers[i * 2] = NULL;
              cmd->headers[i * 2 + 1] = NULL;
            }
        }
      z_leave();
      return TRUE;
    }
  z_leave();
  return FALSE;
}


ZAuthCommand *
z_auth_provider_command(ZAuthorization *self,
                           const gchar *command,
                                 gchar *session_id,
                          ZAuthCommand *cmd)
{
  ZPolicyObj *args;
  ZPolicyObj *res;
  ZPolicyObj *cmd_obj;
  gulong cmd_num;
  gboolean called;
  ZAuthCommand *answer;
  
  z_enter();
  args = z_py_zorp_auth_get_python_from_cmd(cmd);
  res = z_policy_call(self, (char *)command, z_policy_var_build("(sO)", session_id, args), &called, session_id);

  z_policy_var_unref(args);

  if (res && PyTuple_Check(res))
    {
      cmd_obj = PyTuple_GetItem(res, 0);
      
      if (PyInt_Check(cmd_obj))
        {
          answer = g_new0(ZAuthCommand, 1);
          cmd_num = PyInt_AsLong(cmd_obj);
          
          switch(cmd_num)
            {
            case Z_AUTH_CMD_GETMETHODS:
              g_strlcpy(answer->command, "GETMETHODS", MAX_COMMAND_LEN);
              break;
            case Z_AUTH_CMD_SETMETHOD:
              g_strlcpy(answer->command, "SETMETHOD", MAX_COMMAND_LEN);
              break;
            case Z_AUTH_CMD_RESPONSE:
              g_strlcpy(answer->command, "RESPONSE", MAX_COMMAND_LEN);
              break;
            case Z_AUTH_CMD_ABORT:
              g_strlcpy(answer->command, "ABORT", MAX_COMMAND_LEN);
              break;
            case Z_AUTH_CMD_METHODS:
              g_strlcpy(answer->command, "METHODS", MAX_COMMAND_LEN);
              break;
            case Z_AUTH_CMD_REQUEST:
              g_strlcpy(answer->command, "REQUEST", MAX_COMMAND_LEN);
              break;
            case Z_AUTH_CMD_ACCEPT:
              g_strlcpy(answer->command, "ACCEPT", MAX_COMMAND_LEN);
              break;
            case Z_AUTH_CMD_REJECT:
              g_strlcpy(answer->command, "REJECT", MAX_COMMAND_LEN);
              break;
            default:
              g_free(answer);
              z_leave();
              return NULL;
            }
      
          args = PyTuple_GetItem(res, 1);
      
          if (z_py_zorp_auth_get_cmd_from_python(args, answer))
            {
              z_policy_var_unref(res);
              z_leave();
              return answer;
            }
          g_free(answer);
        }
    }
  z_policy_var_unref(res);
  z_leave();
  return NULL;
}

ZAuthCommand *
z_auth_provider_getmethods(ZAuthorization *self,
                                    gchar *session_id,
                             ZAuthCommand *cmd)
{
  ZAuthCommand *ret;
  ret = z_auth_provider_command(self, "getMethods", session_id, cmd);
  return ret;
}

ZAuthCommand *
z_auth_provider_setmethod(ZAuthorization *self,
                                   gchar *session_id,
                           ZAuthCommand *cmd)
{
  ZAuthCommand *ret;
  ret = z_auth_provider_command(self, "setMethod", session_id, cmd);
  return ret;
}

ZAuthCommand *
z_auth_provider_response(ZAuthorization *self,
                                  gchar *session_id,
                          ZAuthCommand *cmd)
{
  ZAuthCommand *ret;
  ret = z_auth_provider_command(self, "converse", session_id, cmd);
  return ret;
}

ZAuthCommand *
z_auth_provider_abort(ZAuthorization *self,
                               gchar *session_id,
                        ZAuthCommand *cmd)
{
  ZAuthCommand *ret;
  ret = z_auth_provider_command(self, "stopSession", session_id, cmd);
  return ret;
}

gboolean
z_auth_provider_check_passwd(ZAuthorization *self,
                                      gchar *session_id,
                                      gchar *username,
                                      gchar *passwd)
{
  ZAuthCommand cmd, *answer;
  gint max_count = -1, max_pri = -1, max_alpri = -1;
  guint i;
  gchar **split;
  gchar salt[65];
  
  z_session_enter(session_id);
  cmd.headers = g_new0(gchar *, 2);
  cmd.headers[0] = "User";
  cmd.headers[1] = username;
  cmd.header_len = 1;

  answer = z_auth_provider_getmethods(self, session_id, &cmd);

  if (answer && strcmp(answer->command, "METHODS") == 0)
    {
      for (i = 0; i < answer->header_len; i++)
        {
          if (strcmp(answer->headers[i * 2], "Method") == 0)
            {
              split = g_strsplit(answer->headers[i * 2 + 1], ":", 4);
              if (split &&
                  split[0] != NULL &&
                  split[1] != NULL &&
                  split[2] != NULL)
                {
                  if (strstr(split[0], "PASSWD") == split[0])
                    {
                      if (max_pri < atoi(split[1]) ||
                          (max_pri == atoi(split[1]) &&
                           max_alpri < atoi(split[2])))
                        {
                          max_pri = atoi(split[1]);
                          max_alpri = atoi(split[2]);
                          max_count = i;
                        }
                    }
                }
              g_strfreev(split);
            }
        }
      if (max_count >= 0)
        {
          split = g_strsplit(answer->headers[max_count * 2 + 1], ":", 2);
          cmd.headers[0] = "Method";
          cmd.headers[1] = split[0];
          
          z_auth_free_command(answer);
          answer = z_auth_provider_setmethod(self, session_id, &cmd);

          g_strfreev(split);

          salt[0] = 0;
          if (answer && strcmp(answer->command, "REQUEST") == 0)
            {
              for (i = 0; i < answer->header_len; i++)
                {
                  if (strcmp(answer->headers[i * 2], "Salt") == 0)
                    {
                      g_strlcpy(salt, answer->headers[i * 2 + 1], sizeof(salt));
                    }
                }

              z_auth_free_command(answer);

              cmd.headers[0] = "Password";

              /* FIXME: when to use crypt ?? */
              /* FIXME/2: crypt must be locked */
              if (salt[0] && strlen(salt) == 2)
                cmd.headers[1] = g_strdup(crypt(passwd, salt));
              else
                cmd.headers[1] = g_strdup(passwd);

              answer = z_auth_provider_setmethod(self, session_id, &cmd);

              g_free(cmd.headers[1]);
              if (answer && strcmp(answer->command, "ACCEPT") == 0)
                {
                  z_auth_free_command(answer);
                  z_session_leave(session_id);
                  return TRUE;
                }
            }
        }
    }
  if (answer)
    z_auth_free_command(answer);
  z_session_leave(session_id);
  return FALSE;
}

