/***************************************************************************
 *
 * COPYRIGHTHERE
 *
 * $Id: fastpath.c,v 1.11.2.4 2004/02/03 09:16:28 sasa Exp $
 *
 * Author  : bazsi
 * Auditor :
 * Last audited version:
 * Notes:
 *
 ***************************************************************************/

#include <zorp/proxy.h>
#include <zorp/fastpath.h>
#include <zorp/log.h>

void
z_proxy_fastpath_destroy(ZProxyFastpath *self)
{
  if (self->router_data)
    self->router_free(self->router_data);
  if (self->chainer_data)
    self->chainer_free(self->chainer_data);
  if (self->snat_data)
    self->snat_free(self->snat_data);
  if (self->dnat_data)
    self->dnat_free(self->dnat_data);
}

void
z_proxy_fastpath_session_destroy(ZProxyFastpathSession *self)
{
  z_sockaddr_unref(self->client_address);
  z_sockaddr_unref(self->client_local);
  z_sockaddr_unref(self->server_address);
  z_sockaddr_unref(self->server_local);
}

ZStream *
z_proxy_fastpath_connect_server_event(ZProxy *proxy, ZConnection *conn)
{
  ZProxyFastpath *self = &proxy->fastpath;
  ZStream *stream;
  gchar buf1[MAX_SOCKADDR_STRING], buf2[MAX_SOCKADDR_STRING];
  ZProxyFastpathSession session;
  
  z_proxy_enter(self);

  if (self->router == NULL ||
      self->chainer == NULL)
    {
      /*LOG
        This message attempt when proxy try to use fast path, but this
        not possible. Then it's falling back to normal path.
       */
      z_proxy_log(self, CORE_ERROR, 4, "Error starting secondary session, no fastpath chainer or router defined;");
      z_proxy_leave(self);
      return NULL;
    }
  memset(&session, 0, sizeof(session));
  
  session.client_address = z_sockaddr_clone(conn->remote, FALSE);
  session.client_local = z_sockaddr_clone(conn->dest, FALSE);
  session.server_address = NULL;
  session.server_local = NULL;
  (self->router)(&session, self->router_data);
  if (self->snat)
    (self->snat)(&session, self->snat_data);
  if (self->dnat)
    (self->dnat)(&session, self->dnat_data);
  
  stream = (self->chainer)(&session, self->chainer_data);

  if (stream)
    {
      gint fd;
      
      fd = z_stream_get_fd(stream);
      z_log(NULL, CORE_SESSION, 3, 
            "Secondary session, server connection established; server_fd='%d', server_address='%s', server_local='%s'", 
            fd, 
            session.server_address ? z_sockaddr_format(session.server_address, buf1, sizeof(buf1)) : "None", 
            session.server_local ? z_sockaddr_format(session.server_local, buf2, sizeof(buf2)) : "None");
    }
  else
    {
      z_log(NULL, CORE_SESSION, 3, 
            "Secondary session, server connection failure; server_address='%s', server_local='%s'", 
            session.server_address ? z_sockaddr_format(session.server_address, buf1, sizeof(buf1)) : "None", 
            session.server_local ? z_sockaddr_format(session.server_local, buf2, sizeof(buf2)) : "None");
    }

  z_proxy_fastpath_session_destroy(&session);
  z_proxy_leave(self);
  
  return stream;
}
