/***************************************************************************
 *
 * COPYRIGHTHERE
 *
 * $Id: nullcode.c,v 1.2.2.3 2003/09/17 13:16:01 sasa Exp $
 *
 * Author  : SaSa
 * Auditor :
 * Last audited version:
 * Notes:
 *
 ***************************************************************************/

#include <zorp/code.h>
#include <zorp/zorp.h>
#include <zorp/log.h>

#include <string.h>

typedef struct _ZCodeNull
{
  ZCode super;
} ZCodeNull;

static gboolean
z_code_null_decode(ZCode *code G_GNUC_UNUSED,
                   gchar *from,
                   guint  fromlen,
                   gchar *to,
                   guint *tolen)
{
  z_enter();
  
  if (*tolen < fromlen)
    {
      return FALSE;
    }

  memcpy(to, from, fromlen);
  
  *tolen = fromlen;
  
  z_leave();
  return TRUE;
}

ZCode *
z_decode_null_new()
{
  ZCodeNull *self = g_new0(ZCodeNull, 1);
  z_enter();
  self->super.type = Z_CODE_NULL;
  self->super.decode = z_code_null_decode;
  self->super.encode = z_code_null_decode;
  z_leave();
  return &self->super;
}
