/***************************************************************************
 *
 * COPYRIGHTHERE
 *
 * $Id: packet.c,v 1.3.2.4 2003/12/02 12:12:32 sasa Exp $
 *
 * Author  : SaSa
 * Auditor :
 * Last audited version:
 * Notes:
 *
 ***************************************************************************/

#include <zorp/packet.h>
#include <zorp/log.h>

#include <string.h>

ZPacket *
z_packet_new(void)
{
  ZPacket *pack;

  z_enter();
  pack = g_new0(ZPacket, 1);
  z_leave();
    
  return pack;
}

void
z_packet_set_data(ZPacket *p, const guchar *data, guint length)
{
  p->length = length;
  p->data = g_malloc(length);
  memcpy(p->data, data, length);
}

void 
z_packet_free(ZPacket *p)
{
  z_enter();
  
  if (p->data != NULL)
    g_free(p->data);

  g_free(p);
  z_leave();
}
