/***************************************************************************
 *
 * Copyright (c) 2000, 2001 BalaBit IT Ltd, Budapest, Hungary
 * All rights reserved.
 *
 * $Id: sysdep.c,v 1.7.2.6 2003/10/29 12:02:58 sasa Exp $
 *
 * Author  : Bazsi
 * Auditor :
 * Last audited version:
 * Notes:
 *
 ***************************************************************************/

#include <zorp/sysdep.h>
#include <zorp/log.h>

#include <zorp/packsock.h>
#include <zorp/tpsocket.h>

#if ENABLE_NETFILTER_TPROXY
#include <zorp/nfiptproxy-kernel.h>
#endif

#include <stdlib.h>

gboolean
z_sysdep_init(void)
{
  gint sysdep_tproxy = Z_SD_TPROXY_LINUX22;

#if ENABLE_NETFILTER_TPROXY
   gint sock;

   system("/sbin/modprobe iptable_tproxy >/dev/null 2>&1");
   sock = socket(AF_INET, SOCK_STREAM, 0);
   if (sock != -1)
     {
       guint flags;
       socklen_t flagslen = sizeof(flags);
       if (getsockopt(sock, SOL_IP, IP_TPROXY_FLAGS, &flags, &flagslen) == -1)
         {
           if (errno != ENOPROTOOPT)
             sysdep_tproxy = Z_SD_TPROXY_NETFILTER;
         }
       else
         sysdep_tproxy = Z_SD_TPROXY_NETFILTER;
       close(sock);
     }

#elif ENABLE_LINUX22_TPROXY
  sysdep_tproxy = Z_SD_TPROXY_LINUX22;
#else
  #error "No known tproxy support"
#endif

  z_log(NULL, CORE_DEBUG, 6, "System dependant init; sysdep_tproxy='%d'", sysdep_tproxy);
  if (!z_packsock_init(sysdep_tproxy))
    return FALSE;
  if (!z_tp_socket_init(sysdep_tproxy))
    return FALSE;
    
  return TRUE;
}

void
z_sysdep_destroy(void)
{
}
