/***************************************************************************
 *
 * COPYRIGHTHERE
 *
 * $Id: authprovider.h,v 1.1.2.5 2003/03/06 19:48:25 sasa Exp $
 *
 ***************************************************************************/

#ifndef AUTHORIZATION_H_INCLUDED
#define AUTHORIZATION_H_INCLUDED

#include <zorp/policy.h>

#define MAX_COMMAND_LEN 128

#define Z_AUTH_CMD_UNKNOWN    0

#define Z_AUTH_CMD_GETMETHODS 1
#define Z_AUTH_CMD_SETMETHOD  3
#define Z_AUTH_CMD_RESPONSE   5
#define Z_AUTH_CMD_ABORT      7

#define Z_AUTH_CMD_METHODS    2
#define Z_AUTH_CMD_REQUEST    4
#define Z_AUTH_CMD_ACCEPT     6
#define Z_AUTH_CMD_REJECT     8


typedef struct _ZAuthCommand
{
  gchar command[MAX_COMMAND_LEN];
  gchar **headers;
  guint header_len;
} ZAuthCommand;
      

#define ZAuthorization ZPolicyObj
#define ZAuthProvider ZPolicyObj

void z_auth_free_command(ZAuthCommand *cmd);

PyObject *z_py_zorp_auth_get_python_from_cmd(ZAuthCommand *cmd);

gboolean z_py_zorp_auth_get_cmd_from_python(PyObject *args,
                                        ZAuthCommand *cmd);

ZAuthCommand *z_auth_provider_getmethods(ZAuthorization *self,
                                                  gchar *session_id,
                                           ZAuthCommand *cmd);
                                           
ZAuthCommand *z_auth_provider_setmethod(ZAuthorization *self,
                                                 gchar *session_id,
                                          ZAuthCommand *cmd);

ZAuthCommand *z_auth_provider_response(ZAuthorization *self,
                                                gchar *session_id,
                                         ZAuthCommand *cmd);

ZAuthCommand *z_auth_provider_abort(ZAuthorization *self,
                                             gchar *session_id,
                                      ZAuthCommand *cmd);

gboolean
z_auth_provider_check_passwd(ZAuthorization *self,
                                      gchar *session_id,
                                      gchar *username,
                                      gchar *passwd);
#endif
