/***************************************************************************
 *
 * COPYRIGHTHERE
 *
 * $Id: dimhash.h,v 1.7 2002/01/21 10:27:29 sasa Exp $
 *
 ***************************************************************************/

#ifndef ZORP_DIMHASH_H_INCLUDED
#define ZORP_DIMHASH_H_INCLUDED

#include <zorp/zorp.h>

#define DIMHASH_WILDCARD 0x001
#define DIMHASH_CONSUME  0x002

#define DIMHASH_MAX_KEYNUM    5
#define DIMHASH_MAX_KEYSIZE 100

typedef struct _ZDimHashTable
{
  GHashTable *hash;
  guint keynum;
  guint minkeynum;
  guint *flags;
} ZDimHashTable;

typedef gboolean (*ZDimHashFreeFunc)(void *value);


void z_dim_hash_key_free(int num, gchar **key);

ZDimHashTable *z_dim_hash_table_new(guint minnum, guint num, ...);
void z_dim_hash_table_free(ZDimHashTable *self, ZDimHashFreeFunc func);

gpointer z_dim_hash_table_lookup(ZDimHashTable  *self,
                                         guint   num,
                                         gchar **keys);
void     z_dim_hash_table_delete(ZDimHashTable  *self,
                                         guint   num,
                                         gchar **keys,
                              ZDimHashFreeFunc   func);
void     z_dim_hash_table_insert(ZDimHashTable  *self,
                                      gpointer   value,
                                         guint   num,
                                         gchar **keys);

gpointer z_dim_hash_table_search(ZDimHashTable  *self,
                                         guint   num,
                                         gchar **keys); /* Use * in special way */

#endif
