#ifndef ZORP_DISPATCH_H_INCLUDED
#define ZORP_DISPATCH_H_INCLUDED

#include <zorp/zorp.h>
#include <zorp/stream.h>
#include <zorp/sockaddr.h>
#include <zorp/connection.h>

typedef struct _ZDispatchEntry ZDispatchEntry;


/* dispatching priorities */

#define ZD_PRI_LISTEN 100    /* used by listeners and receivers */
#define ZD_PRI_NORMAL 0      /* used by proxies supporting several subsessions for fastpath*/
#define ZD_PRI_RELATED -100 /* used by proxies needing related connections, e.g. FTP data stream */

typedef struct _ZDispatchCommonParams
{
  gboolean threaded;
} ZDispatchCommonParams;

typedef struct _ZDispatchTCPParams
{
  ZDispatchCommonParams common;
  gboolean accept_one; /* prohibits other dispatch_registers */
  gint backlog;        /* listen backlog, the first dispatch registration counts */
} ZDispatchTCPParams;

typedef struct _ZDispatchUDPParams
{
  ZDispatchCommonParams common;
  gint session_limit;
  gchar *tracker;
} ZDispatchUDPParams;


typedef union _ZDispatchParams
{
  ZDispatchTCPParams tcp;
  ZDispatchUDPParams udp;
} ZDispatchParams;

typedef gboolean (*ZDispatchCallback)(ZConnection *conn, gpointer user_data);

ZDispatchEntry *
z_dispatch_register(gchar *session_id,
                    guint protocol, ZSockAddr *bind_addr, 
                    ZSockAddr **bound_addr,
                    gint prio, 
                    ZDispatchParams *params,
                    ZDispatchCallback cb, gpointer user_data, GDestroyNotify data_destroy);

void z_dispatch_unregister(ZDispatchEntry *de);

void z_dispatch_init(void);
void z_dispatch_destroy(void);

#endif
