/***************************************************************************
 *
 * COPYRIGHTHERE
 *
 * $Id: policy.h,v 1.20.2.12 2004/02/03 09:16:28 sasa Exp $
 *
 ***************************************************************************/

#ifndef ZORP_POLICY_H_INCLUDED
#define ZORP_POLICY_H_INCLUDED

#include <zorp/zpython.h>
#include <zorp/zorp.h>

/*+

  ZPolicyObj is a reference counted data structure, capable of holding
  a value in the policy layer. Currently it's just a simple PyObject.

  +*/
typedef PyObject ZPolicyObj;

typedef struct _ZPolicy ZPolicy;
typedef struct _ZPolicyThread ZPolicyThread;

void z_policy_thread_ready(ZPolicyThread *self);
void z_policy_thread_acquire(ZPolicyThread *self);
void z_policy_thread_release(ZPolicyThread *self);
ZPolicyThread *z_policy_thread_new(ZPolicy *policy);
void z_policy_thread_destroy(ZPolicyThread *self);
ZPolicyThread *z_policy_thread_self(void);
ZPolicy *z_policy_thread_get_policy(ZPolicyThread *self);

ZPolicy *z_policy_ref(ZPolicy *self);
void z_policy_unref(ZPolicy *self);
gboolean z_policy_boot(ZPolicy *self);
gboolean z_policy_load(ZPolicy *self);
gboolean z_policy_init(ZPolicy *self, const gchar *instance_name);
ZPolicy *z_policy_new(const gchar *filename);
void z_policy_acquire_main(ZPolicy *self);
void z_policy_release_main(ZPolicy *self);

void z_policy_raise_exception(gchar *exception_name, gchar *desc);

#define z_policy_lock z_policy_thread_acquire
#define z_policy_unlock z_policy_thread_release

extern ZPolicy *current_policy;

#define Z_UNSPEC     0 /* policy doesn't specify it, do something sensible */
#define Z_ACCEPT     1
#define Z_DENY       2
#define Z_REJECT     3 /* continue and tell the client that we didn't do it */
#define Z_ABORT      4 /* abort the connection */
#define Z_DROP       5 /* continue and don't do it */
#define Z_POLICY     6 /* Policy level will decide what to do */

#define z_policy_none Py_None

#define z_policy_var_build(format, args...) Py_BuildValue(format, ##args)
#define z_policy_var_parse(v, format, args...) PyArg_Parse(v, format, ##args)
#define z_policy_var_parse_tuple(v, format, args...) PyArg_ParseTuple(v, format, ##args)
#define z_policy_var_str(v) PyObject_Str(v)
#define z_policy_var_ref(v)   Py_XINCREF(v)
#define z_policy_var_unref(v) Py_XDECREF(v)
#define z_policy_var_repr(v)  PyObject_Repr(v)

#define z_policy_seq_check(v) PySequence_Check(v)
#define z_policy_seq_new(s) PyTuple_New(s)
#define z_policy_seq_getitem(v, i) PySequence_GetItem(v, i)
#define z_policy_seq_setitem(v, i, x) PySequence_SetItem(v, i, x)
#define z_policy_seq_length(v) PyObject_Length(v)

#define z_policy_list_new(n) PyTuple_New(n)
#define z_policy_list_getitem(l, i) PyTuple_GetItem(l, i)
#define z_policy_list_setitem(l, i, x) PyTuple_SetItem(l, i, x)

#define z_policy_str_check(v) PyString_Check(v)
#define z_policy_str_as_string(v) PyString_AsString(v)

#define z_policy_error_clear() PyErr_Clear()

ZPolicyObj *z_policy_call(ZPolicyObj *handler, char *name, ZPolicyObj *args, gboolean *called, gchar *session_id);
int z_policy_event(ZPolicyObj *handler, char *name, ZPolicyObj *args, gchar *session_id);
PyObject *z_policy_call_object(PyObject *func, PyObject *args, gchar *session_id);
gint z_policy_setattr(ZPolicyObj *handler, char *name, ZPolicyObj *value);
ZPolicyObj *z_policy_getattr(ZPolicyObj *handler, char *name);
PyObject *z_session_getattr(PyObject *handler, char *name);

#endif
