/***************************************************************************
 *
 * COPYRIGHTHERE
 *
 * $Id: zpython.c,v 1.65.2.8 2003/04/26 09:55:55 sasa Exp $
 *
 * Author  : Bazsi
 * Auditor : 
 * Last audited version: 
 * Notes:
 *
 ***************************************************************************/

#include <zorp/zpython.h>

static PyThreadState *initial_thread;

/*+

  Initialize the low level Python-Zorp interface. Called by the Python
  policy implementation.

  Parameters:
    none

  Returns:
    TRUE if initialization was successful

  +*/
gboolean
z_python_init(void)
{
  char buf[2048];

  if (getenv("PYTHONPATH") == NULL)
    {
      snprintf(buf, sizeof(buf), "PYTHONPATH=%s", ZORP_DATADIR "/pylib");
    }
  else
    {
      snprintf(buf, sizeof(buf), "PYTHONPATH=%s:%s", ZORP_DATADIR "/pylib", getenv("PYTHONPATH"));
    }
  putenv(buf);

  Py_Initialize();
  PyEval_InitThreads();
  
  initial_thread = PyEval_SaveThread();
  return TRUE;
}

/*+

  Called to deinitialize the Python-ZORP interface.

  Parameters:
    none
  
  Returns:
    TRUE if deinitialization was successful.

  +*/
gboolean
z_python_destroy(void)
{
  PyEval_AcquireThread(initial_thread);
  Py_Finalize();
  return TRUE;
}

/*+

  Lock the python interpreter, without setting the current thread pointer.

  Parameters:
    none

  Returns:
    none
  +*/
void 
z_python_lock(void)
{
  PyEval_AcquireLock();
}

/*+

  Unlock the python interpreter.

  Parameters:
    none

  Returns:
    none

  +*/
void 
z_python_unlock(void)
{
  PyEval_ReleaseLock();
}

