/***************************************************************************
 *
 * COPYRIGHTHERE
 *
 * $Id: http.h,v 1.57.2.5 2003/09/16 19:41:50 sasa Exp $
 *
 ***************************************************************************/

#ifndef ZORP_MODULES_HTTP_H_INCLUDED
#define ZORP_MODULES_HTTP_H_INCLUDED

#include <zorp/zorp.h>
#include <zorp/proxy.h>
#include <zorp/streamline.h>
#include <zorp/authprovider.h>
#include <zorp/dimhash.h>
#include <zorp/poll.h>

#define HTTP_REQ_ACCEPT       1
#define HTTP_REQ_DENY         2
#define HTTP_REQ_REJECT       3
#define HTTP_REQ_ABORT        4
#define HTTP_REQ_POLICY       6

#define HTTP_RSP_ACCEPT       1
#define HTTP_RSP_DENY         2
#define HTTP_RSP_REJECT       3
#define HTTP_RSP_ABORT        4
#define HTTP_RSP_POLICY       6

#define HTTP_DEBUG     "http.debug"
#define HTTP_ERROR     "http.error"
#define HTTP_POLICY    "http.policy"
#define HTTP_REQUEST   "http.request"
#define HTTP_RESPONSE  "http.response"
#define HTTP_VIOLATION "http.violation"

#define HTTP_HDR_ACCEPT        1
#define HTTP_HDR_ABORT         4
#define HTTP_HDR_DROP          5
#define HTTP_HDR_POLICY        6
#define HTTP_HDR_CHANGE_NAME   100
#define HTTP_HDR_CHANGE_VALUE  101
#define HTTP_HDR_CHANGE_BOTH   102
#define HTTP_HDR_CHANGE_REGEXP 103
#define HTTP_HDR_INSERT        104
#define HTTP_HDR_REPLACE       105

#define HTTP_CONNECTION_CLOSE		0
#define HTTP_CONNECTION_KEEPALIVE	1

#define HTTP_REQTYPE_SERVER        0     /* simple server request */
#define HTTP_REQTYPE_PROXY         1     /* proxy request */

#define HTTP_REQ_FLG_STOP       1
#define HTTP_REQ_FLG_HEAD       2
#define HTTP_REQ_FLG_ASTERIX    4
#define HTTP_REQ_FLG_CONNECT    8

#define HTTP_RESP_FLG_CONTINUE  1
#define HTTP_RESP_FLG_NODATA    2
#define HTTP_RESP_FLG_STOP      4

#define HTTP_MSG_OK             0
#define HTTP_MSG_CLIENT_SYNTAX  1
#define HTTP_MSG_SERVER_SYNTAX  2
#define HTTP_MSG_POLICY_SYNTAX  3
#define HTTP_MSG_POLICY_VIOLATION 4
#define HTTP_MSG_INVALID_URL    5
#define HTTP_MSG_CONNECT_ERROR  6
#define HTTP_MSG_IO_ERROR	7
#define HTTP_MSG_AUTH_REQUIRED  8
#define HTTP_MSG_CLIENT_TIMEOUT 9
#define HTTP_MSG_SERVER_TIMEOUT 10
#define HTTP_MSG_DEFAULT        11

#define HTTP_EP_DOWN            4

#define HTTP_DEBUG "http.debug"
#define HTTP_ERROR "http.error"
#define HTTP_POLICY "http.policy"
#define HTTP_REQUEST "http.request"
#define HTTP_RESPONSE "http.response"

struct _HttpProxy;

typedef gboolean (*HttpTransferFilter)(struct _HttpProxy *self, gint from, gint to, gint content_length);

#define HTTP_MAX_LINE           4096
#define HTTP_MAX_URL            4096
#define HTTP_BLOCKSIZE		65535
#define HTTP_MAX_EMPTY_REQUESTS 3

#define PROXY_BUFSIZE 65535

typedef struct _HttpIOBuffer
{
  gchar buf[PROXY_BUFSIZE];
  guint ofs, end;
} HttpIOBuffer;

typedef struct _HttpHeader
{
  GString *name;
  GString *value;
  gboolean present;
} HttpHeader;

typedef struct _HttpHeaders
{
  GList *list;
  GHashTable *hash;
  GString *flat;
} HttpHeaders;

typedef struct _HttpProxy
{
  ZProxy super;
  ZStackedProxy *stacked;
  guint timeout;
  guint timeout_request;

  HttpHeaders headers[EP_MAX];
  guint max_header_lines;
  
  GString *current_header_name, *current_header_value;
  
  ZAuthProvider *auth;
  gboolean auth_inband_supported;
  GString *auth_realm;
  GString *old_auth_header;

  gchar request_method[16];
  guint request_flags;
  GString *request_url;
  gchar request_version[16];
  guint request_type;
  GString *target_port_range;

  gchar connected_server[256];
  guint connected_port;

  gchar remote_server[256];
  guint remote_port;

  guint default_port;
  
  gchar response_version[16];
  gchar response[4];
  guint response_flags;
  gint response_code;
  gchar response_msg[256];
  
  /* 0:close 1:keep-alive */
  gboolean connection_mode;        
  
  /* 0:non-transparent 1:transparent */
  gboolean transparent_mode;       
  
  gboolean permit_server_requests;
  gboolean permit_proxy_requests;
  gboolean permit_unicode_url;

  /* address, or hostname of the parent proxy, if empty direct connection is used */
  GString *parent_proxy;        
  guint parent_proxy_port;

  /* rewrite host header when redirection is done */
  gboolean rewrite_host_header;   
  
  /* require the existance of the Host: header */
  gboolean require_host_header;   
  
  /* permit responses with no terminating CRLF and data */
  gboolean permit_null_response;  
  
  /* 0: accept rfc incompliant headers, 1: require rfc compliance */
  gboolean strict_header_checking; 

  guint proto_version[EP_MAX];          /* version (updated by request and response) : 0x major minor (0x0009 0x0100 0x0101) */

  guint max_line_length;
  guint max_hostname_length;
  guint max_url_length;
  guint max_keepalive_requests;
  guint request_count;
  guint max_body_length;
  guint max_chunk_length;

  GHashTable *request_method_policy;     // policy chain to process on request methods
  GHashTable *request_header_policy;     // policy chain to process on request headers
  ZDimHashTable *response_policy;           // policy chain to process on response codes
  GHashTable *response_header_policy;    // policy chain to process on response headers
  
  gint content_length;
  guint transfer_from, transfer_to;
  HttpTransferFilter transfer_filter;
#if 0
  guint transfer_state[EP_MAX], transfer_state_next[EP_MAX];
  guint transfer_length[EP_MAX];
  HttpIOBuffer *transfer_buffer[EP_MAX];
  gchar *entity_buffer;
  gint entity_len;
  gboolean expect_data;
#endif

  gint error_code;
  guint error_status;
  gboolean error_silent;
  GString *error_info;
  GString *error_headers;
  GString *error_files_directory;
    
} HttpProxy;


typedef guint (*HttpHeaderFilter)(HttpProxy *self, GString *header_name, GString *header_value);

guint http_read(HttpProxy *self, guint side, gchar *buf, size_t buflen, guint *bytes_read);
guint http_write(HttpProxy *self, guint side, gchar *buf, size_t buflen);

gboolean http_data_transfer_setup(HttpProxy *self, guint from, guint to, gboolean expect_data);

gboolean http_data_transfer(HttpProxy *self);

int http_proto_request_lookup(char *req);
int http_proto_response_lookup(char *resp);

gboolean
http_split_url(gchar *url, 
	       gchar **proto, guint *proto_len,
	       gchar **user, guint *user_len,
	       gchar **passwd, guint *passwd_len,
	       gchar **host, guint *host_len,
	       guint *port,
	       gchar **file, guint *file_len);

gboolean
http_check_url(gchar *str, gboolean permit_unicode);

gboolean
http_lookup_header(HttpHeaders *headers, gchar *what, HttpHeader **p);

gboolean
http_fetch_headers(HttpProxy *self, int side);

gboolean
http_filter_headers(HttpProxy *self, guint side, HttpHeaderFilter filter);

gboolean
http_flat_headers(HttpHeaders *hdrs);

void
http_clear_headers(HttpHeaders *hdrs);

void
http_init_headers(HttpHeaders *hdrs);

void
http_destroy_headers(HttpHeaders *hdrs);

HttpHeader *
http_add_header(HttpHeaders *hdrs, gchar *name, gint name_len, gchar *value, gint value_len);

void
http_log_headers(HttpProxy *self, gint side, gchar *tag);


gboolean
http_split_request(HttpProxy *self, gchar *line, guint length);
gboolean
http_split_response(HttpProxy *self, gchar *line, guint line_length, gboolean *reply09);
gboolean
http_parse_version(HttpProxy *self, gint side, gchar *version_str);

gboolean
http_hash_get_type(ZPolicyObj *tuple, guint *filter_type);

#endif
